clear all
close all

load('cdif.mat')
load('empirical_results.mat')

scaling={'cum'};

h=linspace(0,H,H+1);
zero=zeros(1,H+1);

% cdif
%'H-L','H-M','M-L'

figure(1)
subplot(2,2,1)
index=1;
plot(h ,-100*results(index).lin.(scaling{1}).coef(1:H+1),'r');
hold on
h1 = plot(time,cum_Agg_C_IRF_dif(:,3)*100,'k--');
plot(h,-100*results(index).lin.(scaling{1}).CIhigh(1:H+1),'b-.');
plot(h,-100*results(index).lin.(scaling{1}).CIlow(1:H+1),'b-.');
plot(h, zero,'k');
set(h1,'LineWidth',1.1);
%n=get(gca,'ytick');
xlim([0 15])
%yticks([-1 0 1 2 3 4 5])
ylim([-2 6])
%title('Low income')
set(gca,'FontSize',12)
title('Middle - Low ','FontSize',12)
legend('Empirical','Model')
xlabel('Quarters')
%title('Owned with mortgage')
%title('consumption')
%title('Real consumption')
%set(gca,'XTick', [0 10 20])
box on
hold off

dim = [0.125 0.875 .1 .1];
str = '(%)';
annotation('textbox',dim,'String',str,'FontSize',12,'EdgeColor','none');

subplot(2,2,2)
index=2;
hold on
h2=plot(time,cum_Agg_C_IRF_dif(:,1)*100,'k--')
plot(h ,-100*results(index).lin.(scaling{1}).coef(1:H+1),'r');
plot(h,-100*results(index).lin.(scaling{1}).CIhigh(1:H+1),'b-.');
plot(h,-100*results(index).lin.(scaling{1}).CIlow(1:H+1),'b-.');
plot(h, zero,'k');
set(h2,'LineWidth',1.1);
%n=get(gca,'ytick');
xlim([0 15])
ylim([-2 6])
%title('Middle income')
set(gca,'FontSize',12)
title('High - Low ','FontSize',12)
xlabel('Quarters')
%title('Real wage ')
%title('Owned without mortgage')
%title('durables')
%set(gca,'XTick', [0 10 20])
box on
hold off

subplot(2,2,3)
index=3;
hold on
h3=plot(time,cum_Agg_C_IRF_dif(:,2)*100,'k--')
plot(h ,-100*results(index).lin.(scaling{1}).coef(1:H+1),'r');
plot(h,-100*results(index).lin.(scaling{1}).CIhigh(1:H+1),'b-.');
plot(h,-100*results(index).lin.(scaling{1}).CIlow(1:H+1),'b-.');
plot(h, zero,'k');
set(h3,'LineWidth',1.1);
%n=get(gca,'ytick');
xlim([0 15])
ylim([-2 6])
%title('High income')
set(gca,'FontSize',12)
title('High - Middle ','FontSize',12)
%title('Real transfer ')
%title('Rented')
%title('non durables')
xlabel('Quarters')

%set(gca,'XTick', [0 10 20])
box on
hold off

print(gcf,'-djpeg','-r350','Model_Baseline.jpg')