
% Middle-Low High-Middle High-Low 
emp10q = [0.70, 1.48, 2.12];
emp10q_UB = [1.46, 2.15, 3.20];
emp10q_LB = [-0.06, 0.81, 1.04];
emp10q_eb = (emp10q_UB-emp10q_LB)/2;

Model_Baseline = [0.74, 0.73, 1.48];%    1.4813    0.7342    0.7471
Model_Illquid = [0.46, 0.84, 1.31];%   1.3055    0.8470    0.4585
Model_Transfer = [0.15, -0.16, -0.01];%   -0.0147   -0.1635    0.1487
Model_NoIA_NoT = [-0.31, -0.04, -0.35];%   -0.3543   -0.0421   -0.3121


figure(1)
hold on
h(1) = errorbar(emp10q,emp10q_eb,'ks');
h(2) = scatter([1 2 3],emp10q,100,'k','filled');
h(3) = scatter([1 2 3],Model_Baseline,100,'r','s','filled');
h(4) = plot([0.5 3.5], [0 0], 'k');

legend(h([2 3]),'Empirical','Model','Location','Northwest');

xticks([1 2 3])
xticklabels({'Middle-Low' 'High-Middle' 'High-Low'})
xlim([0.5 3.5])
ylim([-1 4])

set(gca,'XTick', [1 2 3])
set(gca,'FontSize',20)
box on
hold off

plotsize = 50;

figure(2)
subplot(2,2,1)
hold on
h(1) = errorbar(emp10q,emp10q_eb,'ks');
h(2) = scatter([1 2 3],emp10q,plotsize,'k','filled');
h(3) = scatter([1 2 3],Model_NoIA_NoT,plotsize,'r','filled','s');
h(4) = plot([0.5 3.5], [0 0], 'k');

legend(h([2 3]),'Empirical','Model','Location','Northwest');

xticks([1 2 3])
xticklabels({'M-L' 'H-M' 'H-L'})
xlim([0.5 3.5])
ylim([-1 4])
ylabel('No transfer')
title('No illiquid')

set(gca,'XTick', [1 2 3])
set(gca,'FontSize',12)
box on
hold off

dim = [0.125 0.88 .1 .1];
str = '(%)';
annotation('textbox',dim,'String',str,'FontSize',12,'EdgeColor','none');

subplot(2,2,2)
hold on
h(1) = errorbar(emp10q,emp10q_eb,'ks');
h(2) = scatter([1 2 3],emp10q,plotsize,'k','filled');
h(3) = scatter([1 2 3],Model_Illquid,plotsize,'r','filled','s');
h(4) = plot([0.5 3.5], [0 0], 'k');


xticks([1 2 3])
xticklabels({'M-L' 'H-M' 'H-L'})
xlim([0.5 3.5])
ylim([-1 4])
title('With illiquid')

set(gca,'XTick', [1 2 3])
set(gca,'FontSize',12)
box on
hold off


subplot(2,2,3)
hold on
h(1) = errorbar(emp10q,emp10q_eb,'ks');
h(2) = scatter([1 2 3],emp10q,plotsize,'k','filled');
h(3) = scatter([1 2 3],Model_Transfer,plotsize,'r','filled','s');
h(4) = plot([0.5 3.5], [0 0], 'k');


xticks([1 2 3])
xticklabels({'M-L' 'H-M' 'H-L'})
xlim([0.5 3.5])
ylim([-1 4])
ylabel('With transfer')


set(gca,'XTick', [1 2 3])
set(gca,'FontSize',12)
box on
hold off


subplot(2,2,4)
hold on
h(1) = errorbar(emp10q,emp10q_eb,'ks');
h(2) = scatter([1 2 3],emp10q,plotsize,'k','filled');
h(3) = scatter([1 2 3],Model_Baseline,plotsize,'r','filled','s');
h(4) = plot([0.5 3.5], [0 0], 'k');


xticks([1 2 3])
xticklabels({'M-L' 'H-M' 'H-L'})
xlim([0.5 3.5])
ylim([-1 4])

set(gca,'XTick', [1 2 3])
set(gca,'FontSize',12)
box on
hold off
