%% File to do the regression for income inequality and monetary policy. Originally from Tenreyro & Thwaites
%25 September 2017

clear all
close all

%% construct the data and shocks

startS=51;
endS=169;
samplelength=endS-startS+1; % Sample period - dates of shocks - need to ensure data runs L periods earlier and H periods later

construct_data

%% Create the baseline set of data and parameters

% Load data
clear all
close all
load data.mat FFR LHS startS endS samplelength shocks Controls

% Parameters
includetrend=1;             % 1 includes a trend
H=26;
CI=.90;                     % Confidence intervals in charts (as decimal fraction)
Xlags=2;                    % Number of lags of control variables
Rlags=2;                    % Number of lags of policy variables
scaling=1;                  % whether scaled parameters are calculated (set to zero to save time if you don't need them)
trend_dim = 2;              % highest order of the time polynomial

% weights for smoothing the results
weight=zeros(H+1,H+1);
weight(1,1)=1; % End-points are not MAs
weight(H+1,H+1)=1;
for h=2:H
    weight(h,h-1:h+1)=[1/3 1/3 1/3]; % Centred three-period moving average
end
cumweight=tril(ones(H+1,H+1));
trend=linspace(1,samplelength,samplelength)';
trend0=trend;
if trend_dim > 1
    for order = 2:1:trend_dim
        trend = [trend trend0.^order];
    end
end


save baseline.mat           % baseline workspace

%% Run the baseline simulation
clear all
close all
load baseline.mat
LHSindices=[1 2 3];
LHS=LHS(:,LHSindices);

shocksmod_Romer = shocks(startS:endS,1);
shocksmod_Fut = shocks(startS:endS,2);
shocksmod_Shadow = shocks(startS:endS,3);

[results]=stlpm_simple025_noC(FFR,shocksmod_Shadow,LHS,trend,Xlags,Rlags,includetrend,H,startS,endS,scaling,weight,cumweight)
stlpm_inference025
save baseline_results.mat

%% Make graphs
clear all
close all
load baseline_results.mat

standardcharts1_fig(results,H,{'smoothed'})
