
% Import the data
[~, ~, raw] = xlsread('C:\Users\nfumi\Desktop\HANKComputation\TheModel\PriceIRF\LLP\AggregateRegression\data_import.xlsx','Var','B2:L255');
raw(cellfun(@(x) ~isempty(x) && isnumeric(x) && isnan(x),raw)) = {''};

% Replace non-numeric cells with NaN
R = cellfun(@(x) ~isnumeric(x) && ~islogical(x),raw); % Find non-numeric cells
raw(R) = {NaN}; % Replace non-numeric cells


% Create output variable
Temp_var = reshape([raw{:}],size(raw));
shocks = Temp_var(:,1:3);
FFR = Temp_var(:,4);
LHS = Temp_var(:,5:7);
Controls = Temp_var(:,9:11);

clearvars raw R;

save data.mat %R E LHS alt_states names dates startS endS samplelength