clear all
close all

readxls = 0; % Import the data

if readxls == 1
[~, ~, raw] = xlsread('C:\Users\nfumi\Desktop\HANKComputation\TheModel\PriceIRF\Importdata.xlsx','Sheet1','A2:D22');
Temp_var = reshape([raw{:}],size(raw));
Nq_data = Temp_var(:,1);
rb_data = Temp_var(:,2);
w_data = Temp_var(:,3);
ra_data = Temp_var(:,4);

clearvars raw Temp_var;

save data.mat 
end

load data.mat

%regression
X_data = [ones(size(Nq_data)) Nq_data Nq_data.^2 Nq_data.^3 Nq_data.^4];
b_rb = regress(rb_data,X_data);
rb_IRF = X_data*b_rb;
b_w = regress(w_data,X_data);
w_IRF = X_data*b_w;
b_ra = regress(ra_data,X_data);
ra_IRF = X_data*b_ra;

%Ignore small responses
rb_IRF(11:end) = 0;
w_IRF(19:end) = 0;
ra_IRF(21:end) = 0;

price_IRF = [rb_IRF w_IRF ra_IRF];

save price_IRF.mat X_data b_rb b_w b_ra

