d = I_dBF.*dBF + I_dFB.*dFB + I_dBB.*dBB;
m = d + xi*w*zzz + Ra.*aaa;
s = (1-xi)*(1-tau)*w*zzz + Rb.*bbb - d - two_asset_kinked_cost(d,aaa) - c + GTTT;
X = -min(s,0)/db;
Y = min(s,0)/db - max(s,0)/db;
Z = max(s,0)/db;

for i = 1:Nz
    centdiag(:,i) = reshape(Y(:,:,i),I*J,1);
end

lowdiag(1:I-1,:) = X(2:I,1,:);
updiag(2:I,:) = Z(1:I-1,1,:);
for j = 2:J
    lowdiag(1:j*I,:) = [lowdiag(1:(j-1)*I,:);squeeze(X(2:I,j,:));zeros(1,Nz)];
    updiag(1:j*I,:) = [updiag(1:(j-1)*I,:);zeros(1,Nz);squeeze(Z(1:I-1,j,:))];
end

for nz=1:Nz
    BBi{nz}=spdiags(centdiag(:,nz),0,I*J,I*J)+spdiags([updiag(:,nz);0],1,I*J,I*J)+spdiags([lowdiag(:,nz);0],-1,I*J,I*J);
end

BB = [BBi{1}, sparse(I*J,I*J*(Nz-1))];
for nz=2:Nz
BB = [BB; sparse(I*J,I*J*(nz-1)), BBi{nz}, sparse(I*J,I*J*(Nz-nz))];
end

%CONSTRUCT MATRIX AA SUMMARIZING EVOLUTION OF a
chi = -min(m,0)/da;
yy =  min(m,0)/da - max(m,0)/da;
zeta = max(m,0)/da;


%MATRIX AAi
for nz=1:Nz
    %This will be the upperdiagonal of the matrix AAi
    AAupdiag=zeros(I,1); %This is necessary because of the peculiar way spdiags is defined.
    for j=1:J
        AAupdiag=[AAupdiag;zeta(:,j,nz)];
    end
    
    %This will be the center diagonal of the matrix AAi
    AAcentdiag= yy(:,1,nz);
    for j=2:J-1
        AAcentdiag=[AAcentdiag;yy(:,j,nz)];
    end
    AAcentdiag=[AAcentdiag;yy(:,J,nz)];
    
    %This will be the lower diagonal of the matrix AAi
    AAlowdiag=chi(:,2,nz);
    for j=3:J
        AAlowdiag=[AAlowdiag;chi(:,j,nz)];
    end
    
    %Add up the upper, center, and lower diagonal into a sparse matrix
    AAi{nz} = spdiags(AAcentdiag,0,I*J,I*J)+spdiags(AAlowdiag,-I,I*J,I*J)+spdiags(AAupdiag,I,I*J,I*J);
    
end

AA = [AAi{1}, sparse(I*J,I*J*(Nz-1))];
for nz=2:Nz
AA = [AA; sparse(I*J,I*J*(nz-1)), AAi{nz}, sparse(I*J,I*J*(Nz-nz))];
end

A = AA + BB + Bswitch;
