clear all; close all; clc;
global chi0 chi1 ga acost
tic;

makefig = 1;
save_result = 0;
transition_calculation = 1;
price_IRF = 1;
income_state = 1;
illiquid_state = 1;
cal_check = 1;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% Set Parameters  %%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

rb_pos = 0.01 /4; 
rb_neg = 0.1094 /4; 

rho = 0.0789 /4; 
chi0 = 0.4531; 
chi1 = 0.8593; 
acost = 10^(1.1); 
mod_ra = 10; 
mod_ra_alpha = 1.010; 
xi = 0;

if illiquid_state==1
ra = 0.07 /4;  
elseif illiquid_state==0
ra = 0;  
end
ga = 1.001; 

crit = 10^(-9); 
Delta = 20; 
maxit = 500;

T = 30; 
N = 60; 
dt = T/N;

%Income process (two-state Poisson process):
w = 1; 
Nz = 9;

income_process_code

%grids
I = 70;
bmin = -4*z(1)*w; 
bmax = 30; 
b = linspace(bmin,bmax,I)';
db = (bmax-bmin)/(I-1);

J= 150; 
amin = 0;
amax = 100; 
a = linspace(amin,amax,J);
da = (amax-amin)/(J-1);

%%%%%%%%%code%%%%%%%%%
initialize
%%%%%%%%%code%%%%%%%%%

%PRICE IRF FROM EMPIRICAL
w_t = w + w*w_IRF/100;
rb_pos_t = rb_pos + rb_IRF/100 /4;
rb_neg_t = rb_neg + rb_IRF/100 /4;
ra_t = ra + ra_IRF*(0.56)/100 /4; 

%ALL ZERO
%w_t = w*ones(N,1);
%rb_pos_t = rb_pos*ones(N,1);
%rb_neg_t = rb_neg*ones(N,1);
%ra_t = ra*ones(N,1); 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% Solve steady state  %%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for n=1:maxit
    
    %%%%%%%%%code%%%%%%%%%
    solve_HJB
    %%%%%%%%%code%%%%%%%%%

    dist(n) = max(max(max(abs(Vchange))));
    disp(['Value Function, Iteration ' int2str(n) ', max Vchange = ' num2str(dist(n))]);
    if dist(n)<crit
        disp('Value Function Converged, Iteration = ')
        disp(n)
        break
    end
    
end
toc

%%%%%%%%%%%%%%%%%%%%%%%%%%%
% STATIONARY DISTRIBUTION %
%%%%%%%%%%%%%%%%%%%%%%%%%%%
% RECONSTRUCT TRANSITION MATRIX WITH SIMPLER UPWIND SCHEME

%%%%%%%%%code%%%%%%%%%
make_trans_matrix_g
%%%%%%%%%code%%%%%%%%%

% Solve system:
M = I*J*Nz;
AT = A';
[g_stacked,val] = eigs(AT,1,'lr');
g_sum = g_stacked'*ones(M,1)*da*db;
g_stacked = g_stacked./g_sum;
for nz=1:Nz
g(:,:,nz) = reshape(g_stacked(I*J*(nz-1)+1:I*J*nz),I,J);
end

%Save the staeady state values
v_st = v;
c_st = c;
A_st = A;
s_st = s;
d_st = d;
g_st = g;
g_stacked_st = g_stacked;
GTTT_ss = GTTT;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% Transition dynamics %%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if transition_calculation==1

v = v_st;
Delta = dt;

for n=N:-1:1
    v_t{n} = v;
    %allocate price
    w = w_t(n);
    ra = ra_t(n);
    rb_pos = rb_pos_t(n);
    rb_neg = rb_neg_t(n);
    
    %%%%%tax%%%%%
    %1:keep transfer change tax rate
    %tau = sum(GT)/(sum(z)*w);
    
    %2:keep tax rate change transfer(lumpsum)
    %GTTT = GTTT_ss + tau*(w-w_st);

    % 3: keep tax rate and transfer 4:notax
    % no change
    
    %%%%%tax%%%%%

    Rb = rb_pos.*(bbb>0) + rb_neg.*(bbb<0);
    raa = ra.*ones(1,J);
    raa = ra.*(1 - (mod_ra_alpha.*amax./a).^(1-mod_ra));
    for nz=1:Nz
    Ra(:,:,nz) = ones(I,1)*raa;
    end
    
    %%%%%%%%%code%%%%%%%%%
    solve_HJB_trans
    %%%%%%%%%code%%%%%%%%%

    %construct A{t} for the g
    %%%%%%%%%code%%%%%%%%%
    make_trans_matrix_g_trans
    %%%%%%%%%code%%%%%%%%%
    
    A_t{n} = A;
    c_t{n} = c; 
    s_t{n} = s; 
    d_t{n} = d; 

    disp(['Transition Value Function, Iteration ' int2str(n)]);
    
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%
% TRANSITION DISTRIBUTION %
%%%%%%%%%%%%%%%%%%%%%%%%%%%
% RECONSTRUCT TRANSITION MATRIX WITH SIMPLER UPWIND SCHEME

gg_t{1}=g_stacked_st;
for n=1:N
    AT=A_t{n}';
    %Implicit method in Updating Distribution.
    gg_t{n+1}= (speye(Nz*I*J) - AT*dt)\gg_t{n};
    %gg_t{n+1}=gg_t{n}+AT*gg_t{n}*dt; %This is the explicit method.
    %check(n) = gg(:,n)'*ones(2*I,1)*da;
    g_stacked = gg_t{n+1};
    g_sum = g_stacked'*ones(M,1)*da*db;
    g_stacked = g_stacked./g_sum;
    for nz=1:Nz
    g(:,:,nz) = reshape(g_stacked(I*J*(nz-1)+1:I*J*nz),I,J);
    end
    g_t{n} = g;
    disp(['Transition Distribution, Iteration ' int2str(n)]);
end


%calculate consumption IRF
%%%%%%%%%code%%%%%%%%%
calculateCIRF
%%%%%%%%%code%%%%%%%%%
end

toc


    SS_distribution_g = squeeze(sum(sum(g_st,1),2)*da*db);
    disp(['Steady state distributions are']);
    disp([SS_distribution_g]);

    SS_ga = squeeze(sum(g_st,1)*da*db);
    SS_gb = squeeze(sum(g_st,2)*da*db);

    g_st_HML(:,:,1) = g_st(:,:,1) + g_st(:,:,2) + g_st(:,:,3);
    g_st_HML(:,:,2) = g_st(:,:,4) + g_st(:,:,5) + g_st(:,:,6);
    g_st_HML(:,:,3) = g_st(:,:,7) + g_st(:,:,8) + g_st(:,:,9);
    
    SS_ga_HML(:,1) = SS_ga(:,1) + SS_ga(:,2) + SS_ga(:,3);
    SS_ga_HML(:,2) = SS_ga(:,4) + SS_ga(:,5) + SS_ga(:,6);
    SS_ga_HML(:,3) = SS_ga(:,7) + SS_ga(:,8) + SS_ga(:,9);

    SS_gb_HML(:,1) = SS_gb(:,1) + SS_gb(:,2) + SS_gb(:,3);
    SS_gb_HML(:,2) = SS_gb(:,4) + SS_gb(:,5) + SS_gb(:,6);
    SS_gb_HML(:,3) = SS_gb(:,7) + SS_gb(:,8) + SS_gb(:,9);

    %NO_a = SS_ga(1,:)./SS_distribution_g';
    %disp(['Fraction of HH without illiquids']);
    %disp([NO_a]);

    negative_b = b<0;
    negative_b = sum(negative_b);
    Borriwng_b = zeros(1,Nz);

    for n=1:negative_b
    Borriwng_b = Borriwng_b + SS_gb(n,:);
    end

    Borriwng_b_a0=zeros(Nz,1);

    for n=1:negative_b
    Borriwng_b_a0 = Borriwng_b_a0 + squeeze(g_st(n,1,:)*da*db);
    end

    Zero_b = SS_gb(negative_b+1,:);
    Zero_ab = squeeze(g_st(negative_b+1,1,:)*da*db);

    pHtM_dist = zeros(1,1,Nz);
    
    for n=1:negative_b+1
    pHtM_dist = pHtM_dist + g_st(negative_b,1,:)*da*db;
    end    
    
    pHtM = squeeze(pHtM_dist);

    HtM = zeros(1,Nz);

    for n=1:negative_b+1
    HtM = HtM + SS_gb(n,:);
    end    
    
    
    disp(['Fraction of HH with liquid borrowing(target 0.15)']);
    disp([Borriwng_b sum(Borriwng_b)]);

    disp(['Fraction of HH with b=0 and a=0 (target 0.10)']);
    disp([(Zero_ab)' sum((Zero_ab))]);

    disp(['Fraction of HH with b=0 and a>0 (target 0.20)']);
    disp([(Zero_b - Zero_ab') sum((Zero_b - Zero_ab'))]);

    disp(['Fraction of HH with b<=0 and a=0 (target 0.13)']);
    disp([(pHtM)' sum((pHtM))]);

    disp(['Fraction of HH with b<=0 and a>0 (target 0.26)']);
    disp([(HtM - pHtM') sum((HtM - pHtM'))]);

    cum_SS_gb = sum(SS_gb,2);
    for i=2:I
    cum_SS_gb(i) = cum_SS_gb(i-1) + cum_SS_gb(i);
    end
    Median_b = sum(cum_SS_gb<0.5);
    
    cum_SS_ga = sum(SS_ga,2);
    for j=2:J
    cum_SS_ga(j) = cum_SS_ga(j-1) + cum_SS_ga(j);
    end
    Median_a = sum(cum_SS_ga<0.5);

    if Median_a==0
    Median_a=1;
    end

    disp(['Median illiquid asset']);
    disp([a(Median_a)]);

    Mean_a = a*(sum(SS_ga,2));
    Mean_b = b'*(sum(SS_gb,2));
    target_a = 2.92*(4 + 4*Mean_a*ra + 4*Mean_b*rb_pos);
    target_b = 0.26*(4 + 4*Mean_a*ra + 4*Mean_b*rb_pos);
    target_Mean_wealth = 4.1*(4 + 4*Mean_a*ra + 4*Mean_b*rb_pos);
    Mean_wealth = Mean_a + Mean_b;
    target_Med_wealth = 1.5*(4 + 4*Mean_a*ra + 4*Mean_b*rb_pos);
    Med_wealth = a(Median_a) + b(Median_b)
    
    disp(['Mean illiquid asset (target 11.6) Mean liquid asset (target 1.04)']);
    disp([target_a target_b]);
    disp([Mean_a Mean_b]); 
    disp([Mean_a/(4 + 4*Mean_a*ra + 4*Mean_b*rb_pos) Mean_b/(4 + 4*Mean_a*ra + 4*Mean_b*rb_pos)]);

    disp(['Mean asset   Median asset ']);
    disp([target_Mean_wealth target_Med_wealth]);
    disp([Mean_wealth Med_wealth]); 
    disp([Mean_wealth/(4 + 4*Mean_a*ra + 4*Mean_b*rb_pos) Med_wealth/(4 + 4*Mean_a*ra + 4*Mean_b*rb_pos)]); %target 2.9*4 =11.6 

    trans_cost = two_asset_kinked_cost(d_st,aaa);
    Aggtranscost = trans_cost.*g_st*da*db;
    Aggtranscost = sum(sum(sum(Aggtranscost)));
    disp(['transaction cost']);
    disp([Aggtranscost Aggtranscost/(4 + 4*Mean_a*ra + 4*Mean_b*rb_pos)]); 

    cal_percentile_share

    disp(['share of illiquid  top0.1(12) top1(33) top10(70) bottom50(3) bottom25(0)']);
    disp([top_a_01*100 top_a_1*100 top_a_10*100 bottom_a_50*100 bottom_a_75*100]); 

    disp(['share of liquid  top0.1(17) top1(47) top10(86) bottom50(-4) bottom25(-5)']);
    disp([top_b_01*100 top_b_1*100 top_b_10*100 bottom_b_50*100 bottom_b_75*100]); 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% Create figures %%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if save_result == 1
    clear A_t gg_t g_t
    save results_par0104.mat
end

if makefig==1
    make_figure
end


save cdif time cum_Agg_C_IRF_dif
