    V = v;   
    %DERIVATIVES W.R.T. b
    % forward difference
    VbF(1:I-1,:,:) = (V(2:I,:,:)-V(1:I-1,:,:))/db;
    VbF(I,:,:) = ((1-xi)*(1-tau)*w*zzz(I,:,:) + Rb(I,:,:).*bmax + GTTT(I,:,:)).^(-ga); %state constraint boundary condition
    % backward difference
    VbB(2:I,:,:) = (V(2:I,:,:)-V(1:I-1,:,:))/db;
    VbB(1,:,:) = ((1-xi)*(1-tau)*w*zzz(1,:,:) + Rb(1,:,:).*bmin + GTTT(1,:,:)).^(-ga); %state constraint boundary condition

    %DERIVATIVES W.R.T. a
    % forward difference
    VaF(:,1:J-1,:) = (V(:,2:J,:)-V(:,1:J-1,:))/da;
    % backward difference
    VaB(:,2:J,:) = (V(:,2:J,:)-V(:,1:J-1,:))/da;
    
    %useful quantities
    c_B = max(VbB,10^(-6)).^(-1/ga);
    c_F = max(VbF,10^(-6)).^(-1/ga);
    
    %upwind w.r.t c
    sc_B = (1-xi)*(1-tau)*w*zzz + Rb.*bbb - c_B + GTTT;
    sc_F = (1-xi)*(1-tau)*w*zzz + Rb.*bbb - c_F + GTTT;
    Ic_B = (sc_B < -10^(-12));
    Ic_F = (sc_F > 10^(-12)).*(1- Ic_B);
    Ic_0 = 1 - Ic_F - Ic_B;
    c_0 = (1-xi)*(1-tau)*w*zzz + Rb.*bbb + GTTT;  
    c = c_F.*Ic_F + c_B.*Ic_B + c_0.*Ic_0;
    u = c.^(1-ga)/(1-ga);
    s = Ic_B.*sc_B + Ic_F.*sc_F;

    %upwind w.r.t d
    %calculate d. Note that Fortran code is opposite direction (FB and BF)
    dBB = two_asset_kinked_FOC(VaB,VbB,aaa);
    dFB = two_asset_kinked_FOC(VaB,VbF,aaa);
    %VaF(:,J,:) = VbB(:,J,:).*(1-ra.*chi1 - chi1*w*zzz(:,J,:)./a(:,J,:));
    dBF = two_asset_kinked_FOC(VaF,VbB,aaa);
    %VaF(:,J,:) = VbF(:,J,:).*(1-ra.*chi1 - chi1*w*zzz(:,J,:)./a(:,J,:));
    %dFF = two_asset_kinked_FOC(VaF,VbF,aaa);
    V_dBB = VaB.*dBB - VbB.*(dBB + two_asset_kinked_cost(dBB,aaa));
    V_dFB = VaB.*dFB - VbF.*(dFB + two_asset_kinked_cost(dFB,aaa));
    V_dBF = VaF.*dBF - VbB.*(dBF + two_asset_kinked_cost(dBF,aaa));
    %decision rule
    I_dBF = (dBF > -10^(-12)).*(V_dBF >-10^(-12));
    I_dBF(1,:,:) =0;
    I_dBF(:,J,:) =0;

    I_dFB = (dFB < - two_asset_kinked_cost(dFB,aaa)).*(V_dFB >-10^(-12));
    I_dFB(I,:,:) =0;
    I_dFB(:,1,:) =0;

    I_dBB = (dBB > - two_asset_kinked_cost(dBB,aaa)).*(dBB < -10^(-12)).*(V_dBB >-10^(-12));
    I_dBB(1,:,:) =0;
    I_dBB(:,1,:) =0;
    %UPWIND SCHEME
    d = I_dBF.*dBF + I_dFB.*dFB + I_dBB.*dBB;
        
    %CONSTRUCT MATRIX BB SUMMARING EVOLUTION OF b
    X = - min(s,0)/db - min(- d - two_asset_kinked_cost(d,aaa),0)/db;
    Y = (min(s,0) - max(s,0))/db + (min(- d - two_asset_kinked_cost(d,aaa),0) - max(- d - two_asset_kinked_cost(d,aaa),0))/db;
    Z = max(s,0)/db + max(- d - two_asset_kinked_cost(d,aaa),0)/db;
    
    for i = 1:Nz
        centdiag(:,i) = reshape(Y(:,:,i),I*J,1);
    end

    lowdiag(1:I-1,:) = X(2:I,1,:);
    updiag(2:I,:) = Z(1:I-1,1,:);
    for j = 2:J
        lowdiag(1:j*I,:) = [lowdiag(1:(j-1)*I,:);squeeze(X(2:I,j,:));zeros(1,Nz)];
        updiag(1:j*I,:) = [updiag(1:(j-1)*I,:);zeros(1,Nz);squeeze(Z(1:I-1,j,:))];
    end
    
    for nz=1:Nz
        BBi{nz}=spdiags(centdiag(:,nz),0,I*J,I*J)+spdiags([updiag(:,nz);0],1,I*J,I*J)+spdiags([lowdiag(:,nz);0],-1,I*J,I*J);
    end
    
    BB = [BBi{1}, sparse(I*J,I*J*(Nz-1))];
    for nz=2:Nz
    BB = [BB; sparse(I*J,I*J*(nz-1)), BBi{nz}, sparse(I*J,I*J*(Nz-nz))];
    end
    
    %CONSTRUCT MATRIX AA SUMMARIZING EVOLUTION OF a
    MB = min(d,0);
  %  MB = min(dB,0) + xi*w*zzz + Ra.*aaa;
    MF = max(d,0) + xi*w*zzz + Ra.*aaa;
    MB(:,J,:) = xi*w*zzz(:,J,:) + d(:,J,:) + Ra(:,J,:).*amax; %this is hopefully negative
%    MB(:,J,:) = min(xi*w*zzz(:,J,:) + dB(:,J,:) + Ra(:,J,:).*amax,0); %this is hopefully negative
    MF(:,J,:) = 0;

    chi = -MB/da;
    yy =  (MB - MF)/da;
    zeta = MF/da;
    
    %MATRIX AAi
    for nz=1:Nz
        %This will be the upperdiagonal of the matrix AAi
        AAupdiag=zeros(I,1); %This is necessary because of the peculiar way spdiags is defined.
        for j=1:J
            AAupdiag=[AAupdiag;zeta(:,j,nz)];
        end
        
        %This will be the center diagonal of the matrix AAi
        AAcentdiag= yy(:,1,nz);
        for j=2:J-1
            AAcentdiag=[AAcentdiag;yy(:,j,nz)];
        end
        AAcentdiag=[AAcentdiag;yy(:,J,nz)];
        
        %This will be the lower diagonal of the matrix AAi
        AAlowdiag=chi(:,2,nz);
        for j=3:J
            AAlowdiag=[AAlowdiag;chi(:,j,nz)];
        end
        
        %Add up the upper, center, and lower diagonal into a sparse matrix
        AAi{nz} = spdiags(AAcentdiag,0,I*J,I*J)+spdiags(AAlowdiag,-I,I*J,I*J)+spdiags(AAupdiag,I,I*J,I*J);
        
    end
    
    AA = [AAi{1}, sparse(I*J,I*J*(Nz-1))];
    for nz=2:Nz
        AA = [AA; sparse(I*J,I*J*(nz-1)), AAi{nz}, sparse(I*J,I*J*(Nz-nz))];
    end
    
    A = AA + BB + Bswitch;
    
    if max(abs(sum(A,2)))>10^(-9)
       disp('Improper Transition Matrix')
%       break
    end
    
    B = (1/Delta + rho)*speye(I*J*Nz) - A;
    
    u_stacked = reshape(u,I*J*Nz,1);
    V_stacked = reshape(V,I*J*Nz,1);
    vec = u_stacked + V_stacked/Delta;
    
    V_stacked = B\vec; %SOLVE SYSTEM OF EQUATIONS
        
    V = reshape(V_stacked,I,J,Nz);   
    Vchange = V - v;
    v = V;