clear all;
close all;

% Empirical results
emp10q = [0.06, 0.80, 1.86];
emp10q_eb = [0.86, 0.915, 0.735];

figure(1)
hold on
errorbar(emp10q,emp10q_eb,'ks');
scatter([1 2 3],emp10q,100,'b','filled');
xticks([1 2 3])
xticklabels({'Low' 'Middle' 'High'})
xlim([0.5 3.5])
yticks([-1 0 1 2 3])
ylim([-1 3])

dim = [0.12 0.9 .1 .1];
str = '(%)';
annotation('textbox',dim,'String',str,'FontSize',18,'EdgeColor','none');

set(gca,'XTick', [1 2 3])
set(gca,'FontSize',20)
box on

%print(gcf,'-djpeg','-r350','BaselineIRFemp.jpg')


