clear
cls
capture log close
set more off
cd C:\Users\b28\Desktop\Research\InnocentBystandersreplication_folder
set matsize 800

/*
use ./source_files\unzip\CGK_Imputed.dta, clear

append using ./source_files\unzip\CGK_Imputednew.dta, force

drop if QINTRVYR>2013

*duplicates drop NEWIDunique, force
keep NEWIDunique intno intdate RESPSTAT incomebt incomebtIMP incomeat incomeatIMP salary salaryIMP
save ./source_files\unzip\CGK_Imputed_new_mod.dta, replace


/* change NEWIDunique
use ./source_files\unzip\CGK_Expendituresnew.dta, clear
gen test = floor(NEWIDunique/10)
replace NEWIDunique=test
drop test
save ./source_files\unzip\CGK_Expendituresnew.dta, replace
*/

use ./source_files\unzip\CGK_Expenditures.dta, clear
append using ./source_files\unzip\CGK_Expendituresnew.dta

keep NEWIDunique intno intdate date fwt cons durables noncons nondur services totalexp*
collapse (sum) cons durables noncons nondur services totalexp* (mean) fwt, by (NEWID intdate intno)


gen temp = dofm(intdate)
format temp %d
list in 1/10
gen intmonth=month(temp)
gen intyr=year(temp)
drop temp

	gen referq = 1 if (intmonth == 3 | intmonth == 4 | intmonth == 5) 
	replace referq = 2 if (intmonth == 6 | intmonth == 7 | intmonth == 8) 
	replace referq = 3 if (intmonth == 9 | intmonth == 10 | intmonth == 11) 
	replace referq = 4 if (intmonth == 12 | intmonth == 1 | intmonth == 2)
	
	gen refery = intyr
	replace refery = intyr - 1 if (intmonth == 1 | intmonth == 2)
	

save ./source_files\unzip\CGK_Expenditures_new_mod.dta, replace
*/


use ./source_files\unzip\CGK_Expenditures_new_mod.dta, clear
merge 1:1 NEWIDunique intno using ./source_files\unzip\CGK_Imputed_new_mod_age.dta

drop if _merge==2
drop _merge

drop if intyr>2009
keep if AGE_REF <= 65


gen NEWID = NEWIDunique*10 + intno
merge 1:1 NEWID using ./source_files\unzip/FMLYnew.dta, keepusing(FINCB*)

drop if _merge == 2
drop _merge

gen month=intdate
format month %tm
merge m:1 month using ./source_files\CPI_unew.dta

drop if _merge == 2
drop _merge

gen real_FINCBTXM = FINCBTXM /cpi_u*100


gen day = dofm(intdate)
format day %td
gen quarter = qofd(day)
format quarter %tq

merge 1:1 NEWIDunique quarter using ./workfiles\FMLY_short_quarterly_new
drop if _merge == 2
drop _merge
drop quarter


tostring refery referq, replace
gen date_tmp = refery + "q" + referq
gen date = quarterly(date_tmp, "YQ")
format date %tq
destring refery referq, replace
drop date_tmp

tsset NEWIDunique date

foreach var in incomebt incomebtIMP incomeat incomeatIMP salary salaryIMP {
replace `var' = l.`var' if `var' ==. & l.`var'!=.
replace `var' = l2.`var' if `var' ==. & l2.`var'!=.
replace `var' = l3.`var' if `var' ==. & l3.`var'!=.
replace `var' = f.`var' if `var' ==. & f.`var'!=.
replace `var' = f2.`var' if `var' ==. & f2.`var'!=.
replace `var' = f3.`var' if `var' ==. & f3.`var'!=.

}


foreach var in  cons durables noncons nondur services totalexp3 { 
	replace `var'=. if `var'<0 
	sum `var' [fw=fwt] if `var'>0, d
	replace `var'=r(p99) if `var'>r(p99) & `var'~=. & `var'>0
	replace `var'=r(p1)  if `var'<r(p1) & `var'~=. & `var'>0
	sum `var' [fw=fwt] if `var'>0, d
	
	gen ES_`var'=`var'/OECD_ES
	
}

*save ./NIPA/dataforNIPA.dta, replace


//------------------------------------------------------------------------------



gen real_incomebt = real_FINCBTXM *2.40 
replace real_incomebt = incomebtIMP *2.40 if real_incomebt==.
* 2016CPI= 240.00

drop if real_incomebt==.

gen date_int = 4*(refery - 1979) + referq

gen real_incg = 0
 forvalues i=4/124 {
 capture drop xq
 xtile xq= real_incomebt [aw=fwt] if date_int==`i', nq(3)
 replace real_incg=xq if date_int==`i'
 }

* tab real_incg


*xtile quant = real_incomebt, nq(3)
*sort real_incomebt



*gen real_incg = 0
*replace real_incg = 1 if real_incomebt<30000
*replace real_incg = 2 if real_incomebt>=30000 & real_incomebt<70000
*replace real_incg = 3 if real_incomebt>=70000

*sort date_int
*by date_int: tab real_incg

collapse (mean) cons durables noncons nondur services totalexp3 ES_cons ES_durables ES_noncons ES_nondur ES_services ES_totalexp3 [w=fwt], by (refery referq real_incg)

tostring real_incg, replace
reshape wide cons durables noncons nondur services totalexp3 ES_cons ES_durables ES_noncons ES_nondur ES_services ES_totalexp3, i(refery referq) j(real_incg) string



foreach gr of numlist 1 2 3 {

	gen ln_cons`gr' = ln(cons`gr')
	gen ln_durables`gr' = ln(durables`gr')
	gen ln_noncons`gr' = ln(noncons`gr')
	gen ln_nondur`gr' = ln(nondur`gr')
	gen ln_services`gr' = ln(services`gr')
	gen ln_totalexp3`gr' = ln(totalexp3`gr')
	gen ln_ES_cons`gr' = ln(ES_cons`gr')
	gen ln_ES_durables`gr' = ln(ES_durables`gr')
	gen ln_ES_noncons`gr' = ln(ES_noncons`gr')
	gen ln_ES_nondur`gr' = ln(ES_nondur`gr')
	gen ln_ES_services`gr' = ln(ES_services`gr')
	gen ln_ES_totalexp3`gr' = ln(ES_totalexp3`gr')
}    

gen aaa=. // temporary variable for aorder below
gen zzz=. // temporary variable for aord
aorder
drop aaa zzz

save ./dataReg/RincomeReg_Nakajima_age1009.dta, replace

export excel using ./dataReg/RincomeReg_Nakajima_age1009.xls, firstrow(variables) replace

		
//------------------------------------------------------------------------------
// Adjust to match the NIPA aggregate data
//------------------------------------------------------------------------------
/*
use ./NIPA/dataforNIPA.dta, clear

collapse (mean) ES_cons ES_durables ES_nondur [w=fwt], by (refery referq)

tostring refery referq, replace
gen date_tmp = refery + "q" + referq
gen date = quarterly(date_tmp, "YQ")
format date %tq
destring refery referq, replace
drop date_tmp

merge 1:1 date using ./NIPA/NIPA_cons.dta
drop if _merge !=3
drop _merge

gen ratio_nd = nipa_nondu / ES_nondu 
gen ratio_du = nipa_du / ES_durables 
gen ratio_tot = nipa_tot / ES_cons 

keep date ratio_tot ratio_du ratio_nd 

save ./NIPA/NIPAratio.dta, replace


use ./dataReg/RincomeReg1030.dta, clear
tostring refery referq, replace
gen date_tmp = refery + "q" + referq
gen date = quarterly(date_tmp, "YQ")
format date %tq
destring refery referq, replace
drop date_tmp

merge 1:1 date using ./NIPA/NIPAratio.dta


foreach gr of numlist 1 2 3 {

	gen NIPA_ES_cons`gr' = ES_cons`gr' * ratio_tot
	gen NIPA_ES_durables`gr' = ES_durables`gr' * ratio_du
	gen NIPA_ES_nondur`gr' = ES_nondur`gr' * ratio_nd
	gen ln_NIPA_ES_cons`gr' = ln(NIPA_ES_cons`gr')
	gen ln_NIPA_ES_durables`gr' = ln(NIPA_ES_durables`gr')
	gen ln_NIPA_ES_nondur`gr' = ln(NIPA_ES_nondur`gr')
}

save ./dataReg/RincomeReg_NIPA_1030.dta, replace

export excel using ./dataReg/RincomeReg_NIPA_1030.xls, firstrow(variables) replace

*log close
*/
