clear
cls
capture log close
set more off
cd C:\Users\b28\Desktop\Research\InnocentBystandersreplication_folder

*use ./source_files\unzip\CGK_Expenditures_new_mod.dta, clear
*merge 1:1 NEWIDunique intno using ./source_files\unzip\CGK_Imputed_new_mod.dta

use ./source_files\unzip\FMLYnew.dta, clear


gen salaryIMP = FSALARYM
*gen salaryIMP = FSALARY1

gen businessIMP = 0
gen financeIMP = 0
gen otherincIMP = 0

foreach var in FNONFRMM FFRMINCM FININCXM INTEARNM PENSIONM INCLOSSA INCLOSSB FRRETIRM FSSIXM UNEMPLXM COMPENSM WELFAREM INCCONTX OTHRINCM FSMPFRXM INTRDVXM ROYESTXM NETRENTM FRRETIRM FSSIXM RETSURVM WELFAREM OTHREGXM OTHRINCM{
	replace `var'=0 if `var'==. 
}


replace businessIMP = FNONFRMM + FFRMINCM if yq<=1131
*gen businessIMP = FNONFRM1 + FFRMINC1 if yq<=1131
replace financeIMP  = FININCXM + INTEARNM + PENSIONM + INCLOSSA + INCLOSSB if yq<=1131
*gen financeIMP  = FININCX1 + INTEARN1 + PENSION1 + INCLOSSA + INCLOSSB if yq<=1131
replace otherincIMP = FRRETIRM + FSSIXM + UNEMPLXM + COMPENSM + WELFAREM + INCCONTX + OTHRINCM if yq<=1131
*gen otherincIMP = FRRETIR1 + FSSIX1 + UNEMPLX1 + COMPENS1 + WELFARE1 + INCCONTX + OTHRINC1 if yq<=1131

replace businessIMP = FSMPFRXM if yq>=1132
replace financeIMP  = INTRDVXM + ROYESTXM + NETRENTM if yq>=1132
replace otherincIMP = FRRETIRM + FSSIXM + RETSURVM + WELFAREM + OTHREGXM + OTHRINCM if yq>=1132


*save ./source_files\unzip\FMLYnew_ratio_mod_new.dta, replace

local loaddata = 1

if `loaddata' == 1 {

*use ./source_files\unzip\CGK_Expenditures.dta, clear
*keep NEWIDunique intno intdate date fwt cons durables noncons nondur services totalexp3 mortgageint houseexpS houseexpD furniture vehpurch entertainD education
*collapse (sum) cons durables noncons nondur services totalexp3 mortgageint houseexpS houseexpD furniture vehpurch entertainD education (mean) fwt, by (NEWID intdate intno)
*drop if _merge == 2
*drop _merge
		
use ./source_files\unzip\CGK_Imputed.dta, clear
append using ./source_files\unzip\FMLYnew_ratio_mod_new.dta, force

gen temp = dofm(intdate)
format temp %d
*list in 1/10
gen intmonth=month(temp)
gen intyr=year(temp)
drop temp

gen referq = 1 if (intmonth == 3 | intmonth == 4 | intmonth == 5) 
replace referq = 2 if (intmonth == 6 | intmonth == 7 | intmonth == 8) 
replace referq = 3 if (intmonth == 9 | intmonth == 10 | intmonth == 11) 
replace referq = 4 if (intmonth == 12 | intmonth == 1 | intmonth == 2)
gen refery = intyr
replace refery = intyr - 1 if (intmonth == 1 | intmonth == 2)


tostring refery referq, replace
gen date_tmp = refery + "q" + referq
gen date = quarterly(date_tmp, "YQ")
format date %tq
destring refery referq, replace
drop date_tmp


tsset NEWIDunique date

foreach var in incomebt incomebtIMP incomeat incomeatIMP salary salaryIMP businessIMP financeIMP otherincIMP FINCBTXM{
	replace `var'=. if `var'<0 
	sum `var' [fw=fwt] if `var'>0, d
	replace `var'=r(p99) if `var'>r(p99) & `var'~=. & `var'>0
	replace `var'=r(p1)  if `var'<r(p1) & `var'~=. & `var'>0
	sum `var' [fw=fwt] if `var'>0, d

}

*drop if incomebtIMP==.

*foreach var in  cons durables noncons nondur services totalexp3 { 
*	replace `var'=. if `var'<0 
*	sum `var' [fw=fwt] if `var'>0, d
*	replace `var'=r(p99) if `var'>r(p99) & `var'~=. & `var'>0
*	replace `var'=r(p1)  if `var'<r(p1) & `var'~=. & `var'>0
*	sum `var' [fw=fwt] if `var'>0, d	
*}

keep if refery>=1980
keep if refery<=2008

save ./dataReg/HHchara0507_new.dta, replace

}

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~`
*	calculate the number of the share

*local data = 2 //1 income 2 expenditure

*if `data' == 1 {

use ./dataReg/HHchara0507_new.dta, clear
*keep NEWIDunique refery referq totalexp3 cons durables nondur  nondurables services mortgageint vehpurch expIS real_incg

gen real_incomebt = incomebtIMP *2.40
replace real_incomebt = FINCBTXM*2.40 if real_incomebt ==.
* 2016CPI= 240.00


gen date_int = 4*(refery - 1979) + referq

gen real_incg = 0
 forvalues i=5/120 {
 capture drop xq
 xtile xq= real_incomebt [w=fwt] if date_int==`i', nq(3)
 replace real_incg=xq if date_int==`i'
 }

*gen real_incg = 0
*replace real_incg = 1 if real_incomebt<30000
*replace real_incg = 2 if real_incomebt>=30000 & real_incomebt<70000
*replace real_incg = 3 if real_incomebt>=70000
tab real_incg



gen TY=salaryIMP + businessIMP + financeIMP + otherincIMP
gen s_salary = salaryIMP/TY
gen s_business = businessIMP/TY
gen s_finance  = financeIMP/TY
gen s_otherinc = otherincIMP/TY

collapse (mean) s_* [fw=fwt], by(real_incg)

*}

/*
if `data' == 2 {

use ./dataReg/HHchara1003.dta, clear
*keep NEWIDunique refery referq totalexp3 cons durables nondur  nondurables services mortgageint vehpurch expIS real_incg


foreach var in incomebt incomebtIMP incomeat incomeatIMP salary salaryIMP businessIMP financeIMP otherincIMP{

replace `var' = l.`var' if `var' ==. & l.`var'!=.
replace `var' = l2.`var' if `var' ==. & l2.`var'!=.
replace `var' = l3.`var' if `var' ==. & l3.`var'!=.
replace `var' = f.`var' if `var' ==. & f.`var'!=.
replace `var' = f2.`var' if `var' ==. & f2.`var'!=.
replace `var' = f3.`var' if `var' ==. & f3.`var'!=.

}


gen real_incomebt = incomebtIMP *2.40
* 2016CPI= 240.00

gen real_incg = 0
replace real_incg = 1 if real_incomebt<20000
replace real_incg = 2 if real_incomebt>=20000 & real_incomebt<80000
replace real_incg = 3 if real_incomebt>=80000
tab real_incg


gen TS1=nondur+durables
gen s_nondur=nondur/TS1
gen s_durables=durables/TS1


gen expIS = mortgageint + houseexpS + houseexpD + furniture + vehpurch + entertainD + education

foreach var in mortgageint vehpurch expIS {
	gen s_`var'=`var'/totalexp3
}


collapse (mean) s_* (mean) totalexp3 [fw=fwt], by(real_incg)

}

*/
/*
save step021ESE, replace

drop s_salary s_business s_finance s_otherinc

order nq_nondur s_nondurables s_durables s_services s_expIS s_mortgageint s_vehpurch s_E2NONDUR

drop s_E2C totalexp3

list 

save step010C, replace	

erase temp_step010.dta
erase temp_step010A.dta
*/
