clear
cls
capture log close
set more off
cd C:\Users\b28\Desktop\Research\InnocentBystandersreplication_folder
set matsize 800

/*
use ./source_files\unzip\CGK_Imputed.dta, clear

append using ./source_files\unzip\CGK_Imputednew.dta, force

drop if QINTRVYR>2013

*duplicates drop NEWIDunique, force
keep NEWIDunique intno intdate RESPSTAT incomebt incomebtIMP incomeat incomeatIMP salary salaryIMP
save ./source_files\unzip\CGK_Imputed_new_mod.dta, replace


/* change NEWIDunique
use ./source_files\unzip\CGK_Expendituresnew.dta, clear
gen test = floor(NEWIDunique/10)
replace NEWIDunique=test
drop test
save ./source_files\unzip\CGK_Expendituresnew.dta, replace
*/

use ./source_files\unzip\CGK_Expenditures.dta, clear
append using ./source_files\unzip\CGK_Expendituresnew.dta

keep NEWIDunique intno intdate date fwt cons durables noncons nondur services totalexp*
collapse (sum) cons durables noncons nondur services totalexp* (mean) fwt, by (NEWID intdate intno)


gen temp = dofm(intdate)
format temp %d
list in 1/10
gen intmonth=month(temp)
gen intyr=year(temp)
drop temp

	gen referq = 1 if (intmonth == 3 | intmonth == 4 | intmonth == 5) 
	replace referq = 2 if (intmonth == 6 | intmonth == 7 | intmonth == 8) 
	replace referq = 3 if (intmonth == 9 | intmonth == 10 | intmonth == 11) 
	replace referq = 4 if (intmonth == 12 | intmonth == 1 | intmonth == 2)
	
	gen refery = intyr
	replace refery = intyr - 1 if (intmonth == 1 | intmonth == 2)
	

save ./source_files\unzip\CGK_Expenditures_new_mod.dta, replace
*/


use ./source_files\unzip\CGK_Expenditures_new_mod.dta, clear
merge 1:1 NEWIDunique intno using ./source_files\unzip\CGK_Imputed_new_mod.dta

drop if _merge==2
drop _merge

gen NEWID = NEWIDunique*10 + intno
merge 1:1 NEWID using ./source_files\unzip/FMLYnew.dta, keepusing(FINCB*)

drop if _merge == 2
drop _merge


*merge detailed income data set

*gen QINTRVMO = intmonth
*gen QINTRVYR = intyr

*duplicates drop fwt QINTRVMO QINTRVYR, force
merge 1:1 NEWIDunique intno using ./dataReg/HHchara0503.dta

drop if _merge != 3
drop _merge

*merge detailed data set



gen month=intdate
format month %tm
merge m:1 month using ./source_files\CPI_unew.dta

drop if _merge == 2
drop _merge

gen real_FINCBTXM = FINCBTXM /cpi_u*100


gen day = dofm(intdate)
format day %td
gen quarter = qofd(day)
format quarter %tq

merge 1:1 NEWIDunique quarter using ./workfiles\FMLY_short_quarterly_new
drop if _merge == 2
drop _merge
drop quarter


*tostring refery referq, replace
*gen date_tmp = refery + "q" + referq
*gen date = quarterly(date_tmp, "YQ")
*format date %tq
*destring refery referq, replace
*drop date_tmp

tsset NEWIDunique date

*foreach var in incomebt incomebtIMP incomeat incomeatIMP salary salaryIMP {
*replace `var' = l.`var' if `var' ==. & l.`var'!=.
*replace `var' = l2.`var' if `var' ==. & l2.`var'!=.
*replace `var' = l3.`var' if `var' ==. & l3.`var'!=.
*replace `var' = f.`var' if `var' ==. & f.`var'!=.
*replace `var' = f2.`var' if `var' ==. & f2.`var'!=.
*replace `var' = f3.`var' if `var' ==. & f3.`var'!=.

*}


foreach var in  cons { 
	replace `var'=. if `var'<0 
	sum `var' [fw=fwt] if `var'>0, d
	replace `var'=r(p99) if `var'>r(p99) & `var'~=. & `var'>0
	replace `var'=r(p1)  if `var'<r(p1) & `var'~=. & `var'>0
	sum `var' [fw=fwt] if `var'>0, d
	
	gen ES_`var'=`var'/OECD_ES
	
}

*save ./NIPA/dataforNIPA.dta, replace


//------------------------------------------------------------------------------



*gen real_incomebt = real_FINCBTXM *2.40 
*replace real_incomebt = incomebtIMP *2.40 if real_incomebt==.
* 2016CPI= 240.00

*drop if cutenure==.

gen TY=salaryIMP + businessIMP + financeIMP + otherincIMP
gen s_salary = salaryIMP/TY
gen s_business = businessIMP/TY
gen s_finance  = financeIMP/TY
gen s_otherinc = otherincIMP/TY


gen Transfer_group = 0
replace Transfer_group = 1 if s_otherinc < 0.10
replace Transfer_group = 2 if s_otherinc >= 0.10
*replace Transfer_group = 3 if s_otherinc >= 0.25

drop if Transfer_group == 0
tab Transfer_group

collapse (mean) cons ES_cons [w=fwt], by (refery referq Transfer_group)

tostring Transfer_group, replace
reshape wide cons ES_cons, i(refery referq) j(Transfer_group) string



foreach gr of numlist 1 2 {

	gen ln_cons`gr' = ln(cons`gr')
	gen ln_ES_cons`gr' = ln(ES_cons`gr')
}    

gen aaa=. // temporary variable for aorder below
gen zzz=. // temporary variable for aord
aorder
drop aaa zzz

save ./dataReg/TransferReg1106.dta, replace

export excel using ./dataReg/TransferReg1106.xls, firstrow(variables) replace

		
//------------------------------------------------------------------------------
// Adjust to match the NIPA aggregate data
//------------------------------------------------------------------------------
/*
use ./NIPA/dataforNIPA.dta, clear

collapse (mean) ES_cons ES_durables ES_nondur [w=fwt], by (refery referq)

tostring refery referq, replace
gen date_tmp = refery + "q" + referq
gen date = quarterly(date_tmp, "YQ")
format date %tq
destring refery referq, replace
drop date_tmp

merge 1:1 date using ./NIPA/NIPA_cons.dta
drop if _merge !=3
drop _merge

gen ratio_nd = nipa_nondu / ES_nondu 
gen ratio_du = nipa_du / ES_durables 
gen ratio_tot = nipa_tot / ES_cons 

keep date ratio_tot ratio_du ratio_nd 

save ./NIPA/NIPAratio.dta, replace

use ./dataReg/RincomeReg0923.dta, clear
merge 1:1 date using ./NIPA/NIPAratio.dta


foreach gr of numlist 1 2 3 {

	gen NIPA_ES_cons`gr' = ES_cons`gr' * ratio_tot
	gen NIPA_ES_durables`gr' = ES_durables`gr' * ratio_du
	gen NIPA_ES_nondur`gr' = ES_nondur`gr' * ratio_nd
	gen ln_NIPA_ES_cons`gr' = ln(NIPA_ES_cons`gr')
	gen ln_NIPA_ES_durables`gr' = ln(NIPA_ES_durables`gr')
	gen ln_NIPA_ES_nondur`gr' = ln(NIPA_ES_nondur`gr')
}

save ./dataReg/RincomeReg_NIPA_1027.dta, replace

export excel using ./dataReg/RincomeReg_NIPA_1027.xls, firstrow(variables) replace

*log close
*/
