%% File to do the regression for income inequality and monetary policy. Originally from Tenreyro & Thwaites
%25 September 2017

clear all
close all

%% construct the data and shocks

%startS=51;
%endS=144;
startS=51;  
endS=144;
samplelength=endS-startS+1; % Sample period - dates of shocks - need to ensure data runs L periods earlier and H periods later

construct_data
%construct_data_factor

%% Create the baseline set of data and parameters

% Load data
clear all
close all
load data.mat FFR LHS startS endS samplelength shocks Controls

% Parameters
includetrend=1;             % 1 includes a trend
%H=20;                       % Max horizon of IRF
H=20;
CI=.90;                     % Confidence intervals in charts (as decimal fraction)
Xlags=1;                    % Number of lags of control variables
Rlags=1;                    % Number of lags of policy variables
scaling=1;                  % whether scaled parameters are calculated (set to zero to save time if you don't need them)
trend_dim = 2;              % highest order of the time polynomial
%trend_dim = 0;

% weights for smoothing the results
weight=zeros(H+1,H+1);
weight(1,1)=1; % End-points are not MAs
weight(H+1,H+1)=1;
for h=2:H
    weight(h,h-1:h+1)=[1/3 1/3 1/3]; % Centred three-period moving average
end
cumweight=tril(ones(H+1,H+1));
trend=linspace(1,samplelength,samplelength)';
trend0=trend;
if trend_dim > 1
    for order = 2:1:trend_dim
        trend = [trend trend0.^order];
    end
end


save baseline.mat           % baseline workspace

%% Run the baseline simulation
clear all
close all
load baseline.mat
LHSindices=[1 2 3];
LHS=LHS(:,LHSindices);

%Y=LHS(:,1);
%Y=Y(startS:endS);
%X = FFR(startS-1:endS-1);
%X = [X FFR(startS-2:endS-2)];
%X = [X LHS(startS-1:endS-1,1)];
%X = [shocks(startS:endS,1) ones(95,1) linspace(1,samplelength,samplelength)' X];
%beta0 = inv(X'*X)*X'*Y;
%beta=zeros(1,H+1);
%    for h=0:H
%        beta0=inv(X'*X)*X'*LHS(startS+h:endS+h,1);
%        beta(h+1)=beta0(1,1);
%    end

shocksmod_Romer = shocks(startS:endS,1);
shocksmod_Fut = shocks(startS:endS,2);
shocksmod_Shadow = shocks(startS:endS,3);

[results]=stlpm_simple025(FFR,shocksmod_Romer,LHS,trend,Xlags,Rlags,includetrend,H,startS,endS,scaling,weight,cumweight,Controls)
%[results]=stlpm_simple025h(FFR,shocksmod_Romer,LHS,trend,Xlags,Rlags,includetrend,H,startS,endS,scaling,weight,cumweight,Controls)
%[results]=stlpm_simple(FFR,shocksmod_Romer,LHS,trend,Xlags,Rlags,includetrend,H,startS,endS,scaling,weight,cumweight)
%[results]=stlpm_simple025(FFR,shocksmod_Romer,LHS,trend,Xlags,Rlags,includetrend,H,startS,endS,scaling,weight,cumweight,Controls)
%[results]=stlpm_simple025_noC(FFR,shocksmod_Shadow,LHS,trend,Xlags,Rlags,includetrend,H,startS,endS,scaling,weight,cumweight)
%stlpm_inference
stlpm_inference025
save baseline_results.mat

%% Make graphs
clear all
close all
load baseline_results.mat

%H=40;

disp(['Response of low income HH 10q 20q']);
disp(-100*[results(1).lin.cum.coef(11) results(1).lin.cum.CIhigh(11) results(1).lin.cum.CIlow(11)]);
disp(-100*[results(1).lin.cum.coef(21) results(1).lin.cum.CIhigh(21) results(1).lin.cum.CIlow(21)]);

disp(['Response of middle income HH 10q 20q']);
disp(-100*[results(2).lin.cum.coef(11) results(2).lin.cum.CIhigh(11) results(2).lin.cum.CIlow(11)]);
disp(-100*[results(2).lin.cum.coef(21) results(2).lin.cum.CIhigh(21) results(2).lin.cum.CIlow(21)]);

disp(['Response of high income HH 10q 20q']);
disp(-100*[results(3).lin.cum.coef(11) results(3).lin.cum.CIhigh(11) results(3).lin.cum.CIlow(11)]);
disp(-100*[results(3).lin.cum.coef(21) results(3).lin.cum.CIhigh(21) results(3).lin.cum.CIlow(21)]);


%standardcharts_fig(results,H,{'cum'})
standardcharts_fig2(results,H,{'cum'})
%standardcharts_fig(results,H,{'smoothed'})
%standardcharts_fig(results,H,{'scaled'})
%standardcharts1_fig(results,H,{'cum'})

dim = [0.12 0.87 .1 .1];
str = '(%)';
annotation('textbox',dim,'String',str,'FontSize',11,'EdgeColor','none');


print(gcf,'-djpeg','-r350','Baseline_dif.jpg')

save empirical_results