KX=size(results(1).lin.X,2);
KR=size(results(end).lin.XR,2);
K=KX+KR;

CIparam=norminv(1-(1-CI)/2,0,1);

for n=1:size(results,2)-1; % loop over LHS variables

for h=0:H
    % heteroscedastic but uncorrelated case
    results(n).lin.variance(:,:,h+1)=var(results(n).lin.res(:,h+1))*inv(results(n).lin.X'*results(n).lin.X);
end

    results(n).lin.variance_beta=squeeze(results(n).lin.variance(end,end,:));
    results(n).lin.varDK=NeweyWestDK([results(n).lin.res; repmat(results(end).lin.res(:,1),[1 H+1])],blkdiag(results(n).lin.X,results(end).lin.XR),H+1,0);
    results(n).lin.varDK_beta=results(n).lin.varDK([KX+K*[0:H] K*(H+1)],[KX+K*[0:H] K*(H+1)]);

end

for h=0:H
    results(end).lin.variance(:,:,h+1)=var(results(end).lin.res(:,h+1))*inv(results(end).lin.XR'*results(end).lin.XR);
end

results(end).lin.variance_beta=squeeze(results(end).lin.variance(end,end,:));
results(end).lin.varDK=NeweyWestDK(results(end).lin.res,results(end).lin.XR,H+1,0);
results(end).lin.varDK_beta=results(end).lin.varDK(KR*[1:H+1],KR*[1:H+1]);

% delta method 
for n=1:size(results,2)-1; % loop over LHS variables

results(n).lin.scaled.delta=[eye(H+1)/results(end).lin.betafull(end,1) -results(n).lin.beta/(results(end).lin.betafull(end,1)^2)];
results(n).lin.scaled.var=results(n).lin.scaled.delta*results(n).lin.varDK_beta*results(n).lin.scaled.delta';
results(n).lin.scaled.SE=sqrt(diag(results(n).lin.scaled.var))/4;
results(n).lin.scaled.tstats=results(n).lin.scaled.coef./results(n).lin.scaled.SE; % T stats defined as standard
results(n).lin.scaled.CIhigh =  results(n).lin.scaled.coef + CIparam*results(n).lin.scaled.SE; % 90% confidence intervals
results(n).lin.scaled.CIlow  =  results(n).lin.scaled.coef - CIparam*results(n).lin.scaled.SE; % 90% confidence intervals

results(n).lin.smoothed.delta=[weight/results(end).lin.betafull(end,1) -weight*results(n).lin.beta/(results(end).lin.betafull(end,1)^2)];
results(n).lin.smoothed.var=results(n).lin.smoothed.delta*results(n).lin.varDK_beta*results(n).lin.smoothed.delta';
results(n).lin.smoothed.SE=sqrt(diag(results(n).lin.smoothed.var))/4;
results(n).lin.smoothed.tstats=results(n).lin.smoothed.coef./results(n).lin.smoothed.SE; % T stats defined as standard
results(n).lin.smoothed.CIhigh =  results(n).lin.smoothed.coef + CIparam*results(n).lin.smoothed.SE; % 90% confidence intervals
results(n).lin.smoothed.CIlow =  results(n).lin.smoothed.coef - CIparam*results(n).lin.smoothed.SE; % 90% confidence intervals

results(n).lin.cum.delta=[cumweight/results(end).lin.betafull(end,1) -cumweight*results(n).lin.beta/(results(end).lin.betafull(end,1)^2)];
results(n).lin.cum.var=results(n).lin.cum.delta*results(n).lin.varDK_beta*results(n).lin.cum.delta';
results(n).lin.cum.SE=sqrt(diag(results(n).lin.cum.var))/4;
results(n).lin.cum.tstats=results(n).lin.cum.coef./results(n).lin.cum.SE; % T stats defined as standard
results(n).lin.cum.CIhigh =  results(n).lin.cum.coef + CIparam*results(n).lin.cum.SE; % 90% confidence intervals
results(n).lin.cum.CIlow  =  results(n).lin.cum.coef - CIparam*results(n).lin.cum.SE; % 90% confidence intervals

end

% policy variable
results(end).lin.scaled.delta=eye(H+1)/results(end).lin.betafull(end,1);
results(end).lin.scaled.delta(:,1)=results(end).lin.scaled.delta(:,1)-results(end).lin.betafull(end,:)'/(results(end).lin.betafull(end,1)^2);
results(end).lin.scaled.var=results(end).lin.scaled.delta*results(end).lin.varDK_beta*results(end).lin.scaled.delta';
results(end).lin.scaled.SE=sqrt(diag(results(end).lin.scaled.var));
results(end).lin.scaled.tstats=results(end).lin.scaled.coef./results(end).lin.scaled.SE; % T stats defined as standard
results(end).lin.scaled.CIhigh =  results(end).lin.scaled.coef + CIparam*results(end).lin.scaled.SE; % 90% confidence intervals
results(end).lin.scaled.CIlow  =  results(end).lin.scaled.coef - CIparam*results(end).lin.scaled.SE; % 90% confidence intervals

results(end).lin.smoothed.delta=weight/results(end).lin.betafull(end,1);
results(end).lin.smoothed.delta(:,1)=results(end).lin.smoothed.delta(:,1)-weight*results(end).lin.betafull(end,:)'/(results(end).lin.betafull(end,1)^2);
results(end).lin.smoothed.var=results(end).lin.smoothed.delta*results(end).lin.varDK_beta*results(end).lin.smoothed.delta';
results(end).lin.smoothed.SE=sqrt(diag(results(end).lin.smoothed.var));
results(end).lin.smoothed.tstats=results(end).lin.smoothed.coef./results(end).lin.smoothed.SE; % T stats defined as standard
results(end).lin.smoothed.CIhigh =  results(end).lin.smoothed.coef + CIparam*results(end).lin.smoothed.SE; % 90% confidence intervals
results(end).lin.smoothed.CIlow =  results(end).lin.smoothed.coef - CIparam*results(end).lin.smoothed.SE; % 90% confidence intervals

results(end).lin.cum.delta=cumweight/results(end).lin.betafull(end,1);
results(end).lin.cum.delta(:,1)=results(end).lin.cum.delta(:,1)-cumweight*results(end).lin.betafull(end,:)'/(results(end).lin.betafull(end,1)^2);
results(end).lin.cum.var=results(end).lin.cum.delta*results(end).lin.varDK_beta*results(end).lin.cum.delta';
results(end).lin.cum.SE=sqrt(diag(results(end).lin.cum.var));
results(end).lin.cum.tstats=results(end).lin.cum.coef./results(end).lin.cum.SE; % T stats defined as standard
results(end).lin.cum.CIhigh =  results(end).lin.cum.coef + CIparam*results(end).lin.cum.SE; % 90% confidence intervals
results(end).lin.cum.CIlow  =  results(end).lin.cum.coef - CIparam*results(end).lin.cum.SE; % 90% confidence intervals
