function [results]=stlpm_simple025(R,E,LHS,trend,Xlags,Rlags,includetrend,H,startS,endS,scaling,weight,cumweight,Controls)
% estimates an STLPM as a function

% set up regression matrices
N=size(LHS,2);              % Number of endogenous variables
XR=[];
if Rlags>0
    XR=R(startS-1:endS-1);
    if Rlags>1
        for l=2:Rlags
            XR=[XR R(startS-l:endS-l)]; %   lagged interest rates                                                                
        end
    end
end
trend_dim = size(trend,2);

XR=[ones(length(XR),1) XR E(:,1)];   % construct common RHS projection matrix
if includetrend==1
    XR=[trend XR];
end
XRproj=inv(XR'*XR)*XR';

%% Main regression loop
% loop over H, store coefficients and residuals

% policy variable regressions
betaR=[];
resR=[];
betafull=[];

for h=0:H

    betaRh=XRproj*R(startS+h:endS+h);
    results(N+1).lin.betafull=betaRh;
    betaR=[betaR; betaRh(end)]; %coef. of monetary policy shocks
    betafull(:,h+1)=betaRh;
    resRh=R(startS+h:endS+h)-XR*betaRh;
    resR(:,h+1)=resRh;
    
end
results(N+1).lin.res=resR;
results(N+1).lin.beta=betaR;
results(N+1).lin.betafull=betafull;
results(N+1).lin.XR=XR;


if scaling==1
    results(N+1).lin.scaled.coef=betaR/betaR(1); % Scale by first period impact on Fed Funds
    results(N+1).lin.smoothed.coef=weight*betaR/betaR(1); % Scale by first period impact on Fed Funds
    results(N+1).lin.cum.coef=cumweight*betaR/betaR(1);
end

% response variable regressions
for n=1:N % loop over LHS variables
    
    results(N+1).lin.beta=[];
    res=[];
    X=[];
    beta=[];
    betafull=[];
    X_Controls = Controls(startS:endS,:);
    
    if Xlags>0
        X=LHS(startS-1:endS-1,n);
        if Xlags>1
            for l=2:Xlags
                X=[X LHS(startS-l:endS-l,n)];
            end
        end
    end
    
    if includetrend==0
        X=[X X_Controls XR]; 
    else
        X=[trend X X_Controls XR(:,trend_dim+1:end)];
    end
    results(n).lin.X=X;
    Xproj=inv(X'*X)*X';
    
    % loop over H, store coefficients and residuals
    for h=0:H
        betah=Xproj*LHS(startS+h:endS+h,n);
        betafull(:,h+1)=betah;
        beta=[beta; betah(end)];
        resh=LHS(startS+h:endS+h,n)-X*betah;
        res(:,h+1)=resh;
    end
    
    results(n).lin.beta=beta;
    results(n).lin.res=res;
    results(n).lin.betafull=betafull;
    
    if scaling==1
    
    % Construct smoothed and cumulative scaled IRFs
    % matrix of weights for the moving average process
    % Linear model MAs and CIs
        results(n).lin.scaled.coef=results(n).lin.beta/betaR(1)/4; % Scale by first period impact on Fed Funds
        results(n).lin.smoothed.coef=weight*results(n).lin.beta/betaR(1)/4; % Scale by first period impact on Fed Funds
        results(n).lin.cum.coef=cumweight*results(n).lin.beta/betaR(1)/4;
    end 
end
end

