/*

	   Estimation_Dummy_iMaPP.do

	   Note: Codes on the baseline regression 
	   (Excerpt from macropru_server_wp4_aa_rob-v2.do)

	   Last Updated: October 10, 2023
	   Previous version: Estimation_Dummy_iMaPP - 20221010 (before adding house price).do

*/

*===============================================================================
* Step 1: Set up
*===============================================================================
//cd "C:\Users\mnarita\Box Sync\iMaPP WP\Codes"	
clear all 
set maxvar 10000
set more off
set excelxlsxlargefile on
pause off
capture log close

// Version of the iMaPP databse
local str_data_version 8_iMaPP2021	// e.g., set to "8_iMaPP2021" to use "quarterly_wp_macropru_final8_iMaPP2021.dta"

// Set the log file
local today : display %tdCYND date(c(current_date), "DMY")  // Date (YYYYMMDD)
log using "../Results/Macropru/Dummy/Log_iMaPP_gmm_`today'_v`str_data_version'.txt", text replace
*log using "C:\Users\MNarita\Box Sync\iMaPP WP\Results\Macropru\Log_iMaPP_gmm_20190224e_`var1'.txt", text replace

// Load data
// use "C:\Users\AAlter\Box Sync\iMaPP WP\Data\quarterly_wp_macropru_final3.dta", clear
//use "C:\Users\AAlter\Box Sync\iMaPP WP\Data\quarterly_wp_macropru_final4.dta", clear
*use "C:\Users\MNarita\Box Sync\iMaPP WP\Data\quarterly_wp_macropru_final5.dta", clear  // Re-run this section Feb 22, 2019 by Machiko
*use "../Data/quarterly_wp_macropru_final6.dta", clear
*use  "../Data/quarterly_wp_macropru_final7.dta", clear (re-run by Machiko on September 5, 2021)
use "../Data/quarterly_wp_macropru_final`str_data_version'.dta", clear
drop *_old
rename dateq quarter
xtset ifscode quarter
sort ifscode quarter



*===============================================================================
* Step 2: Regression analysis
*===============================================================================
*cd "C:\Users\AAlter\Box Sync\iMaPP WP\Results\Macropru"
cd "../Results/Macropru/Dummy"
local addStatGMM addstat(AR(1) Test, e(ar1p), AR(2) Test, e(ar2p))

local varlist allsum_yoy allloansum_yoy demand_side_yoy supply_side_all_yoy supply_loans_yoy supply_general_yoy supply_capital_yoy dsti_yoy ltv_yoy tax_yoy lcg_yoy llp_yoy loanr_yoy capital_yoy ccb_yoy
*local varlist allsum_yoy allloansum_yoy demand_side_yoy supply_side_all_yoy supply_loans_yoy supply_general_yoy supply_capital_yoy dsti_yoy ltv_yoy ltax_yoy lcg_yoy llp_yoy loanr_yoy capital_yoy ccb_yoy
*loanr_yoy lcg_yoy lfc_yoy lfx_yoy llp_yoy lr_yoy ltd_yoy lvr_yoy capital_yoy conservation_yoy rr_yoy sifi_yoy tax_yoy ccb_yoy ot_yoy
local deplist d4lnrhhdebt_w1 d4lnrp_house_w1 d4lnrpvcon_w1 d4lnrgdp_w1
*local deplist d4lnrhhdebt_w1 d4lnrpvcon_w1 d4lnrpvdebt_w1 d4lnrcorpdebt_w1 

capture confirm variable OtherMaPP
if _rc {
	gen OtherMaPP =.
}

foreach var1 in `deplist' {
	local myfile="Results_iMaPP_gmm_`today'_`var1'_v`str_data_version'.xls"
	foreach var2 in `varlist' {

		di "==============================================="
		di " Yvar: `var1'"
		di " ----------------------------------------------"
		di " MaPP var: `var2' "
		di "==============================================="	
		replace OtherMaPP = l.allsum_yoy - l.`var2'

		di "cmd: capture drop l`var2'"
		capture drop l`var2' 
		capture confirm variable l`var2'
		if _rc {
			di "++++++`var2'++++++"
			gen l`var2'=l.`var2'
			*gen l`var2'_old=l.`var2'_old
		}

		capture drop l`var1'
		capture confirm variable l`var1'
		if _rc {
			gen l`var1'=l.`var1'
		}
		if "`var2'" != "allsum_yoy" {

			local Other OtherMaPP
		}
		else {

			local Other

		}			   

		local OtherControls lstrate ld4lnrgdp_w1 d4lnrp_house_w1
		if "`var1'"=="d4lnrgdp_w1" {
			local OtherControls lstrate d4lnrp_house_w1
		}
		if "`var1'"=="d4lnrp_house_w1" {
			local OtherControls lstrate ld4lnrgdp_w1
		}
		local regressors l`var1' `OtherControls' l`var2'

		di "cmd: xtreg `var1' `regressors' i.quarter if year>1990,fe clu(ifscode)"
		qui xtreg `var1' `regressors' i.quarter if year>1990,fe clu(ifscode)
		outreg2  using `myfile', excel append keep(`regressors') addtext(Errors, robust, TIME FE, YES, COU FE, YES, Method, Xtreg, Period, >1990, Group, ALL) label

		xi: qui xtabond2 `var1' `regressors' i.quarter i.isocode if year>1990, gmm(L.(`var1' `regressors'), lag(1 1)) robust orthogonal
		outreg2  using `myfile', excel append keep(`regressors') `addStatGMM' addtext(Errors, robust, COU FE, YES, TIME FE, YES, Method, GMM, Period, >1990, Group, ALL) label

		***

		qui xtreg `var1' `regressors' i.quarter  if year>1990 & AE==1,fe clu(ifscode)
		outreg2  using `myfile', excel append keep(`regressors') addtext(Errors, robust, TIME FE, YES, COU FE, YES, Method, Xtreg, Period, >1990, Group, AE) label

		qui xtabond2 `var1' `regressors' _I*  if year>1990 & AE==1, gmm(L.(`var1' `regressors'), lag(1 1)) robust orthogonal
		outreg2  using `myfile', excel append keep(`regressors') `addStatGMM' addtext(Errors, robust, COU FE, YES, TIME FE, YES, Method, GMM, Period, >1990, Group, AE) label


		***

		qui xtreg `var1' `regressors' i.quarter  if year>1990 & EM==1,fe clu(ifscode)
		outreg2  using `myfile', excel append keep(`regressors') addtext(Errors, robust, TIME FE, YES, COU FE, YES, Method, Xtreg, Period, >1990, Group, EM) label

		qui xtabond2 `var1' `regressors' _I*  if year>1990 & EM==1, gmm(L.(`var1' `regressors'), lag(1 1)) robust orthogonal
		outreg2  using `myfile', excel append keep(`regressors') `addStatGMM' addtext(Errors, robust, COU FE, YES, TIME FE, YES, Method, GMM, Period, >1990, Group, EM) label

	}

}
**********************************
cd "../../../Codes"
log close
exit
