% No FG Eqm
clear all
clc
%% parameter values
sigma = 1; % intertemporal elasiticiy
psi = 1; % frisch elasticity
epsilon = 4; % composite 
sigma_a = 0.1;
kappa_a = 1/sigma_a^2;
tau = epsilon/(sigma+psi);
% tau = 1;

%% define coefficients
alpha = (psi+sigma)/(1+epsilon*psi);
beta = (1+psi)/(1+epsilon*psi);

%% optimal gamma
sigma_s_vec = [0.01:0.01:1]';
L = length(sigma_s_vec);
abar = 1;

kappa_s_vec = zeros(L,1);
gamma_vec = zeros(L,1);
gamma_y_vec = zeros(L,1);
gamma_p_vec = zeros(L,1);

y_eff_vec = zeros(L,1);
p_vec = zeros(L,1);
y_vec = zeros(L,1);

y_eff =  abar*beta/alpha;
y_stab_y = y_eff.*ones(L,1);
y_stab_p = -beta.*ones(L,1);

p_stab_p = zeros(L,1);
p_stab_y = zeros(L,1);

for i = 1:L
    sigma_s = sigma_s_vec(i);
    kappa_s = 1/sigma_s^2;
    
    gamma_1 = tau*alpha*beta*kappa_s*(kappa_s+kappa_a) + (beta/alpha - beta)*kappa_a^2;
    gamma_2 = kappa_a^2 + tau*alpha^2*kappa_s^2;
    gamma = gamma_1/gamma_2;
    
    gamma_ystab = beta/alpha-beta;
    gamma_pstab = (beta/alpha)*(kappa_a + kappa_s)/kappa_s;

    p_abar = abar*((alpha*gamma-beta)*kappa_s-beta*kappa_a)/(kappa_a+alpha*kappa_s);
    y_abar = abar*(beta*kappa_s+(gamma+beta)*kappa_a)/(kappa_a+alpha*kappa_s);
    
    yhat_abar = y_abar - y_eff;
    
    kappa_s_vec(i,1) = kappa_s;
    gamma_vec(i,1) = gamma;
    gamma_y_vec(i,1) = gamma_ystab;
    gamma_p_vec(i,1) = gamma_pstab;
    
    y_eff_vec(i,1) = y_eff;
    p_vec(i,1) = p_abar;
    y_vec(i,1) = y_abar;
    p_stab_y(i,1) = (beta/alpha)*((kappa_a + kappa_s)/kappa_s);
   
end

figure
plot(kappa_s_vec,gamma_y_vec,'b--', 'LineWidth',2)
hold on
plot(kappa_s_vec,gamma_p_vec,'r:', 'LineWidth',2)
plot(kappa_s_vec,gamma_vec,'k', 'LineWidth',2)
xlim([0,2000])
ylim([0,5])
hold off
xlabel 'private signal precision'
% ylabel '\gamma'
% title('optimal monetary policy with no communication')
legend('output-gap stabilization','price-level stabilization','price-output stabilization','Location','northeast')
set(gca,'fontSize',16)

figure
plot(kappa_s_vec,p_vec,'r-.', 'LineWidth',2)
hold on
plot(kappa_s_vec,y_vec,'b', 'LineWidth',2)
hold on
plot(kappa_s_vec,y_eff_vec,'b:', 'LineWidth',2)
xlim([0,2000])
ylim([-1,2])
hold off
xlabel 'private signal precision'
% title('Under Optimal Commitment')
legend('price','output','efficient output','Location','northeast')
set(gca,'fontSize',16)


