% SCFG Eqm
clear all
clc
%% parameter values
sigma = 1; % intertemporal elasiticiy
psi = 1; % frisch elasticity
epsilon = 4; % composite 
sigma_a = 0.1;
kappa_a = 1/sigma_a^2;
sigma_s = 0.1;
kappa_s = 1/sigma_s^2;

tau = epsilon/(sigma+psi);

%% define coefficients
alpha = (psi+sigma)/(1+epsilon*psi);
beta = (1+psi)/(1+epsilon*psi);

%% optimal gamma
sigma_m_vec = [0.01:0.01:1]';
L = length(sigma_m_vec);

kappa_m_vec = zeros(L,1);
gamma_a_vec = zeros(L,1);
gamma_v_vec = zeros(L,1);
ya_vec = zeros(L,1);
yv_vec = zeros(L,1);
pa_vec = zeros(L,1);
pv_vec = zeros(L,1);
ya_eff_vec = zeros(L,1);
yv_eff_vec = zeros(L,1);

%% iteration
for i = 1:L
    sigma_m = sigma_m_vec(i);
    kappa_m = 1/sigma_m^2;
    K = kappa_a + kappa_m + kappa_s;
    K_1 = kappa_a + kappa_m + alpha*kappa_s;
    syms gamma_a gamma_v
    
    rho_m = gamma_a*kappa_m/(kappa_m+kappa_s+kappa_a) + gamma_v*(kappa_s+kappa_a)/(kappa_m+kappa_s+kappa_a);
    rho_a = (gamma_a-gamma_v)*kappa_s/(kappa_m+kappa_s+kappa_a);
    phi_m = rho_m + (rho_a*(1-alpha) - beta*(1-alpha)/alpha)*(kappa_m/(alpha*kappa_s + kappa_a + kappa_m));
    phi_a = (alpha*rho_a - beta)*K/(kappa_m+kappa_a+alpha*kappa_s);
    
    dphi_mrho_m = 1;
    dphi_mrho_a = (1-alpha)*kappa_m/(alpha*kappa_s + kappa_a + kappa_m);
    dphi_arho_m = 0;
    dphi_arho_a = alpha*(1-alpha)*kappa_s/K_1 + alpha;
    drho_mgamma_a = kappa_m/K;
    drho_agamma_a = kappa_s/K;
    drho_mgamma_v = (kappa_s + kappa_a)/K;
    drho_agamma_v = -kappa_s/K;
            
    dphi_mgamma_a = dphi_mrho_m*drho_mgamma_a + dphi_mrho_a*drho_agamma_a;
    dphi_agamma_a = dphi_arho_m*drho_mgamma_a + dphi_arho_a*drho_agamma_a;
    dphi_mgamma_v = dphi_mrho_m*drho_mgamma_v + dphi_mrho_a*drho_agamma_v;
    dphi_agamma_v = dphi_arho_m*drho_mgamma_v + dphi_arho_a*drho_agamma_v;
            
    eqn1 = tau*((phi_m + phi_a)*(dphi_mgamma_a + dphi_agamma_a)*sigma_a^2 + phi_m*dphi_mgamma_a*sigma_m^2)+...
                (gamma_a - phi_m - phi_a - beta/alpha)*(1 - dphi_mgamma_a - dphi_agamma_a)*sigma_a^2 + (gamma_v - phi_m)*(-dphi_mgamma_a)*sigma_m^2;
    eqn2 = tau*((phi_m + phi_a)*(dphi_mgamma_v + dphi_agamma_v)*sigma_a^2 + phi_m*dphi_mgamma_v*sigma_m^2)+...
                (gamma_a - phi_m - phi_a - beta/alpha)*(- dphi_mgamma_v - dphi_agamma_v)*sigma_a^2 + (gamma_v - phi_m)*(1-dphi_mgamma_v)*sigma_m^2;
            
    sol = solve([eqn1, eqn2], [gamma_a, gamma_v]);
    gamma_a_n = sol.gamma_a;
    gamma_v_n = sol.gamma_v;
            
    rho_m = gamma_a_n*kappa_m/(kappa_m+kappa_s+kappa_a) + gamma_v_n*(kappa_s+kappa_a)/(kappa_m+kappa_s+kappa_a);
    rho_a = (gamma_a_n-gamma_v_n)*kappa_s/(kappa_m+kappa_s+kappa_a);
    phi_m = rho_m + (rho_a*(1-alpha) - beta*(1-alpha)/alpha)*kappa_m/(alpha*kappa_s + kappa_a + kappa_m);
    phi_a = (alpha*rho_a - beta)*K/(kappa_m+kappa_a+alpha*kappa_s);
    
    IR_a = 1; IR_v = 1;
    p_a = (phi_m + phi_a)*IR_a; 
    y_a = (gamma_a_n - phi_m - phi_a)*IR_a;
    p_v = phi_m*IR_v; 
    y_v = (gamma_v_n - phi_m)*IR_v;
                        
    
    kappa_m_vec(i,1) = kappa_m;
    gamma_a_vec(i,1) = gamma_a_n;
    gamma_v_vec(i,1) = gamma_v_n;
    
    pa_vec(i,1) = p_a;
    ya_vec(i,1) = y_a;
    ya_eff_vec(i,1) = beta/alpha;
    
    pv_vec(i,1) = p_v;
    yv_vec(i,1) = y_v;
    yv_eff_vec(i,1) = 0;
end

figure
plot(kappa_m_vec,gamma_a_vec,'k--','LineWidth',2)
hold on
plot(kappa_m_vec,pa_vec,'r-.','LineWidth',2)
hold on
plot(kappa_m_vec,ya_vec,'b','LineWidth',2)
hold on
plot(kappa_m_vec,ya_eff_vec,'b:','LineWidth',2)
xlim([0,2000])
ylim([-0.5,1.5])
hold off
xlabel 'public signal precision'
% title('Equilibrium After A Positive Technology Shock')
set(gca,'fontSize',16)

figure
plot(kappa_m_vec,gamma_v_vec,'k--','LineWidth',2)
hold on
plot(kappa_m_vec,pv_vec,'r-.','LineWidth',2)
hold on
plot(kappa_m_vec,yv_vec,'b','LineWidth',2)
hold on
plot(kappa_m_vec,yv_eff_vec,'b:','LineWidth',2)
xlim([0,2000])
ylim([-0.5,1.5])
hold off
xlabel 'public signal precision'
% title('Equilibrium After A Positive Technology Shock')
legend('monetary policy','price','output','efficient output','Location','northeast')
set(gca,'fontSize',16)

