% Welfare
clear all
clc
%% parameter values
sigma = 1; % intertemporal elasiticiy
psi = 1; % frisch elasticity
epsilon = 4; % composite 
sigma_a = 0.1;
kappa_a = 1/sigma_a^2;
sigma_s = 0.1;
kappa_s = 1/sigma_s^2;
tau = epsilon/(sigma+psi);
% tau = 1;

%% define coefficients
alpha = (psi+sigma)/(1+epsilon*psi);
beta = (1+psi)/(1+epsilon*psi);

sigma_m_vec = [0.01:0.01:1]';
L = length(sigma_m_vec);

%% NFG
gamma_1 = tau*alpha*beta*kappa_s*(kappa_s+kappa_a) + (beta/alpha - beta)*kappa_a^2;
gamma_2 = kappa_a^2 + tau*alpha^2*kappa_s^2;
gamma = gamma_1/gamma_2;

p_NFG = ((alpha*gamma-beta)*kappa_s-beta*kappa_a)/(kappa_a+alpha*kappa_s);
y_NFG = (beta*kappa_s+(gamma+beta)*kappa_a)/(kappa_a+alpha*kappa_s);
y_eff =  beta/alpha;
yhat_NFG = y_NFG - y_eff;

var_p_N = p_NFG^2*sigma_s^2;
var_a_N = sigma_s^2;
cov_pa_N = p_NFG*(sigma_s^2);
var_y_N = yhat_NFG^2*sigma_a^2;

w_loss_N = epsilon*var_p_N + var_a_N + 2*epsilon*cov_pa_N + (sigma+psi)*var_y_N;
w_N_varp_vec = var_p_N.*ones(L,1);
w_N_cov_vec = cov_pa_N.*ones(L,1);
w_N_vary_vec = var_y_N.*ones(L,1);
w_N_vec = w_loss_N.*ones(L,1);


%% SCFG 
kappa_m_vec = zeros(L,1);
w_SC_vec = zeros(L,1);
w_SC_varp_vec = zeros(L,1);
w_SC_cov_vec = zeros(L,1);
w_SC_vary_vec = zeros(L,1);
phi_a_vec = zeros(L,1);
phi_m_vec = zeros(L,1);

for i = 1:L
    sigma_m = sigma_m_vec(i);
    kappa_m = 1/sigma_m^2;
    K = kappa_a + kappa_m + kappa_s;
    K_1 = kappa_a + kappa_m + alpha*kappa_s;
    syms gamma_a gamma_v
    
    rho_m = gamma_a*kappa_m/(kappa_m+kappa_s+kappa_a) + gamma_v*(kappa_s+kappa_a)/(kappa_m+kappa_s+kappa_a);
    rho_a = (gamma_a-gamma_v)*kappa_s/(kappa_m+kappa_s+kappa_a);
    phi_m = rho_m + (rho_a*(1-alpha) - beta*(1-alpha)/alpha)*(kappa_m/(alpha*kappa_s + kappa_a + kappa_m));
    phi_a = (alpha*rho_a - beta)*K/(kappa_m+kappa_a+alpha*kappa_s);
    
    dphi_mrho_m = 1;
    dphi_mrho_a = (1-alpha)*kappa_m/(alpha*kappa_s + kappa_a + kappa_m);
    dphi_arho_m = 0;
    dphi_arho_a = alpha*(1-alpha)*kappa_s/K_1 + alpha;
    drho_mgamma_a = kappa_m/K;
    drho_agamma_a = kappa_s/K;
    drho_mgamma_v = (kappa_s + kappa_a)/K;
    drho_agamma_v = -kappa_s/K;
            
    dphi_mgamma_a = dphi_mrho_m*drho_mgamma_a + dphi_mrho_a*drho_agamma_a;
    dphi_agamma_a = dphi_arho_m*drho_mgamma_a + dphi_arho_a*drho_agamma_a;
    dphi_mgamma_v = dphi_mrho_m*drho_mgamma_v + dphi_mrho_a*drho_agamma_v;
    dphi_agamma_v = dphi_arho_m*drho_mgamma_v + dphi_arho_a*drho_agamma_v;
            
    eqn1 = tau*((phi_m + phi_a)*(dphi_mgamma_a + dphi_agamma_a)*sigma_a^2 + phi_m*dphi_mgamma_a*sigma_m^2)+...
                (gamma_a - phi_m - phi_a - beta/alpha)*(1 - dphi_mgamma_a - dphi_agamma_a)*sigma_a^2 + (gamma_v - phi_m)*(-dphi_mgamma_a)*sigma_m^2;
    eqn2 = tau*((phi_m + phi_a)*(dphi_mgamma_v + dphi_agamma_v)*sigma_a^2 + phi_m*dphi_mgamma_v*sigma_m^2)+...
                (gamma_a - phi_m - phi_a - beta/alpha)*(- dphi_mgamma_v - dphi_agamma_v)*sigma_a^2 + (gamma_v - phi_m)*(1-dphi_mgamma_v)*sigma_m^2;
            
    sol = solve([eqn1, eqn2], [gamma_a, gamma_v]);
    gamma_a_n = sol.gamma_a;
    gamma_v_n = sol.gamma_v;
            
    rho_m = gamma_a_n*kappa_m/(kappa_m+kappa_s+kappa_a) + gamma_v_n*(kappa_s+kappa_a)/(kappa_m+kappa_s+kappa_a);
    rho_a = (gamma_a_n-gamma_v_n)*kappa_s/(kappa_m+kappa_s+kappa_a);
    phi_m = rho_m + (rho_a*(1-alpha) - beta*(1-alpha)/alpha)*kappa_m/(alpha*kappa_s + kappa_a + kappa_m);
    phi_a = (alpha*rho_a - beta)*K/(kappa_m+kappa_a+alpha*kappa_s);
    
    p_ai = phi_a;
    phi_a_vec(i,1) = phi_a;
    phi_m_vec(i,1) = phi_m;
    p_abar = phi_m + phi_a;
    p_m = phi_m;
    y_a = (gamma_a_n - phi_m - phi_a) - beta/alpha;
    y_v = (gamma_v_n - phi_m);
                        
    var_p_SCFG = p_ai^2*sigma_s^2;
    var_a_SCFG = sigma_s^2;
    cov_pa_SCFG = phi_a*sigma_s^2;
    var_y_SCFG = y_a^2*sigma_a^2 + y_v^2*sigma_m^2;
    
    w_loss_SC = epsilon*var_p_SCFG + var_a_SCFG + 2*epsilon*cov_pa_SCFG + (sigma+psi)*var_y_SCFG;
    w_SC_vec(i,1) = w_loss_SC;
    kappa_m_vec(i,1) = kappa_m;
    w_SC_varp_vec(i,1) = var_p_SCFG;
    w_SC_cov_vec(i,1) = cov_pa_SCFG;
    w_SC_vary_vec(i,1) = var_y_SCFG;
end

figure
% subplot(2,2,1)
plot(kappa_m_vec,w_N_vec,'k--','LineWidth',2)
hold on
plot(kappa_m_vec,w_SC_vec,'r-','LineWidth',2)
xlim([0,2000])
% ylim([-1,2])
hold off
xlabel 'public signal precision'
% title('Welfare Loss')
legend('NFG','SCFG','Location','northeast')
set(gca,'fontSize',16)

figure
% subplot(2,2,1)
plot(kappa_m_vec,w_N_varp_vec,'k--','LineWidth',2)
hold on
plot(kappa_m_vec,w_SC_varp_vec,'r-','LineWidth',2)
xlim([0,2000])
% ylim([-1,2])
hold off
xlabel 'public signal precision'
% title('var_i(p_i)')
% legend('NFG','SCFG','Location','northeast')
set(gca,'fontSize',16)

figure
% subplot(2,2,3)
plot(kappa_m_vec,w_N_cov_vec,'k--','LineWidth',2)
hold on
plot(kappa_m_vec,w_SC_cov_vec,'r-','LineWidth',2)
xlim([0,2000])
% ylim([-1,2])
hold off
xlabel 'public signal precision'
% title('cov(p_i, a_i)')
% legend('NFG','SCFG','Location','northeast')
set(gca,'fontSize',16)

figure
% subplot(2,2,4)
plot(kappa_m_vec,w_N_vary_vec,'k--','LineWidth',2)
hold on
plot(kappa_m_vec,w_SC_vary_vec,'r-','LineWidth',2)
xlim([0,2000])
% ylim([-1,2])
hold off
xlabel 'public signal precision'
% title('var(y)')
% legend('NFG','SCFG','Location','northeast')
set(gca,'fontSize',16)
% 
% figure
% plot(kappa_m_vec,phi_a_vec,'k--','LineWidth',2)
% hold on
% plot(kappa_m_vec,phi_m_vec,'r-.','LineWidth',2)
% xlim([0,100])
% % ylim([-1,2])
% hold off
% xlabel 'public signal precision'
% title('Welfare Loss')
% legend('phi_a','phi_m','Location','northeast')
% set(gca,'fontSize',16)

