% This file estimates the IRF of proxy SVAR for a monetary SVAR
% This program is adapted from replication files of Mertens and Ravn, 2014, 'A
% Reconciliation of SVAR and Narrative Estimates of Tax Mulitpliers', JME

% Note: the number of bootstrap replications is set to 100 for speed (the paper uses 10000)
% In my case, ffr is tax, lip is G, lcpi is Y, lcons is W.
clear all; close all;
clc;

% Load the data 

% Load the data
DATA = xlsread('data_m.xlsx',2);
% line 1: Dates
% line 2: log(IP)
% line 3: unemployment rate
% line 4: log(CPI)
% line 5: federal funds rate
% line 6: log(commodity price)
% line 7: log(ah)
% line 8: log(th)
% line 9: log(emp)
% line 10: Romer shock, estimated using full sample
% line 11: Gini 1
% line 12: Gini 2



%  Proxy SVAR
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
 dates = DATA(:,1);

 VARNA.vars  = DATA(:,[5,9,7,4]);
 VARNA.p = 12;
 [T,n]  = size(VARNA.vars);
 VARNA.DET = ones(T,1);
 VARNA.irhor = 48;

 VARNA.mshocks = DATA(:,10);
 
 % Demean the narrative shocks
  for j=1:size(VARNA.mshocks,2)
     VARNA.mshocks(VARNA.mshocks(:,j)~=0,j)=(VARNA.mshocks(VARNA.mshocks(:,j)~=0,j)-mean(VARNA.mshocks(VARNA.mshocks(:,j)~=0,j)));
  end
  
DAT.TRY = 0.1746; % Average ratio of federal tax revenues to GDP
DAT.GY  = 0.0981; % Average ratio of federal expenditures to GDP

VARNA.mshocksize =  1;
VARNA.gshocksize =  0.01/DAT.GY; % left in because one of the other programs needs it
VARNA = doPVAR(VARNA);
nboot = 1000; % Note:  the paper uses 10000
clevel = 68; % Confidence Level
VARNAbs = doPVARbs(VARNA,DAT,nboot,clevel);


% Plot Impulse Response to a Monetary Shock
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   H = 47;
    weight=zeros(H+1,H+1);
    weight(1,1)=1; % End-points are not MAs
    weight(H+1,H+1)=1;
    
    for i=2:H
        weight(i,i-1:i+1)=[1/3 1/3 1/3]; % Centred three-period moving average
    end
    
    VARNA.irs = VARNAbs.irsM; % Point estimate vs. median
    
    VARNA.irs(:,2)  = VARNA.irs(:,2)'*weight'; 
    VARNAbs.irsH(:,2) = VARNAbs.irsH(:,2)'*weight'; 
    VARNAbs.irsL(:,2) = VARNAbs.irsL(:,2)'*weight'; 
    
    
    VARNA.irs(:,3)  = VARNA.irs(:,3)'*weight'; 
    VARNAbs.irsH(:,3) = VARNAbs.irsH(:,3)'*weight'; 
    VARNAbs.irsL(:,3) = VARNAbs.irsL(:,3)'*weight'; 
    
    
    VARNA.irs(:,1)  = VARNA.irs(:,1)'*weight'; 
    VARNAbs.irsH(:,1) = VARNAbs.irsH(:,1)'*weight'; 
    VARNAbs.irsL(:,1) = VARNAbs.irsL(:,1)'*weight'; 
   
    f=figure('Units','normalized','Position',[0.2,0.2,.2,.3]) 
    
    box off
        plot(-100*VARNA.irs(:,2),'LineWidth',2,'Color', [0 0 0.5]);
        hold on       
        plot(-100*VARNAbs.irsH(:,2),'LineWidth',1,'Color',[0 0 0.5],'LineStyle','--' ); 
        hold on
        plot(-100*VARNAbs.irsL(:,2),'LineWidth',1,'Color',[0 0 0.5],'LineStyle','--' ); 
        hold on
        %axis([0 48 FIG.axes(4,1) FIG.axes(4,2)])
        hline(0,'k-')
        ti=title('Employment');
        xl=xlabel('months');
        yl=ylabel('percent');
    
         set([xl,yl],'FontSize',14);
        set([ti], 'FontName', 'Times New Roman','FontSize',16); 
        grid on
        
        set(gcf,'PaperPositionMode','auto')
        print -depsc2 emp.eps
        
        
        
         f=figure('Units','normalized','Position',[0.2,0.2,.2,.3]) 
    
    box off
        plot(-100*VARNA.irs(:,3),'LineWidth',2,'Color', [0 0 0.5]);
        hold on       
        plot(-100*VARNAbs.irsH(:,3),'LineWidth',1,'Color',[0 0 0.5],'LineStyle','--' ); 
        hold on
        plot(-100*VARNAbs.irsL(:,3),'LineWidth',1,'Color',[0 0 0.5],'LineStyle','--' ); 
        hold on
        %axis([0 48 FIG.axes(4,1) FIG.axes(4,2)])
        hline(0,'k-')
        ti=title('Total Hours');
        xl=xlabel('months');
        yl=ylabel('percent');
    
         set([xl,yl],'FontSize',14);
        set([ti], 'FontName', 'Times New Roman','FontSize',16); 
        grid on
        
        set(gcf,'PaperPositionMode','auto')
        print -depsc2 th.eps
        
        
        
         
         
  