!	----------------------------------------------------------------------
!	File name: Globals.f90
!
!	Defines global variables.
!	----------------------------------------------------------------------


module Globals

	implicit none

	save


	!	grids

	real(8), parameter:: amin = -1.0D0, amax = 200.0D0, curv = 2.0D0
	integer, parameter:: na = 201, nx = 17, nk = 5, ng = 5, nda = 1000
	


	!	fixed model parameters

	real(8), parameter:: alpha = 0.33D0, delta = 0.025D0, hbar = 0.114D0, eps = 10.0D0, phi = 1.5D0, phi_y = 0.25D0, theta = 0.75D0
	
	
	!	model parameters to be read

	real(8):: bta, B, gama, avex, rhox, sigex, aveg, rhog, sigeg, Kss, Wss, kbnd, gbnd, Fcost, Yss


	!	auxiliary variables

	real(8):: irate, wage, income, hour, sigx, sigG, wmax, wmin,divd, mc, r_k, ffr, sdf, price, nwage, work, eta


	!	storages

	real(8):: agrid(na), dagrid(nda), xgrid(nx), exgrid(nx), Kgrid(nk), Ggrid(ng), eGgrid(ng), trX(nx,nx), CtrX(nx,nx), prX(nx), trG(ng,ng), CtrG(ng,ng), mu0(nda,nx), VF0(na,nx)
	real(8), dimension(na,nx,nk,ng):: ASE, ASN, HR, VFE, VFN, AS, VF, PF 


	!	coefficients of equations

	integer,parameter:: ncoef = 3
	real(8), dimension(ncoef):: Kcoef, NewKcoef, Wcoef, NewWcoef, Dcoef, NewDcoef, Pcoef, NewPcoef, Ycoef, NewYcoef, Mcoef, NewMcoef, Ccoef, NewCcoef, Rcoef, NewRcoef
    


	!	maximum number of iterations, tolerence for converce check

	integer, parameter:: maxiterLOM = 40, MAXITER = 10000, Nperiod = 2500, Nskip = 500, NYperiod = Nperiod /4
	real(8), parameter:: tol_LOM = 1.0D-3, sfac = 0.5D0


	!	simulated time series data

	real(8), dimension(Nperiod+1):: Kdata, Gdata
    integer, dimension(Nperiod+1):: GIdata
	real(8), dimension(Nperiod)::  Ldata, Rdata, Wdata, Ydata, Hdata, Idata, Cdata, Adata, Edata, Pdata, Ddata, Mdata, Rfdata, VFdata
    real(8), dimension(Nperiod):: G_I, G_L, G_K, G_W, G_C, G_LZ
    real(8), dimension(5,Nperiod):: INCS, LINCS, LINCZS, KINCS, WLTHS, CONS, & 
                                     HOURS_E, CON_E, INC_E, LINC_E, KINC_E, WLTH_E, VF_E, EMP_E
    real(8), dimension(5,NYperiod) :: TWLTH, TLINC, TKINC, TINC, THOURS,THOURS_Z, TCON, TLINC_W
    real(8), dimension(NYperiod):: GYdata, GEdata, GHdata, GWdata, GHZdata, GCdata, CVdata, CVZdata


	!	indexing variables
		
	integer:: ia, ja, ix, jx, ik, ig, jg, iter, indiv, time, iterLOM, time_y


	!	improvement of coefficients

	real(8) errK, errW, errD, errP, errY, errM, errC, errR, err


	!	timer

	character(8)::  startdate, finishdate, today
	character(10):: starttime, finishtime, solvetime, simultime


end module
