!	----------------------------------------------------------------------
!	Module name: InitializationModule.f90
!	----------------------------------------------------------------------


module InitializationModule

	use Globals
	use ValueModule
	use TauchenMod


	implicit none


contains


subroutine InitializeParameters()


	open(1, file='Input/Parameters.txt', status = 'old')
	read(1, *) bta
	read(1, *) B
	read(1, *) gama
	read(1, *) rhox
	read(1, *) sigex
	read(1, *) rhog
	read(1, *) sigeg    
	read(1, *) Kss
	read(1, *) Wss	
    read(1, *) Yss
    read(1, *) Fcost
	read(1, *) kbnd	
	read(1, *) gbnd    
    

	sigx = sigex/dsqrt(1.0D0-rhox**2)
	sigG = sigeg/dsqrt(1.0D0-rhog**2)

	avex = 0.0D0
	aveg = 0.0D0
    
    
    eta = theta*(eps-1.0D0)/((1.0D0-theta)*(1.0D0-bta*theta))
    !print *, eta
    !pause
      
            


	!	write parameter values on log file

	open(0, file='Output/Logfile.txt', status='unknown')

end subroutine




subroutine InitializeCoefficients()

	open(1, file='Input/CoefficientsIN.txt', status = 'old')
	read(1, *) Kcoef	
    read(1, *) Ycoef
    read(1, *) Ccoef
    read(1, *) Pcoef
    read(1, *) Wcoef
    read(1, *) Rcoef
    read(1, *) Mcoef
    read(1, *) Dcoef


end subroutine




subroutine InitializeAgrid()


	!	construct unequally spaced asset grids

	agrid(1) = amin
	do ia = 2, na
		agrid(ia) = agrid(1) + (amax-amin)*((ia-1.0D0)/(na-1.0D0))**curv
	end do


	! save grid

	open(1, file='Output/agrid.txt', status='unknown')
	write(1, '(f12.6)') agrid
	close(1)
	
	
end subroutine



subroutine InitializeDAgrid()


	!	construct unequally spaced asset grids

	dagrid(1) = amin
	do ia = 2, nda
		dagrid(ia) = dagrid(1) + (amax-amin)*((ia-1.0D0)/(nda-1.0D0))**curv
	end do


	! save grid

	open(1, file='Output/dagrid.txt', status='unknown')
	write(1, '(f12.6)') dagrid
	close(1)
	
	
end subroutine




subroutine InitializeXgrid()

	
	real(8) xmax, xmin, step
	

	!	xgrid

	xmax = avex + 3.0D0*sigx
	xmin = avex - 3.0D0*sigx
	step = (xmax - xmin)/(nx - 1)

	xgrid(1) = xmin
	do ix = 2, nx
		xgrid(ix) = xgrid(ix-1) + step
	end do
	exgrid = dexp(xgrid)


	!	save grids

	open(1, file='Output/xgrid.txt', status='unknown')
	write(1,'(<2>f12.6)') (xgrid(ix), exgrid(ix), ix=1,nx)
	close(1)


end subroutine



subroutine InitializeKgrid()


	real(8):: kmax, kmin, step


	!	step for grid construction

	kmax = kss*(1.0D0 + kbnd)
	kmin = kss*(1.0D0 - kbnd)
	step = (kmax - kmin)/(nk - 1)

	
	!	aggregate capital grid

	kgrid(1) = kmin
	do ik = 2, nk
		kgrid(ik) = kgrid(ik-1) + step
	end do


	!	save grid

	open(1, file='Output/kgrid.txt', status='unknown')
	write(1, '(f12.6)') kgrid
	close(1)


end subroutine





subroutine InitializeGgrid()

	
	real(8) gmax, gmin, step
	

	!	Ggrid

	gmax = aveg + gbnd*sigG
	gmin = aveg - gbnd*sigG
	step = (gmax - gmin)/(ng - 1)

	Ggrid(1) = gmin
    
	do ig = 2, ng
		Ggrid(ig) = Ggrid(ig-1) + step
    end do
    
	eGgrid = dexp(Ggrid)

    
    !	save grids

	open(1, file='Output/Ggrid.txt', status='unknown')
	write(1,'(<2>f12.6)') (Ggrid(ig), eGgrid(ig), ig=1,ng)
	close(1)
    


end subroutine



subroutine InitializeIdiosyncraticTransition()

	
	real(8) prXp(nx), err


	!	transition probability matrix

	call TauchenTr(avex, sigx, rhox, xgrid, trX)
	
	open(1, file='Output/trX.txt', status='unknown')
	write(1, '(<nx>f12.6)') ((trX(ix,jx),jx=1,nx),ix=1,nx)
	close(1)


	!	cumulative transition probability matrix for random drawing

	CtrX(:,1) = trX(:,1)
	do ix = 2, nx
		CtrX(:,ix) = CtrX(:,ix-1) + trX(:,ix)
	end do

	open(2, file='Output/CtrX.txt', status='unknown')
	write(2, '(<nx>f12.6)') ((CtrX(ix,jx),jx=1,nx),ix=1,nx)


	!	invariant distribution of shocks

	call TauchenNew(avex, sigx, xgrid, prX)

	do while (err < 1.0e-10)

		prXp = matmul(transpose(trX), prX)
		err = maxval(dabs(prXp-prX))
		prX = prXp
	
	end do


	if (dabs(1.0D0 - sum(prX)) <= 1.0e-6) then
		prX = prX/sum(prX)
	else
		print*, "Fatal Error in InvariantProbability"
		stop
	end if


	!	save transition probability matrix and invariant probability

	open(2, file='Output/prX.txt', status='unknown')
	write(2, '(f20.16)') prX
	close(2)


end subroutine



subroutine InitializeAggregateTransition()


	!	transition probability matrix for government shock

	call TauchenTr(aveg, sigg, rhog, Ggrid, trG)

	open(1, file='Output/trG.txt', status='unknown')
	write(1, '(<ng>f12.6)') ((trG(ig,jg),jg=1,ng),ig=1,ng)
	close(1)


	!	cumulative transition matrix of aggregate shock for random drawing

	CtrG(:,1) = trG(:,1)
	do ig = 2, ng
		CtrG(:,ig) = CtrG(:,ig-1) + trG(:,ig)
	end do

	open(2, file='Output/CtrG.txt', status='unknown')
	write(2, '(<ng>f12.6)') ((CtrG(ig,jg),jg=1,ng),ig=1,ng)
	close(2)


end subroutine



subroutine InitializeValue()


	! initialize value function and decision rules

	VF = 0.0D0
    mu0 = 1.0D0/(nx*nda)

    !call ReadV0()
    !call ReadValueFunction()

    
end subroutine



end module
