!	----------------------------------------------------------------------
!	File name : Main.f90
!
!	Main program that solves the model with aggregate fluctuations.
!	----------------------------------------------------------------------


program Fluctuations


	use Globals
	use InitializationModule
	use ValueModule
	use SimulationModule
 

	implicit none


	!	set the starting time

	call date_and_time(startdate, starttime)


	!	initialize parameters and global variables

	call InitializeParameters()
	call InitializeCoefficients()


	!	construct grids

	call InitializeAgrid()
    call InitializeDAgrid()
	call InitializeXgrid()
	call InitializeKgrid()
	call InitializeGgrid()


	!	initialize transition probability matrix

	call InitializeIdiosyncraticTransition()
	call InitializeAggregateTransition()


	!	initialize value function and decision rule for asset

	call InitializeValue()


	!	initialize aggregate shock for simulation

	call GenerateAggregateShocks()


	!	iteration on laws of motion

	do iterLOM = 1, maxiterLOM




		!	solve value function

		call date_and_time(today,solvetime)

		write(0, '(//A,I2)')     "Coefficients of Equations in Iteration ", iterLOM
		write(0, '(/A, 4F10.5)') "Law of Motion for Kapital:     ", Kcoef
        write(0, '( A, 4F10.5)') "Prediction Function for Output:", Ycoef
        write(0, '( A, 4F10.5)') "Prediction Function for Co:    ", Ccoef
        write(0, '( A, 4F10.5)') "Prediction Function for Price: ", Pcoef
		write(0, '( A, 4F10.5)') "Prediction Function for Wage:  ", Wcoef
        write(0, '( A, 4F10.5)') "Prediction Function for FFR:   ", Rcoef
        write(0, '( A, 4F10.5)') "Prediction Function for MC:    ", Mcoef
        write(0, '( A, 4F10.5)') "Prediction Function for Divd:  ", Dcoef
                
        
		write(0, '(/A, I2,12A)') "SolveValueFunction in Iteration ", iterLOM, " started at ", today(1:4),"-",today(5:6),"-",today(7:8)," ", solvetime(1:2),":",solvetime(3:4),":",solvetime(5:6)

		call SolveValueFunction()
		call SaveValueFunction()
		call SaveValueFunction2()


		!	generate artificial data through simulation

		call date_and_time(today,simultime)

		write(0, '(/A,I2,12A)') "Simulation in Iteration ", iterLOM, " started at ", today(1:4),"-",today(5:6),"-",today(7:8)," ", simultime(1:2),":",simultime(3:4),":",simultime(5:6)

		call SimulateData()        
		call SaveSimulatedTimeSeriesData()
        call Save_Annual_Data()
  

		!	updata laws of motion through regressions of simulated data

		call Regress()
		
		errK = maxval(dabs(NewKcoef - Kcoef))
		errW = maxval(dabs(NewWcoef - Wcoef))
        errR = maxval(dabs(NewRcoef - Rcoef))
        !errD = maxval(dabs(NewDcoef - Dcoef))
        errD = 0.0
        errC = maxval(dabs(NewCcoef - Ccoef))
        errP = maxval(dabs(NewPcoef - Pcoef))
        errY = maxval(dabs(NewYcoef - Ycoef))
        errM = maxval(dabs(NewMcoef - Mcoef))
		err  = max(errK, errW, errD, errP, errY, errM, errC, errR)

		Kcoef = sfac*NewKcoef + (1.0D0 - sfac)*Kcoef
		Wcoef = sfac*NewWcoef + (1.0D0 - sfac)*Wcoef
        !Dcoef = sfac*NewDcoef + (1.0D0 - sfac)*Dcoef
        Dcoef = Dcoef
        Rcoef = sfac*NewRcoef + (1.0D0 - sfac)*Rcoef
        Ccoef = sfac*NewCcoef + (1.0D0 - sfac)*Ccoef
        Pcoef = sfac*NewPcoef + (1.0D0 - sfac)*Pcoef
        Ycoef = sfac*NewYcoef + (1.0D0 - sfac)*Ycoef
        Mcoef = sfac*NewMcoef + (1.0D0 - sfac)*Mcoef
        
        call SaveCoefficients()
        !call Savemu()
         


		!	convergence test

		if (err < tol_LOM) then
			write(0, '(//A,I2)') "Errors in LOM Iteration ", iterLOM
			write(0, '(/3(A,F10.6))') "errK = ", errK, "    errY = ", errY, "    errC = ", errC
            write(0, '(/3(A,F10.6))') "errP = ", errP, "    errW = ", errW, "    errR = ", errR
            write(0, '(/3(A,F10.6))') "errM = ", errM, "    errD = ", errD
			write(0, '(//A,I2)')      "Law of Motion converged at iteration ", iterLOM
			write(0, '(/A)')          "Converged Coefficients of Equations"
		    write(0, '(/A, 4F10.5)') "Law of Motion for Kapital:     ", Kcoef
            write(0, '( A, 4F10.5)') "Prediction Function for Output:", Ycoef
            write(0, '( A, 4F10.5)') "Prediction Function for Co:    ", Ccoef
            write(0, '( A, 4F10.5)') "Prediction Function for Price: ", Pcoef
		    write(0, '( A, 4F10.5)') "Prediction Function for Wage:  ", Wcoef
            write(0, '( A, 4F10.5)') "Prediction Function for FFR:  ", Rcoef 
            write(0, '( A, 4F10.5)') "Prediction Function for MC:    ", Mcoef
            write(0, '( A, 4F10.5)') "Prediction Function for Divd:  ", Dcoef
            
          
			exit 
		else
			write(0, '(//A,I2)') "Errors in LOM Iteration ", iterLOM
			write(0, '(/3(A,F10.6))') "errK = ", errK, "    errY = ", errY, "    errC = ", errC
            write(0, '(/3(A,F10.6))') "errP = ", errP, "    errW = ", errW, "    errR = ", errR
            write(0, '(/3(A,F10.6))') "errM = ", errM, "    errD = ", errD
		end if

	end do


	!	set the finishing time

	call date_and_time(finishdate,finishtime)

	
	!	print the starting and finishing times

	write(0, '(/)') 
	write(0, '(12A)') "The program started at  ", startdate(1:4),"-",startdate(5:6),"-",startdate(7:8)," ", starttime(1:2),":",starttime(3:4),":",starttime(5:6)
	write(0, '(12A)') "The program finished at ", finishdate(1:4),"-",finishdate(5:6),"-",finishdate(7:8)," ", finishtime(1:2),":",finishtime(3:4),":",finishtime(5:6)
	write(*, '(/)') 
	write(*, '(12A)') "The program started at  ", startdate(1:4),"-",startdate(5:6),"-",startdate(7:8)," ", starttime(1:2),":",starttime(3:4),":",starttime(5:6)
	write(*, '(12A)') "The program finished at ", finishdate(1:4),"-",finishdate(5:6),"-",finishdate(7:8)," ", finishtime(1:2),":",finishtime(3:4),":",finishtime(5:6)

	
end program Fluctuations
