!	----------------------------------------------------------------------
!	Module name: Regression.f90
!
!	regresses simulated data to get new law of motion for aggregate
!	capital and price equations.
!	----------------------------------------------------------------------


subroutine Regress()

	use Globals
	use LeastSquareModule

	implicit none
	
	integer, parameter:: nobs = Nperiod-Nskip
	real(8):: RHS(nobs,ncoef)
    real(8):: COVB(ncoef,ncoef), tstat(ncoef), r_sq, adjr_sq, chisq
	real(8):: w(ncoef), v(ncoef,ncoef)    
	integer:: icoef

	
	!	construct common regressors

	RHS(:,1) = 1.0D0
	RHS(:,2) = dlog(Kdata(Nskip+1:Nperiod))
	RHS(:,3) = dlog(Gdata(Nskip+1:Nperiod))    


	!	law of motion for aggregate capital

	call lsfit(RHS, dlog(Kdata(Nskip+2:Nperiod+1)), NewKcoef, COVB, tstat, r_sq, adjr_sq, chisq)

	write(0, '(//A/)')    "Summary statistics for K equation                "
	write(0, '(A,F20.4)') "R^2 (in percent):                                ", r_sq*100.0D0
	write(0, '(A,F20.4)') "Adjusted R^2 (in percent):                       ", adjr_sq*100.0D0
	write(0, '(A,F20.4)') "Mean of the response (dependent) variable:       ", sum(Kdata(Nskip+2:Nperiod+1))/nobs
	write(0, '(A6,3(A15))') " ", "Estimate", "St. err", "t-stat"
	do icoef = 1, ncoef
	    write(0, '(A2,I2,A2,4F15.6)') "C(",icoef,")", NewKcoef(icoef), dsqrt(COVB(icoef,icoef)), tstat(icoef)
    end do
    
    
    
    !	prediction function for output

	call lsfit(RHS, dlog(Ydata(Nskip+1:Nperiod)), NewYcoef, COVB, tstat, r_sq, adjr_sq, chisq)

	write(0, '(//A/)')    "Summary statistics for Y equation                "
	write(0, '(A,F20.4)') "R^2 (in percent):                                ", r_sq*100.0D0
	write(0, '(A,F20.4)') "Adjusted R^2 (in percent):                       ", adjr_sq*100.0D0
	write(0, '(A,F20.4)') "Mean of the response (dependent) variable:       ", sum(Ydata(Nskip+1:Nperiod))/(nobs)
	write(0, '(A6,3(A15))') " ", "Estimate", "St. err", "t-stat"
	do icoef = 1, ncoef
	    write(0, '(A2,I2,A2,4F15.6)') "C(",icoef,")", NewYcoef(icoef), dsqrt(COVB(icoef,icoef)), tstat(icoef)
	end do


    
    
    
    !	prediction function for consumption

	call lsfit(RHS, dlog(Cdata(Nskip+1:Nperiod)), NewCcoef, COVB, tstat, r_sq, adjr_sq, chisq)

	write(0, '(//A/)')    "Summary statistics for C equation                "
	write(0, '(A,F20.4)') "R^2 (in percent):                                ", r_sq*100.0D0
	write(0, '(A,F20.4)') "Adjusted R^2 (in percent):                       ", adjr_sq*100.0D0
	write(0, '(A,F20.4)') "Mean of the response (dependent) variable:       ", sum(Cdata(Nskip+1:Nperiod))/(nobs)
	write(0, '(A6,3(A15))') " ", "Estimate", "St. err", "t-stat"
	do icoef = 1, ncoef
	    write(0, '(A2,I2,A2,4F15.6)') "C(",icoef,")", NewCcoef(icoef), dsqrt(COVB(icoef,icoef)), tstat(icoef)
    end do
    
    
      !	prediction function for price

	call lsfit(RHS, dlog(Pdata(Nskip+1:Nperiod)), NewPcoef, COVB, tstat, r_sq, adjr_sq, chisq)

	write(0, '(//A/)')    "Summary statistics for P equation                "
	write(0, '(A,F20.4)') "R^2 (in percent):                                ", r_sq*100.0D0
	write(0, '(A,F20.4)') "Adjusted R^2 (in percent):                       ", adjr_sq*100.0D0
	write(0, '(A,F20.4)') "Mean of the response (dependent) variable:       ", sum(Pdata(Nskip+1:Nperiod))/(nobs)
	write(0, '(A6,3(A15))') " ", "Estimate", "St. err", "t-stat"
	do icoef = 1, ncoef
	    write(0, '(A2,I2,A2,4F15.6)') "C(",icoef,")", NewPcoef(icoef), dsqrt(COVB(icoef,icoef)), tstat(icoef)
    end do
    
    
	!	prediction function for wage

	call lsfit(RHS, dlog(Wdata(Nskip+1:Nperiod)), NewWcoef, COVB, tstat, r_sq, adjr_sq, chisq)

	write(0, '(//A/)')    "Summary statistics for W equation                "
	write(0, '(A,F20.4)') "R^2 (in percent):                                ", r_sq*100.0D0
	write(0, '(A,F20.4)') "Adjusted R^2 (in percent):                       ", adjr_sq*100.0D0
	write(0, '(A,F20.4)') "Mean of the response (dependent) variable:       ", sum(Wdata(Nskip+1:Nperiod))/(nobs)
	write(0, '(A6,3(A15))') " ", "Estimate", "St. err", "t-stat"
	do icoef = 1, ncoef
	    write(0, '(A2,I2,A2,4F15.6)') "C(",icoef,")", NewWcoef(icoef), dsqrt(COVB(icoef,icoef)), tstat(icoef)
    end do
    
    
    
    
	!	prediction function for wage

	call lsfit(RHS, dlog(Rfdata(Nskip+1:Nperiod)), NewRcoef, COVB, tstat, r_sq, adjr_sq, chisq)

	write(0, '(//A/)')    "Summary statistics for FFR equation              "
	write(0, '(A,F20.4)') "R^2 (in percent):                                ", r_sq*100.0D0
	write(0, '(A,F20.4)') "Adjusted R^2 (in percent):                       ", adjr_sq*100.0D0
	write(0, '(A,F20.4)') "Mean of the response (dependent) variable:       ", sum(Rfdata(Nskip+1:Nperiod))/(nobs)
	write(0, '(A6,3(A15))') " ", "Estimate", "St. err", "t-stat"
	do icoef = 1, ncoef
	    write(0, '(A2,I2,A2,4F15.6)') "C(",icoef,")", NewRcoef(icoef), dsqrt(COVB(icoef,icoef)), tstat(icoef)
    end do
    
    
     !	prediction function for mc

	call lsfit(RHS, dlog(Mdata(Nskip+1:Nperiod)), NewMcoef, COVB, tstat, r_sq, adjr_sq, chisq)

	write(0, '(//A/)')    "Summary statistics for M equation                "
	write(0, '(A,F20.4)') "R^2 (in percent):                                ", r_sq*100.0D0
	write(0, '(A,F20.4)') "Adjusted R^2 (in percent):                       ", adjr_sq*100.0D0
	write(0, '(A,F20.4)') "Mean of the response (dependent) variable:       ", sum(Mdata(Nskip+1:Nperiod))/(nobs)
	write(0, '(A6,3(A15))') " ", "Estimate", "St. err", "t-stat"
	do icoef = 1, ncoef
	    write(0, '(A2,I2,A2,4F15.6)') "C(",icoef,")", NewMcoef(icoef), dsqrt(COVB(icoef,icoef)), tstat(icoef)
    end do
    
    
    
    
    !	prediction function for profit

	call lsfit(RHS, Ddata(Nskip+1:Nperiod), NewDcoef, COVB, tstat, r_sq, adjr_sq, chisq)

	write(0, '(//A/)')    "Summary statistics for D equation                "
	write(0, '(A,F20.4)') "R^2 (in percent):                                ", r_sq*100.0D0
	write(0, '(A,F20.4)') "Adjusted R^2 (in percent):                       ", adjr_sq*100.0D0
	write(0, '(A,F20.4)') "Mean of the response (dependent) variable:       ", sum(Ddata(Nskip+1:Nperiod))/(nobs)
	write(0, '(A6,3(A15))') " ", "Estimate", "St. err", "t-stat"
	do icoef = 1, ncoef
	    write(0, '(A2,I2,A2,4F15.6)') "C(",icoef,")", NewDcoef(icoef), dsqrt(COVB(icoef,icoef)), tstat(icoef)
    end do
    
    
  
    


end subroutine
