!	----------------------------------------------------------------------
!	Module name: SimulationModule.f90
!
!	collection of sub-programs to simulate artificial data
!	----------------------------------------------------------------------



Module SimulationModule


	use Globals
	use LinInterpModule
	use OptimizationMod
    use sorting
    use sorting2
    use distribution


	
	implicit none


	real(8), dimension(nda,nx) :: DAS, DASE, DASN, DASEC, DASNC, DVFE, DVFN, &
                                  DHR, DCON, DWORK, DEL, DINC, DLINC, DKINC, DOUTPUT, DWLTH, DVF, DX
    integer, dimension(nda,nx) :: DASI	
	real, external:: sunif, snorm
	!	sunif is okay with double precision but snorm should be single precision

	
	real(8), dimension(na,nx,nk,4):: cscoef_vf_k    
	real(8), dimension(na,nx):: VF_time
    real(8), dimension(ng):: rhs_1, rhs_2
	real(8):: vf_work, vf_home, as_work, as_home, constraint, xmin, cscoef_vf_a(na,4), erhs, lbd ,ubd, ct, hr_home, hr_work, ap_hour
	real(8), external:: csval
    real(8), parameter::  huge = 1.0D30
    integer:: maxfunc, maxfunc_p
	real(8):: errrel, errabs, errrel_m, errabs_m, lbd_m, ubd_m, lbd_w, ubd_w


contains



!	----------------------------------------------------------------------
!	File name: SimulateData.f90
!
!	generate artificial data for aggregate capital, interest rate, and 
!	wage rate through simulating individuals' decision rules. These data
!	will be used in RegressLOM().
!	----------------------------------------------------------------------


subroutine SimulateData()


	


	!	tolerance for DZBREN

 	errrel    = 1.0D-5
	errabs	  = 1.0D-6
        


	!	set the seed number for random number generator


	!	initial aggregate capital

	Kdata(1) = kss
    	

	!	start generating artificial time series data

	do time = 1, nperiod
       



		!	interpolate value function along K-dimension

		do ix = 1, nx

			do ia = 1, na

				call csint(nk, kgrid, PF(ia,ix,:,GIdata(time)), cscoef_vf_k(ia,ix,:,:))

			end do

        end do


	
        !	evaluate VFE_time_p VFN_time_p ASE_time_p ASN_time_p at Kdata(t+1)
        
       Kdata(time+1) = min(max(dexp(Kcoef(1) + Kcoef(2)*dlog(Kdata(time)) + Kcoef(3)*dlog(Gdata(time))), Kgrid(1)), Kgrid(nk))
				

		do ix = 1, nx            
			do ia = 1, na

				VF_time(ia,ix) = csval(nk, Kdata(time+1), kgrid, cscoef_vf_k(ia,ix,:,:))

            end do
        end do
        
        
       
        
       
        ! Find FFR    
        Cdata(time)   = dexp(Ccoef(1) + Ccoef(2)*dlog(Kdata(time)) + Ccoef(3)*dlog(Gdata(time)))    
        
        
         call Find_FFR()
         Rfdata(time) = ffr
         
         
        ! Find price                         
        !ffr   = dexp(Rcoef(1) + Rcoef(2)*dlog(Kdata(time)) + Rcoef(3)*dlog(Gdata(time)))  
        Ydata(time)   = dexp(Ycoef(1) + Ycoef(2)*dlog(Kdata(time)) + Ycoef(3)*dlog(Gdata(time)))   
        price = dexp((dlog(ffr)-dlog(Gdata(time))-dlog(1.0D0/bta)-phi_y*dlog(Ydata(time)/Yss))/phi)               
        Pdata(time) = price  
                                                                            
                
        !	Find MC        
        !price   = dexp(Pcoef(1) + Pcoef(2)*dlog(Kdata(time)) + Pcoef(3)*dlog(Gdata(time)))    
            
        call RHS()  
       
        mc = (eta*(price-1.0D0)*price -erhs - 1.0D0 + eps)/eps     
        Mdata(time) = mc
        
       
         !	find wage that makes labor market clear 
               
        
        divd = Dcoef(1) + Dcoef(2)*dlog(Kdata(time)) + Dcoef(3)*dlog(Gdata(time)) 
            
            maxfunc = 1000
		    lbd_w = wss*0.9D0
		    ubd_w = wss*1.1D0

		    if (Solve_W(lbd_w) > 0.0D0) then
			    wage = lbd_w
			    print *, "Wgrid(1) is too large."
		    else if (Solve_W(ubd_w) < 0.0D0) then
			    wage = ubd_w
			    print *, "Wgrid(nw) is too small."
		    else
			    call DZBREN(Solve_W, errabs, errrel, lbd_w, ubd_w, maxfunc)
			    wage = ubd_w
            end if
        
        Wdata(time) = wage
        Rdata(time) = r_k
                     
                
        
        ! Optimization given actural eta and prices
            
        do ix = 1, nx
            
                call csint(na, agrid, VF_time(:,ix), cscoef_vf_a)
                
			    !	choose between working and not-working

			    do ia = 1, nda

		
				    !	working
			
				    work = 1.0D0			    
                    constraint = (1.0D0+r_k)*dagrid(ia) + divd
                    
                    lbd = amin+divd
				    ubd = min(constraint + wage*gh(1.0D0)*exgrid(ix), amax)
					call fmin(NegValueF, lbd, ubd, xmin)			    
                    
				    vf_work = ValueF(xmin)
                    as_work = xmin
                    hr_work = hour

				    !	not-working
			
				    work = 0.0D0
				    constraint = min((1.0D0+r_k)*dagrid(ia) + divd, amax)
                    
                    lbd = amin+divd
				    ubd = constraint
					call fmin(NegValueF, lbd, ubd, xmin)			    
				               				    
				    vf_home = ValueF(xmin)
                    as_home = xmin
                    hr_home = 0.0D0
                    
                    
			        if (vf_work >= vf_home) then

				    DVF(ia,ix) = vf_work
                    DAS(ia,ix) = as_work
                    DHR(ia,ix) = hr_work                   
                    DEL(ia,ix) = exgrid(ix)*gh(DHR(ia,ix))
                    DWORK(ia,ix) = 1.0D0
                    
                    
                    else
                        
                    DVF(ia,ix) = vf_home
                    DAS(ia,ix) = as_home
                    DHR(ia,ix) = 0.0D0
                    DEL(ia,ix) = 0.0D0
                    DWORK(ia,ix) = 0.0D0
                                       

                    end if
                    
                    DWLTH(ia,ix) = dagrid(ia)
                    DINC(ia,ix) = r_k*dagrid(ia) + wage*gh(DHR(ia,ix))*exgrid(ix)
                    DX(ia,ix) = exgrid(ix)
                    DLINC(ia,ix) = wage*gh(DHR(ia,ix))*exgrid(ix)
                    DKINC(ia,ix) = r_k*dagrid(ia)
                    DCON(ia,ix) = DINC(ia,ix) + dagrid(ia)  + divd - DAS(ia,ix)        


                end do
        end do               
           

		!	generate time series data for aggregate macro variables

		!Kdata(time+1) = min(max(sum(DAS*mu0), kgrid(1)), kgrid(nk))
        Kdata(time+1) = sum(DAS*mu0)                
        Hdata(time) = sum(DHR*mu0)
        Ldata(time) = sum(DEL*mu0)
        Edata(time) = sum(DWORK*mu0)     
        Rfdata(time) = ffr   
		Cdata(time) = sum(DCON*mu0)
        VFdata(time) = sum(DVF*mu0)
        Idata(time) = Kdata(time+1) - (1.0D0-delta)*Kdata(time)
		Ydata(time) = Kdata(time)**alpha*Ldata(time)**(1.0D0-alpha) - fcost
        Ddata(time) = Ydata(time) - Wdata(time)*Ldata(time) - (delta+Rdata(time))*Kdata(time) - 0.5D0*(Pdata(time) - 1.0D0)**2.0D0*Ydata(time)
        
		! Compute Distributions
        
        call CalculateINEQ()   
        
        ! Generate Annual Data
        
        call Gen_Annual_Data()   
		      
        
        !	prepare for the simulation in the next period
		call Nextmu()
        
                       


		!	show how simulation is going on

		if (mod(time, 4) == 0) then
			print *, "time = ", time	
			print *, "G    = ", Gdata(time)            
			print *, "K    = ", Kdata(time)
			print *, "Kp   = ", Kdata(time+1)
			print *, "E    = ", Edata(time)
            print *, "H    = ", Hdata(time)
			print *, "L    = ", Ldata(time)
			print *, "Y    = ", Ydata(time)
			print *, "C    = ", Cdata(time)
			print *, "W    = ", Wdata(time)
            print *, "P    = ", Pdata(time)
			print *, "D    = ", Ddata(time)       
            print *, "FFR  = ", Rfdata(time)       
            print *, "MC   = ", Mdata(time)   			
            print *, "CVZ  = ", CVZdata(time_y)   			
            print *, " "
        end if
        
                


	end do



end subroutine



real(8) function Solve_W(W_t)


	real(8):: W_t, LD
    
   
    
    wage  = W_t
    r_k = mc**(1.0D0/alpha)*alpha*(wage/(1.0D0-alpha))**((alpha-1.0D0)/alpha) - delta 
       
            
        do ix = 1, nx
            
                call csint(na, agrid, VF_time(:,ix), cscoef_vf_a)
                
			    !	choose between working and not-working

			    do ia = 1, nda

		
				    !	working
			
				    work = 1.0D0			    
                    constraint = (1.0D0+r_k)*dagrid(ia) + divd
                    
                    lbd = amin+divd
				    ubd = min(constraint + wage*gh(1.0D0)*exgrid(ix), amax)
					call fmin(NegValueF, lbd, ubd, xmin)			    
                    
				    vf_work = ValueF(xmin)
                    as_work = xmin
                    hr_work = hour

				    !	not-working
			
				    work = 0.0D0
				    constraint = min((1.0D0+r_k)*dagrid(ia) + divd, amax)
                    
                    lbd = amin+divd
				    ubd = constraint
					call fmin(NegValueF, lbd, ubd, xmin)			    
				               				    
				    vf_home = ValueF(xmin)
                    as_home = xmin
                    hr_home = 0.0D0
                    
                    
			        if (vf_work >= vf_home) then

				    DVF(ia,ix) = vf_work
                    DAS(ia,ix) = as_work
                    DHR(ia,ix) = hr_work                   
                    DEL(ia,ix) = exgrid(ix)*gh(DHR(ia,ix))
                    DWORK(ia,ix) = 1.0D0
                    
                    
                    else
                        
                    DVF(ia,ix) = vf_home
                    DAS(ia,ix) = as_home
                    DHR(ia,ix) = 0.0D0
                    DEL(ia,ix) = 0.0D0
                    DWORK(ia,ix) = 0.0D0
                                       

                    end if
                    
                    DWLTH(ia,ix) = dagrid(ia)
                    DINC(ia,ix) = r_k*dagrid(ia) + wage*gh(DHR(ia,ix))*exgrid(ix)
                    DLINC(ia,ix) = wage*gh(DHR(ia,ix))*exgrid(ix)
                    DKINC(ia,ix) = r_k*dagrid(ia)
                    DCON(ia,ix) = DINC(ia,ix) + dagrid(ia)  + divd - DAS(ia,ix)       


                end do
        end do        
        
        

	!	excess labor demand

	Ldata(time) = sum(DEL*mu0)
	LD = ((mc*(1.0D0-alpha))/wage)**(1.0D0/alpha)*Kdata(time)
    	
	Solve_W = Ldata(time) - LD
                   
    
end function






subroutine GenerateAggregateShocks()


	integer:: gseed
	real(8):: gshock


	!	set the seed number for random number generator

	gseed = 2


	!	generate Gdata

    GIdata(1) = 3
    
    
    
    
	do time = 2, NPeriod+1
		gshock = sunif(gseed)
        
		do jg = 1, ng
			if (gshock <= CtrG(GIdata(time-1),jg)) then
				GIdata(time) = jg
				exit
			end if
		
		end do
	end do
	Gdata =  eGgrid(GIdata)


	!	save aggregate productivity series

	open(1, file='Output/Gdata.txt', status='replace')
	write(1, '(F12.6)') Gdata
	close(1)
       


end subroutine


 

real(8) function SolveHour(xhour)

	implicit none

	real(8), parameter:: tiny = 1.0D-20
	real(8) cons, xhour

	
    cons = constraint + wage*gh(xhour)*exgrid(ix) - ap_hour
    
    if (cons <= 0.0D0) then
        SolveHour=  -huge 
    else
	    SolveHour =  dlog(cons) - B*xhour**(1.0D0+1.0D0/gama)/(1.0D0+1.0D0/gama)
    end if

end function



real(8) function ValueFh(xhour)

	implicit none

	real(8) xhour

	ValueFh = SolveHour(xhour) + bta*csval(na, ap_hour, agrid, cscoef_vf_a)

end function




real(8) function NegValueFh(xhour)

	implicit none

	real(8) xhour

	NegValueFh = -ValueFh(xhour)

end function


real(8) function Utility(ap)

	implicit none

	real(8), parameter:: tiny = 1.0D-20, tol_hour = 1.0D-5
	real(8) ap, xhour_min, cm
	
	if (work == 1.0D0) then
	ap_hour = ap

	call fmin(NegValueFh, hbar, 0.7D0, xhour_min)   

    hour = xhour_min
    cm = constraint + wage*gh(hour)*exgrid(ix)  - ap
    
    else
        
    hour = 0.0D0
    cm = constraint  - ap
    
    end if
    

    if (cm <= 0.0D0) then 
        Utility = -huge
    else
	    Utility = dlog(cm) - B*hour**(1.0D0+1.0D0/gama)/(1.0D0+1.0D0/gama)
    end if



end function



real(8) function ValueF(ap)

	implicit none

	real(8) ap

	ValueF = Utility(ap) + bta*csval(na, ap, agrid, cscoef_vf_a)

end function


real(8) function NegValueF(ap)

	implicit none

	real(8) ap

	NegValueF = -ValueF(ap)

end function




real(8) function gh(h)

	implicit none

	real(8) h

	gh = max(h-hbar, 0.0D0)

end function




subroutine Nextmu()

        real(8) ::  half_a, half_b, half_first, half_last,  Fmu(nda,nx), mu1(nda,nx)


        do ix = 1, nx
        do ia = 1, nda

                half_first = (dagrid(2)-dagrid(1))/2.0D0         
                half_last = (dagrid(nda)-dagrid(nda-1) )/2.0D0    

                if (DAS(ia,ix) < dagrid(1) + half_first) then
			        DASI(ia,ix) = 1
		        else if (DAS(ia,ix) >= dagrid(nda) - half_last) then
			        DASI(ia,ix) = nda
		        else
			        do ja = 2, nda-1
                
                        half_a = (dagrid(ja) - dagrid(ja-1) )/2.0D0    
                        half_b = (dagrid(ja+1) - dagrid(ja))/2.0D0                  
                
				        if (DAS(ia,ix) >= dagrid(ja) - half_a .and. DAS(ia,ix) < dagrid(ja) + half_b) then
					        DASI(ia,ix) = ja
					        exit
				        end if
			        end do
                end if
        end do
        end do


        Fmu = 0.0D0

		do ix = 1, nx
		do ia = 1, nda

			Fmu(DASI(ia,ix),ix) = Fmu(DASI(ia,ix),ix) + mu0(ia,ix)

		end do
		end do

		
		!	next period measures

		mu1 = 0.0D0
		mu1 = matmul(Fmu, trX)
		mu1 = mu1/sum(mu1)
        
        mu0 = mu1
	

end subroutine




subroutine RHS()

  real(8) ::  yp, pp, cp, exp_v(ng), wp, mp, rp, kp
 
       
  
  ! Compute RHS
 
            
            do ig = 1, ng
                
                kp = dexp(Kcoef(1) + Kcoef(2)*dlog(Kdata(time)) + Kcoef(3)*dlog(eGgrid(ig)))       
                !kp = Kdata(time+1)
                cp = dexp(Ccoef(1) + Ccoef(2)*dlog(kp) + Ccoef(3)*dlog(eGgrid(ig)))       
                pp = dexp(Pcoef(1) + Pcoef(2)*dlog(kp) + Pcoef(3)*dlog(eGgrid(ig)))
                yp = dexp(Ycoef(1) + Ycoef(2)*dlog(kp) + Ycoef(3)*dlog(eGgrid(ig)))                   

                exp_v(ig) = eta*bta*(Cdata(time)/cp)*(pp-1.0D0)*pp*(yp/Ydata(time))
                
            end do
            
            
            erhs = 0.0D0
                              
		    do jg = 1, ng		        
			    erhs = erhs + exp_v(jg)*trG(GIdata(time),jg)               
            end do
            
end subroutine






subroutine Find_FFR()

  real(8) ::  yp, pp, cp, exp_v(ng), kp
 
      
   ! Compute Price given the Eq. 1 = (beta*Et[Ct/Ct+1]*FFR/[Pt+1/Pt])
   
   
    do ig = 1, ng
                
     kp = dexp(Kcoef(1) + Kcoef(2)*dlog(Kdata(time)) + Kcoef(3)*dlog(eGgrid(ig)))       
     !kp = Kdata(time+1)
     cp = dexp(Ccoef(1) + Ccoef(2)*dlog(kp) + Ccoef(3)*dlog(eGgrid(ig)))                                                              
     pp = dexp(Pcoef(1) + Pcoef(2)*dlog(kp) + Pcoef(3)*dlog(eGgrid(ig)))
     
     exp_v(ig) = bta*(Cdata(time)/cp)*(1.0D0/pp) 
     
    end do
    
     ffr = 0.0D0
     do jg = 1, ng		        
			    ffr = ffr + exp_v(jg)*trG(GIdata(time),jg)                
     end do
            
     ffr = 1.0D0/ffr
     
end subroutine




 subroutine CalculateINEQ()   
                                
                         
            ! Inequality data
            
            call dist(DINC, mu0, nda,  nx, 5, INCS(:,time), G_I(time))
            call dist(DLINC, mu0, nda,  nx, 5, LINCS(:,time), G_L(time))
            call dist_zero(DLINC, mu0, nda,  nx, 5, LINCZS(:,time), G_LZ(time))
            call dist(DKINC, mu0, nda,  nx, 5, KINCS(:,time), G_K(time))
            call dist(DWLTH, mu0, nda,  nx, 5, WLTHS(:,time), G_W(time))            
            call dist(DCON, mu0, nda,  nx, 5, CONS(:,time), G_C(time))            
            
            call dist2(DX, DHR, mu0, nda,  nx, 5, HOURS_E(:,time))            
            call dist2(DX, DCON, mu0, nda,  nx, 5, CON_E(:,time))            
            call dist2(DX, DWLTH, mu0, nda,  nx, 5, WLTH_E(:,time))
            call dist2(DX, DINC, mu0, nda,  nx, 5, INC_E(:,time))
            call dist2(DX, DLINC, mu0, nda,  nx, 5, LINC_E(:,time))
            call dist2(DX, DKINC, mu0, nda,  nx, 5, KINC_E(:,time))
            call dist2(DX, DVF, mu0, nda,  nx, 5,  VF_E(:,time))
            call dist2(DX, DWORK, mu0, nda,  nx, 5, EMP_E(:,time))            
                                  
          
            
            HOURS_E(:,time) = sum(mu0*DHR)*HOURS_E(:,time)*0.05            
            CON_E(:,time) = sum(mu0*DCON)*CON_E(:,time)*0.05            
            WLTH_E(:,time) = sum(mu0*DWLTH)*WLTH_E(:,time)*0.05
            INC_E(:,time) = sum(mu0*DINC)*INC_E(:,time)*0.05
            LINC_E(:,time) = sum(mu0*DLINC)*LINC_E(:,time)*0.05
            KINC_E(:,time) = sum(mu0*DKINC)*KINC_E(:,time)*0.05
            VF_E(:,time) = sum(mu0*DVF)*VF_E(:,time)*0.05
            EMP_E(:,time) = sum(mu0*DWORK)*EMP_E(:,time)*0.05  
                 
            
    

 end subroutine
 
 
 

 subroutine Gen_Annual_Data()   
                                
     real(8), dimension(nda,nx,4) :: asst, incm, kinc, linc, hours , con, mu    
     real(8), dimension(nda,nx) :: asst_y, inc_y, kinc_y, linc_y, hours_y, con_y, linc_w_y, tem_h, muz     
     real(8) :: ah, ahz
            
            if (mod(time,4) == 1) then
              
                    asst(:,:,1) = DWLTH
                    incm(:,:,1) = DINC
                    linc(:,:,1) = DLINC
                    kinc(:,:,1) = DKINC
                    hours(:,:,1) = DHR
                    con(:,:,1) = DCON
             
        
            else if (mod(time,4) == 2) then               
                    
                    asst(:,:,2) = DWLTH
                    incm(:,:,2) = DINC
                    linc(:,:,2) = DLINC
                    kinc(:,:,2) = DKINC
                    hours(:,:,2) = DHR
                    con(:,:,2) = DCON                                 
        
            else if (mod(time,4) == 3) then
                 
                    asst(:,:,3) = DWLTH
                    incm(:,:,3) = DINC
                    linc(:,:,3) = DLINC
                    kinc(:,:,3) = DKINC
                    hours(:,:,3) = DHR
                    con(:,:,3) = DCON
        
            else if (mod(time,4) == 0) then
                
                    time_y = time/4
                
                    asst(:,:,4) = DWLTH
                    incm(:,:,4) = DINC
                    linc(:,:,4) = DLINC
                    kinc(:,:,4) = DKINC
                    hours(:,:,4) = DHR
                    con(:,:,4) = DCON 
                    
                    
                    asst_y = asst(:,:,4)
                    inc_y = sum(incm,3)
                    linc_y = sum(linc,3)
                    kinc_y = sum(kinc,3)
                    hours_y = sum(hours,3)
                    con_y = sum(con,3)                                       
        
            
    
    
                ! Inequality data
                
                
            call dist(asst_y, mu0, nda, nx, 5, TWLTH(:,time_y), GWdata(time_y))  
            call dist(con_y, mu0, nda, nx, 5, TCON(:,time_y), GCdata(time_y))  
            call dist(inc_y, mu0, nda, nx, 5, TINC(:,time_y), GYdata(time_y))  
            call dist(linc_y, mu0, nda, nx, 5, TLINC(:,time_y), GEdata(time_y))              
            call dist(hours_y, mu0, nda, nx, 5, THOURS(:,time_y), GHdata(time_y))  
            call dist_zero(hours_y,mu0, nda, nx, 5, THOURS_Z(:,time_y), GHZdata(time_y))  
            call dist2(asst_y, linc_y, mu0, nda, nx, 5, TLINC_W(:,time_y))   
            
            
            ! Compute CV
            tem_h = 0.0D0
            
            do ix = 1, nx
            do ia = 1, nda
                if (hours_y(ia,ix) > 0.0D0) then                    
                tem_h(ia,ix) = 1.0D0
                end if
                
            end do
            end do
            
            AH = sum(hours_y*mu0)            
            muz = tem_h*mu0/sum(tem_h*mu0)
            AHZ = sum(hours_y*muz)                     
            
            CVdata(time_y) = (sum((hours_y-AH)**2.0D0*mu0))**0.5D0/AH
            CVZdata(time_y) = (sum((hours_y-AHZ)**2.0D0*muz))**0.5D0/AHZ
            
            end if
                 

 end subroutine

end module
