!	----------------------------------------------------------------------
!	module name: ValueModule.f90
!
!	collection of sub-programs to calculate value function and decision 
!	rule for the next period asset holdings.
!	----------------------------------------------------------------------


module ValueModule

	use Globals
	use LinInterpModule
	use OptimizationMod

	implicit none

	real(8), parameter:: tol_cnvrg = 1.0D-4, huge = 1.0D30
	real(8):: cscoef_ap(na,4), cscoef_kp(nk,4), VFP(na), constraint, kp, lbd, ubd, xmin, ap_hour
	real(8), external:: csval


contains



subroutine SolveValueFunction()


	real(8), dimension(na,nx,nk,ng):: NewVFE, NewVFN, NewASE, NewASN, NewVF, NewAS
	real(8):: err, errV, errA


	!	start iteration

	do iter = 1, MAXITER


		!	expected value function: PF(a,x,k,p) = E[V(a,x',k,p'|x,p]
	
		call ExpectedValueFunction()
	
	
		!	maximization procedure

		do ig = 1, ng
		do ik = 1, nk                        


			kp   = min(max(dexp(Kcoef(1) + Kcoef(2)*dlog(Kgrid(ik)) + Kcoef(3)*dlog(eGgrid(ig))), Kgrid(1)), Kgrid(nk))
		    wage = dexp(Wcoef(1) + Wcoef(2)*dlog(Kgrid(ik)) + Wcoef(3)*dlog(eGgrid(ig)))
            mc = dexp(Mcoef(1) + Mcoef(2)*dlog(Kgrid(ik)) + Mcoef(3)*dlog(eGgrid(ig)))
            price = dexp(Pcoef(1) + Pcoef(2)*dlog(Kgrid(ik)) + Pcoef(3)*dlog(eGgrid(ig)))
            divd = Dcoef(1) + Dcoef(2)*dlog(Kgrid(ik)) + Dcoef(3)*dlog(eGgrid(ig))			
            r_k = mc**(1.0D0/alpha)*alpha*(wage/(1.0D0-alpha))**((alpha-1.0D0)/alpha) - delta
            
            
            !print *, wage, r_k, divd
            !pause
                    
            
			do ix = 1, nx

				!	interpolating at kp

				do ia = 1, na
					call csint(nk, kgrid, PF(ia,ix,:,ig), cscoef_kp)                    
					VFP(ia) = csval(nk, kp, kgrid, cscoef_kp)
				end do


				!	interpolating along agrid

				call csint(na, agrid, VFP, cscoef_ap)



				!	choose between working and not-working

				do ia = 1, na

		
					!	working
			
					work = 1.0D0				
                    constraint = (1.0D0+r_k)*agrid(ia)+divd
				               

				    lbd = amin+divd
				    ubd = min(constraint + wage*gh(1.0D0)*exgrid(ix), amax)
					call fmin(NegValueF, lbd, ubd, xmin)
					NewASE(ia,ix,ik,ig) = xmin
					NewVFE(ia,ix,ik,ig) = ValueF(NewASE(ia,ix,ik,ig))


					!	not-working
			
					work = 0.0D0
					constraint = min((1.0D0+r_k)*agrid(ia) + divd, amax)         
				               
				    lbd = amin+divd
				    ubd = constraint
                    
					call fmin(NegValueF, lbd, ubd, xmin)
					NewASN(ia,ix,ik,ig) = xmin
					NewVFN(ia,ix,ik,ig) = ValueF(NewASN(ia,ix,ik,ig))

					
					!	value of (ia,ix,iw,ik,ig)

					if (NewVFE(ia,ix,ik,ig) >= NewVFN(ia,ix,ik,ig)) then
						NewVF(ia,ix,ik,ig) = NewVFE(ia,ix,ik,ig)
                        NewAS(ia,ix,ik,ig) = NewASE(ia,ix,ik,ig)
					else
		
						NewVF(ia,ix,ik,ig) = NewVFN(ia,ix,ik,ig)
                        NewAS(ia,ix,ik,ig) = NewASN(ia,ix,ik,ig)
					end if

				end do

			end do

		end do
		end do


		!	calculate errors

		errV = maxval(dabs(NewVF - VF))
        errA = maxval(dabs(NewAS - AS))
        err = max(errV, errA)


		!	update value function and decision rules

		VF = NewVF
        AS = NewAS



		!	convergence check

		if (errV < tol_cnvrg) then
			write(*, '(/A,I5,/)') "Individual Optimization is done at iteration " ,iter
			write(*, '(4(A,F9.6),/)') "errV = ", errV, "    errA = ", errA
			exit 
		else if (mod(iter, 10) == 0 .or. iter <= 10) then
			write(*, '(/A,I5)') "SolveValueFunction iteration ", iter
			write(*, '(4(A,F9.6),/)') "errV = ", errV, "    errA = ", errA
		end if

	end do

	
end subroutine




real(8) function SolveHour(xhour)

	implicit none

	real(8), parameter:: tiny = 1.0D-20
	real(8) cons, xhour

	
    cons = constraint + wage*gh(xhour)*exgrid(ix) - ap_hour
    
    if (cons <= 0.0D0) then
        SolveHour=  -huge 
    else
	    SolveHour =  dlog(cons) - B*xhour**(1.0D0+1.0D0/gama)/(1.0D0+1.0D0/gama)
    end if

end function



real(8) function ValueFh(xhour)

	implicit none

	real(8) xhour

	ValueFh = SolveHour(xhour) + bta*csval(na, ap_hour, agrid, cscoef_ap)

end function




real(8) function NegValueFh(xhour)

	implicit none

	real(8) xhour

	NegValueFh = -ValueFh(xhour)

end function


real(8) function Utility(ap)

	implicit none

	real(8), parameter:: tiny = 1.0D-20, tol_hour = 1.0D-5
	real(8) ap, xhour_min, cm
	
	if (work == 1.0D0) then
	ap_hour = ap

	call fmin(NegValueFh, hbar, 0.7D0, xhour_min)   

    hour = xhour_min
    cm = constraint + wage*gh(hour)*exgrid(ix)  - ap
    
    else
        
    hour = 0.0D0
    cm = constraint  - ap
    
    end if
    

    if (cm <= 0.0D0) then 
        Utility = -huge
    else
	    Utility = dlog(cm) - B*hour**(1.0D0+1.0D0/gama)/(1.0D0+1.0D0/gama)
    end if



end function



real(8) function ValueF(ap)

	implicit none

	real(8) ap

	ValueF = Utility(ap) + bta*csval(na, ap, agrid, cscoef_ap)

end function


real(8) function NegValueF(ap)

	implicit none

	real(8) ap

	NegValueF = -ValueF(ap)

end function




real(8) function gh(h)

	implicit none

	real(8) h

	gh = max(h-hbar, 0.0D0)

end function




subroutine ExpectedValueFunction()


	PF = 0.0D0

	do ig = 1, ng
	do ik = 1, nk
	do ix = 1, nx
	do ia = 1, na

		do jg = 1, ng
		do jx = 1, nx

			PF(ia,ix,ik,ig) = PF(ia,ix,ik,ig) + VF(ia,jx,ik,jg)*trX(ix,jx)*trG(ig,jg)
		
		end do
		end do
	
	end do
	end do
    end do
    end do
      

end subroutine





end module
