!	----------------------------------------------------------------------
!	File name: AggregateCapital.f90
!
!	- Calculates the aggregate capital by numerically integrating 
!	the measure, and then interest rate.
!
!   - Calculates Transition Matrix among the occupational states
!	----------------------------------------------------------------------


subroutine AggregateVariables()

	use Globals
	use dfport
    use Inequality


 

	implicit none



	real(8) :: AK, AH, AE,  AKE, irateb, wageb, Prod, Empl, etoe, eton, ntoe, nton, Diff1, AC, AvH, profit, nshare, cv_h, cv_hz
               
	integer i, k, kk


	!	aggregate capital, hours


    AK = sum(DASST*mu)
	AH = sum(DHR*mu)
    AE = sum(DEL*mu)
    AC = sum(DCON*mu)	
    AKE = AK/AE
    
   
      
	!	real interest rate, wage

	irateb = ((eps-1.0D0)/eps)*alpha*AKE**(alpha-1.0D0) - delta
	wageb  = ((eps-1.0D0)/eps)*(1.0D0-alpha)*AKE**alpha
    

	 !	output

    Prod = AK**alpha*AE**(1.0D0-alpha)
    profit = Prod- (irateb+delta)*AK - wageb*AE
   


    ! Diff 
    Diff1= wage - wageb
    
    
 
	!	employment rates

	Empl = sum(DEMP*mu)
    AvH = AH/Empl
    nshare = sum(NASSET*mu)
    
    ! Coefficient of Variance 
    
    
    cv_h = (sum((DHR-AH)**2.0D0*mu))**0.5D0/AH
    cv_hz = (sum((DHR-AvH)**2.0D0*DEMP*mu/sum(mu*DEMP)))**0.5D0/AvH 


	!	worker flows in and out of employment

	etoe = 0.0D0
    eton = 0.0D0
    ntoe = 0.0D0
    nton = 0.0D0
    	
	do ix = 1, nx
	do ia = 1, nda
       	
        do jx = 1, nx
			if (DHR(ia,ix) > 0.0d0 .and. DHR(DASI(ia,ix),jx) == 0.0D0) then
				eton = eton + mu(ia,ix)*trX(ix,jx)
			else if (DHR(ia,ix) > 0.0D0 .and. DHR(DASI(ia,ix),jx) > 0.0d0) then
				etoe = etoe + mu(ia,ix)*trX(ix,jx)                                       
            else if (DHR(ia,ix) == 0.0D0 .and. DHR(DASI(ia,ix),jx) > 0.0d0) then
				ntoe = ntoe + mu(ia,ix)*trX(ix,jx)      
            else if (DHR(ia,ix) == 0.0D0 .and. DHR(DASI(ia,ix),jx) == 0.0d0) then
				nton = nton + mu(ia,ix)*trX(ix,jx)      
			end if
		end do
 

	end do
	end do




	!	save results on file

	open(1, file='Output\Aggregates.txt', status='unknown')

	write(1, '(A/)') "Simulated Aggregate Variables:"
	write(1, '(A,F15.10)') "Aggregate Capital                     = ", AK     
	write(1, '(A,F15.10)') "Aggregate Hours Worked                = ", AH
    write(1, '(A,F15.10)') "Agg. Hours Worked for the employed    = ", AvH
    write(1, '(A,F15.10)') "CV for Hours                          = ", CV_H
    write(1, '(A,F15.10)') "CV for Hours for the employed         = ", CV_HZ
	write(1, '(A,F15.10)') "Aggregate Effeciency Units of Hours   = ", AE	
	write(1, '(A,F15.10)') "Aggregate Output                      = ", Prod-profit
    write(1, '(A,F15.10)') "Aggregate Consumption                 = ", AC
	write(1, '(/)') 
	write(1, '(A,F15.10)') "Real Interest Rate                    = ", irateb   
	write(1, '(A,F15.10)') "Wage Rate per Effeciency Unit         = ", wageb    
    write(1, '(/)')
    write(1, '(A,F15.10)') "Profit                                = ", profit
    write(1, '(/)')     
    write(1, '(A,F15.10)') "wage - wageb                          = ", Diff1            
	write(1, '(/)') 
	write(1, '(A,F15.10)') "Employment/Population                 = ", Empl
    write(1, '(/)') 
    write(1, '(A,F15.10)') "Share of negative wealth              = ", nshare    
    write(1, '(/)') 
    write(1, '(A,F15.10)') "E to E                                = ", EtoE
    write(1, '(A,F15.10)') "E to N                                = ", EtoN
    write(1, '(A,F15.10)') "N to E                                = ", NtoE
    write(1, '(A,F15.10)') "N to N                                = ", NtoN
	write(1, '(/)')     


	!	set the finishing time

	call date_and_time(finishdate, finishtime)
	

	!	print the starting and finishing times

	write(*, '(/)') 
	write(*, '(12A)') "The program started at  ", startdate(1:4),"-",startdate(5:6),"-",startdate(7:8)," ", starttime(1:2),":",starttime(3:4),":",starttime(5:6)
	write(*, '(12A)') "The program finished at ", finishdate(1:4),"-",finishdate(5:6),"-",finishdate(7:8)," ", finishtime(1:2),":",finishtime(3:4),":",finishtime(5:6)

	write(1, '(/)') 
	write(1, '(12A)') "The program started at  ", startdate(1:4),"-",startdate(5:6),"-",startdate(7:8)," ", starttime(1:2),":",starttime(3:4),":",starttime(5:6)
	write(1, '(12A)') "The program finished at ", finishdate(1:4),"-",finishdate(5:6),"-",finishdate(7:8)," ", finishtime(1:2),":",finishtime(3:4),":",finishtime(5:6)



end subroutine
