!	----------------------------------------------------------------------
!	File name: Globals.f90
!
!	Defines global variables.
!	----------------------------------------------------------------------


module Globals


	implicit none

	save


	!	grids for individual asset holdings

	real(8), parameter:: amin = -1.0D0, amax = 200.0D0, curv = 2.0D0
	integer, parameter:: na = 201, nx = 17

	
    !	number of asset grids

	integer, parameter:: nda = 1000, nu=nda*nx

	!	model parameters

	real(8), parameter:: alpha = 0.33D0, delta = 0.025D0, irate = 0.01D0, rd = irate + delta, hbar = 0.1140, eps = 10.0D0
	

	!	model parameters to be read

	real(8):: bta, B, gama, avex, rhox, sigex


	!	auxiliary variables
	
	real(8):: kss, sigx, hour, wage, fcost, work, lse_e, lse_t
	

	!	storages

	real(8):: agrid(na), dagrid(nda), xgrid(nx), prX(nx), exgrid(nx), &
              trX(nx,nx), CtrX(nx,nx),  phr(nda), chr(nda), amu(nda), camu(nda)
    
    real(8), dimension(na,nx)::  VF, VFE, VFS, VFN, &
                                 AS, ASE, ASS, ASN, &
                                 HR, HRE, HRS, HRN, &
                                    PF
                                     
	real(8), dimension(nda,nx):: DVFE, DVFN, DHR, DHRE, DASE, DASN, DEL, DVF, &
                                 DEMP, DCON, DINCOME,  NASSET, &
                                 DKINCOME, DEARNING, DASST,  &
                                 mu, cmu, DX, DAS 
	integer, dimension(nda,nx):: DASI
    
	
    
    !	variables for reservation wages and labor supply

	real(8):: ReservationWage(nda), ReservationX(nda), Reserv_cmu(nda,nda), LS_E(nda), LS_T(nda)
	
    
	!	index

	integer, parameter:: MAXITER = 100000
	integer:: ia, ja, ix, jx, iter


	!	timer

	character(8)::  startdate, finishdate
	character(10):: starttime, finishtime


end module
