!	----------------------------------------------------------------------
!	Module name: Inequality.f90
!
!	Calculates various Inequality statistics
!	----------------------------------------------------------------------
    module Inequality
    
    use Globals
    use distribution
    
    
    contains

    
    subroutine CaculatingInequality()

	implicit none


    real(8), dimension(1,5):: QI, QE, QEZ, QW, QW_I, QC_I, QEMP_W, QX_I, QH, QHZ, QE_W, QC
    real(8) :: gi, ge, gw, gh, gh_z, ge_zero, gc
    real(8) ::hr_pop(nu), hr_share(nu)



!! Income Distribution 


    call dist(DASST, mu, nda, nx, 5, QW, gw)  
    call dist(DCON, mu, nda, nx, 5, QC, gc)  
    call dist(DINCOME, mu, nda, nx, 5, QI, gi)  
    call dist(DHR, mu, nda, nx, 5, QH, gh)  
    call dist(DEARNING, mu, nda, nx, 5, QE, ge)           
    call dist_zero(DHR, mu, nda, nx, 5, QHZ, gh_z)      
    call dist2(DASST, DEARNING, mu, nda, nx, 5, QE_W)      
    call dist2(DASST, DEMP, mu, nda, nx, 5, QEMP_W)
    
    
    QEMP_W = sum(mu*DEMP)*QEMP_W/0.2        
    
    
    
    
!! save the data for the Lorenz Curves

    
     call model_dist(DHR, mu, nda, nx, hr_pop, hr_share)  
  
     open(1, file='Output\HR_pop.txt', status='unknown')
     open(2, file='Output\HR_share.txt', status='unknown')
     write(1, '(F8.4)') hr_pop
     write(2, '(F8.4)') hr_share
     close(1)
     close(2)
     
          
   
   !	save results on file

	open(1, file='Output\SSDIST.txt', status='unknown')

	write(1, '(A/)') "Income Distribution:"
    write(1, '(<10>F12.2)') QI, gi    
    write(1, '(/)') 
    write(1, '(A/)') "Earning Distribution:"
    write(1, '(<10>F12.2)') QE, ge    
    write(1, '(/)') 
    write(1, '(A/)') "Wealth Distribution:"
    write(1, '(<10>F12.2)') QW, gw
    write(1, '(/)') 
    write(1, '(A/)') "Consumption Distribution:"
    write(1, '(<10>F12.2)') QC, gc
    write(1, '(/)') 
    write(1, '(A/)') "Hours Distribution:"
    write(1, '(<10>F12.2)') QH, gh
    write(1, '(/)') 
    write(1, '(A/)') "Hours Distribution w/o zero:"
    write(1, '(<10>F12.2)') QHZ, gh_z    
    write(1, '(/)') 
    write(1, '(A/)') "Eearnings Distribution Ranked by Wealth"
    write(1, '(<10>F12.2)') QE_W    
    write(1, '(/)') 
    write(1, '(A/)') "Employment Distribution Ranked by Wealth"
    write(1, '(<10>F12.2)') QEMP_W      
    write(1, '(/)') 
    close(1)
    
       


end subroutine
    
    
end module