!	----------------------------------------------------------------------
!	Module name: InitializationModule.f90
!	----------------------------------------------------------------------


module InitializationModule

	use Globals
	use TauchenMod
    use ValueModule

	implicit none


contains


subroutine InitializeParameters()


	open(1, file='Input/Parameters.txt', status = 'old')
	read(1, *) bta
	read(1, *) B
	read(1, *) gama
	read(1, *) rhox
	read(1, *) sigex
    
   
	

    wage = ((eps-1.0D0)/eps)*(1.0D0-alpha)*(((eps-1.0D0)/eps)*alpha/rd)**(alpha/(1.0D0-alpha))
    print *, wage, rd
    pause
    sigx = sigex/dsqrt(1.0D0-rhox**2)
	avex = 0.0D0
   
    
     


end subroutine



subroutine InitializeAgrid()


	!	construct unequally spaced asset grids

	agrid(1) = amin
	do ia = 2, na
		agrid(ia) = agrid(1) + (amax-amin)*((ia-1.0D0)/(na-1.0D0))**curv
	end do


	! save grid

	open(1, file='Output/agrid.txt', status='unknown')
	write(1, '(f12.6)') agrid
	close(1)
	
	
end subroutine




subroutine InitializeXgrid()


	real(8) xmax, xmin, step 
	

	! xgrid

	xmax = avex + 3.0D0*sigx
	xmin = avex - 3.0D0*sigx
	step = (xmax - xmin)/(nx - 1)

	xgrid(1) = xmin
	do ix = 2, nx
		xgrid(ix) = xgrid(ix-1) + step
	end do

	exgrid = dexp(xgrid)  
   

	! save grids

	open(1, file='Output/xgrid.txt', status='unknown')
	write(1,'(<2>f12.6)') (xgrid(ix), exgrid(ix), ix=1,nx)
	close(1)   

end subroutine




subroutine InitializeTransition()


	real(8) prXp(nx), err


	! transition probability matrix

	call TauchenTr(avex, sigx, rhox, xgrid, trX)
	
	open(1, file='Output/trX.txt', status='unknown')
	write(1, '(<nx>f12.6)') ((trX(ix,jx),jx=1,nx),ix=1,nx)


	!	cumulative transition probability matrix for random drawing

	CtrX(:,1) = trX(:,1)
	do ix = 2, nx
		CtrX(:,ix) = CtrX(:,ix-1) + trX(:,ix)
	end do

	open(2, file='Output/CtrX.txt', status='unknown')
	write(2, '(<nx>f12.6)') ((CtrX(ix,jx),jx=1,nx),ix=1,nx)
    
    ! invariant distribution of shocks

	call TauchenNew(avex, sigx, xgrid, prX)

	do while (err < 1.0e-10)

		prXp = matmul(transpose(trX), prX)
		err = maxval(dabs(prXp-prX))
		prX = prXp
	
	end do


	if (dabs(1.0D0 - sum(prX)) <= 1.0e-6) then
		prX = prX/sum(prX)
	else
		print*, "Fatal Error in InvariantProbability"
		stop
	end if


	! save transition probability matrix and invariant probability

	open(3, file='Output/prX.txt', status='unknown')
	write(3, '(f20.16)') prX


	
end subroutine




subroutine InitializeValue()


	! initialize value function (a,x,s)



    VF=1.0D0
    mu(1,:) = prX

    !call ReadVF()


end subroutine


subroutine ReadVF()

    open(1, file='Output/VF.txt', status='old', action='read')
    read(1, '(<nx>D15.6)') ((VF(ia,ix),ix=1,nx),ia=1,na)    
    close(1)
    
    

    open(1, file='Output/mu0.txt', status='old', action='read')
    read(1, '(<nx>F12.9)') ((mu(ia,ix),ix=1,nx),ia=1,nda)
    close(1)
    



end subroutine


end module
