!	----------------------------------------------------------------------
!	File name : SteadyState.f90
!
!	main program for solving the worker's optimization problem
!	----------------------------------------------------------------------


program SteadyState


	use Globals
	use InitializationModule
	use ValueModule
	use MeasureModule
	use SaveResultsModule
    use Inequality
    





	implicit none


	!	set the starting time

	call date_and_time(startdate, starttime)


	!	initialize parameters and global variables

	call InitializeParameters()


	!	construct grids

	call InitializeAgrid()
	call InitializeXgrid()
	
	
	!	initialize transition probability matrix

	call InitializeTransition()


	!	initialize value function and decision rule for asset

	call InitializeValue()


	!	solve value function

	call SolveValueFunction()


	!	calculate invariant measure
	
	call InvariantMeasure()	


	!	save results
    

	call SaveEquilibrium()	
    call SaveEquilibrium2()	
    call SaveEquilibrium3()	
    call CaculatingInequality()
    
    
    
     
    !	calculate aggregate variables

	call AggregateVariables()

end program SteadyState
