!	----------------------------------------------------------------------
!	Module name: MeasureModule.f90
!
!	Finds the invariant measure given the individual decision rule and 
!	the transition process of idiosyncratic shocks.
!	----------------------------------------------------------------------


module MeasureModule


	use Globals
	use LinInterpModule
    use ValueModule


	implicit none


contains

	

subroutine InitializeDAgrid()


	!	construct unequally spaced asset grids

	dagrid(1) = amin
	do ia = 2, nda
		dagrid(ia) = dagrid(1) + (amax-amin)*((ia-1.0D0)/(nda-1.0D0))**curv
	end do


	! save grid

	open(1, file='Output/dagrid.txt', status='unknown')
	write(1, '(f12.6)') dagrid
	close(1)
	
	
end subroutine



subroutine DiscretizeAS()


	implicit none
    
    real(8), parameter:: diff = 0.07
    real(8):: half_a, half_b, half_first, half_last
	
	


	do ix = 1, nx

		call csint(na, agrid, PF(:,ix), cscoef)
		
        
	
		!	choose between working, self_employed and non-working

		
        
        do ia = 1, nda
            
            
             ! Working
                
                work = 1.0D0
                constraint = (1.0D0+irate)*dagrid(ia) 
                
				lbd = amin
				ubd = min(constraint + wage*gh(1.0D0)*exgrid(ix), amax)

				call fmin(NegValueF, lbd, ubd, xmin)                                          
                                
                DASE(ia,ix) = xmin
				DVFE(ia,ix) = ValueF(DASE(ia,ix))
                DHRE(ia,ix) = hour
                          
                                

				! Not-working
               
				work = 0.0D0                
                constraint = min((1.0D0+irate)*dagrid(ia), amax)
                
                lbd = amin
				ubd = constraint
                
                call fmin(NegValueF, lbd, ubd, xmin)  
                                
                DASN(ia,ix) = xmin
				DVFN(ia,ix) =  ValueF(DASN(ia,ix))
               
                
               

            
			if (DVFE(ia,ix) >= DVFN(ia,ix)) then                
                DEMP(ia,ix) = 1.0D0         
                DHR(ia,ix) = DHRE(ia,ix)
                DEL(ia,ix) = gh(DHR(ia,ix))*exgrid(ix) 
                DVF(ia,ix) = DVFE(ia,ix) 
                DAS(ia,ix) = DASE(ia,ix)		
                
 
            else
                
                DEMP(ia,ix) = 0.0D0         
                DHR(ia,ix) = 0.0D0
                DEL(ia,ix) = 0.0D0
                DVF(ia,ix) = DVFN(ia,ix) 
                DAS(ia,ix) = DASN(ia,ix)     
      

            end if	
            
                half_first = (dagrid(2)-dagrid(1))/2.0D0         
                half_last = (dagrid(nda)-dagrid(nda-1) )/2.0D0    

                if (DAS(ia,ix) < dagrid(1) + half_first) then
			        DASI(ia,ix) = 1
		        else if (DAS(ia,ix) >= dagrid(nda) - half_last) then
			        DASI(ia,ix) = nda
		        else
			        do ja = 2, nda-1
                
                        half_a = (dagrid(ja) - dagrid(ja-1) )/2.0D0    
                        half_b = (dagrid(ja+1) - dagrid(ja))/2.0D0                  
                
				        if (DAS(ia,ix) >= dagrid(ja) - half_a .and. DAS(ia,ix) < dagrid(ja) + half_b) then
					        DASI(ia,ix) = ja
					        exit
				        end if
			        end do
                end if
            
                DINCOME(ia,ix) = irate*dagrid(ia) + wage*gh(DHR(ia,ix))*exgrid(ix)           
                DCON(ia,ix) = DINCOME(ia,ix) + dagrid(ia)  - DAS(ia,ix)          
                DKINCOME(ia,ix) = irate*dagrid(ia)
                DEARNING(ia,ix) = wage*gh(DHR(ia,ix))*exgrid(ix)
                DASST(ia,ix) = dagrid(ia)
                
             if (DASST(ia,ix) < 0.0D0) then
                   NASSET(ia,ix) = 1.0D0
               end if

		end do

    end do
	

end subroutine


subroutine InvariantMeasure()


	real(8), parameter:: tol_measure = 1.0D-10
	real(8):: Newmu(nda,nx), Fmu(nda,nx), err



	!	initialize finer asset grids

	call InitializeDAgrid()


	!	discretize asset accumulation rule

	call DiscretizeAS()


	!	start iteration

	do iter = 1, maxiter


		!	calculate measure before shocks change

		Fmu = 0.0D0

        do ix = 1, nx
		do ia = 1, nda

			Fmu(DASI(ia,ix),ix) = Fmu(DASI(ia,ix),ix) + mu(ia,ix)

		end do
		end do

		
		!	next period measures

		Newmu = 0.0D0
		
	    do ix = 1, nx
	    do ia = 1, nda

		do jx = 1, nx

			Newmu(ia,ix) = Newmu(ia,ix) + Fmu(ia,jx)*trX(jx,ix)
		
		end do
	
	    end do
	    end do
        
		Newmu = Newmu/sum(Newmu)

		!	calculate the differences between old and new measures

		err = maxval(dabs(Newmu-mu))


		!	update measures 

		mu = Newmu


		!	convergence test of the measures

		if (err < tol_measure) then
			print*, "Convergence achieved at InvariantMeasure iteration", iter
			print*, "err = ", err
			print*, ""
			exit
		else if (mod(iter, 100) == 0) then
			print*, "InvariantMeasure iteration", iter
			print*, "err = ", err
			print*, ""
		end if

    end do
    
	!	shouldn't reach here

	if (iter > maxiter) then
		print*, "Convergence failed in InvariantMeasure...."
		stop
    end if
    
    !	cumulative measure

   
    cmu = 0.0D0
      
        
	
	do ix = 1, nx
	
		cmu(1,ix) = mu(1,ix)
        
	
		do ia = 2, nda
			cmu(ia,ix) = cmu(ia-1,ix) + mu(ia,ix)
           
		end do

		if (ix >= 2) then
			cmu(:,ix) = cmu(:,ix-1) + cmu(:,ix)
           
		end if

    end do
    
    


end subroutine




end module
