!	----------------------------------------------------------------------
!	File name: ReservationWageModule.f90
!
!	This routine solves for reservation wage for each asset level at 
!	which an individual with the asset is indifferent between working 
!	and nonworking.
!	----------------------------------------------------------------------


module ReservationWageModule


	use Globals
	use OptimizationMod
    use sorting2
    

	implicit none

	real(8) cscoefE(4,nx), cscoefN(4,nx)
    real(8), external:: csval


	contains


	subroutine FindReservationWages()

		ReservationX = 0.0d0

		do ia = 1,nda
            
                       

			!	check if VFE and VFN intersect

			if (DEMP(ia,nx) == 0.0d0) then
				ReservationX(ia) = xgrid(nx)

			elseif (DEMP(ia,1) > 0.0d0) then
				ReservationX(ia) = xgrid(1)
	
			else

				!	spline value functions VFE(ka,kx,:) and VFN(ka,kx,:)

				call csint(nx, xgrid, DVFE(ia,:), cscoefE)
                call csint(nx, xgrid, DVFN(ia,:), cscoefN)                

				!	solve for x^* such that VFE(ia,x*) = VFN(ia,x*)

				call fmin(DiffValue, xgrid(1), xgrid(nx), ReservationX(ia))
               
			end if

        end do
    

		ReservationWage = dexp(ReservationX)*wage
        
     


	end subroutine



	real(8) function DiffValue(x)

		implicit none

		real(8), intent(in):: x


		DiffValue = (csval(nx, x, xgrid, cscoefE) - csval(nx, x, xgrid, cscoefN))**2.0D0
        

	end function


subroutine LaborSupply()

        implicit none

		real(8) :: RW(nda)
        
        
         RW=ReservationWage
         
         
         phr = sum(mu*DHR,2)
         amu = sum(mu,2)
         
         

		call dsorting2(nda,ReservationWage,phr)
        call dsorting2(nda,RW,amu)
        
        
        camu(1) = amu(1)
        chr(1) = phr(1)
        
        do ia = 2, nda
        camu(ia) = camu(ia-1) + amu(ia)
        chr(ia) = chr(ia-1) + phr(ia)
        end do

		
        LS_E = camu
        LS_T = chr
        
        
             
         ja = min(max(MAXLOC(LS_E,dim=1, MASK = LS_E .LT. sum(DEMP*mu)), 2),nda-1)                 
                  
         lse_e = dlog(LS_E(ja-5)/LS_E(ja+5))/dlog(ReservationWage(ja-5)/ReservationWage(ja+5))
         
         ja = min(max(MAXLOC(LS_T,dim=1, MASK = LS_T .LT. sum(DHR*mu)), 2),nda-1)             
         lse_t = dlog(LS_T(ja-5)/LS_T(ja+5))/dlog(ReservationWage(ja-5)/ReservationWage(ja+5))
        
                      
      

	end subroutine


end module
