!	----------------------------------------------------------------------
!	Module name: SaveResultsModule.f90
!
!	Save all results
!	----------------------------------------------------------------------


module SaveResultsModule

	use Globals
  

	implicit none


contains


subroutine SaveEquilibrium()

	implicit none

  
	!	save value function and decision rules

	open(1, file='Output/VF.txt', status='unknown')
	open(2, file='Output/VFE.txt', status='unknown')
	open(3, file='Output/VFN.txt', status='unknown')
    
	open(4, file='Output/AS.txt', status='unknown')
	open(5, file='Output/ASE.txt', status='unknown')
	open(6, file='Output/ASN.txt', status='unknown')
    
    open(7, file='Output/HR.txt', status='unknown')
	open(8, file='Output/HRE.txt', status='unknown')
    open(9, file='Output/HRN.txt', status='unknown')
    

	write(1, '(<nx>D15.6)') ((VF(ia,ix),ix=1,nx),ia=1,na)
    write(2, '(<nx>D15.6)') ((VFE(ia,ix),ix=1,nx),ia=1,na)
    write(3, '(<nx>D15.6)') ((VFN(ia,ix),ix=1,nx),ia=1,na)
    
    write(4, '(<nx>F15.6)') ((AS(ia,ix),ix=1,nx),ia=1,na)
    write(5, '(<nx>F15.6)') ((ASE(ia,ix),ix=1,nx),ia=1,na)
    write(6, '(<nx>F15.6)') ((ASN(ia,ix),ix=1,nx),ia=1,na)
    
    write(7, '(<nx>F15.6)') ((HR(ia,ix),ix=1,nx),ia=1,na)
    write(8, '(<nx>F15.6)') ((HRE(ia,ix),ix=1,nx),ia=1,na)
    write(9, '(<nx>F15.6)') ((HRN(ia,ix),ix=1,nx),ia=1,na)


   close(1)
   close(2)
   close(3)
   close(4)
   close(5)
   close(6)
   close(7)
   close(8)
   close(9)
   

end subroutine



subroutine SaveEquilibrium2()

	implicit none

  
		    
    open(1, file='Output/DINCOME.txt', status='unknown')
    open(2, file='Output/DEARNING.txt', status='unknown')
    open(3, file='Output/DEMP.txt', status='unknown')       
    open(4, file='Output/DKINCOME.txt', status='unknown')
    open(5, file='Output/DASST.txt', status='unknown')

    

    write(1, '(<nx>F15.6)') ((DINCOME(ia,ix),ix=1,nx),ia=1,nda)
    write(2, '(<nx>F15.6)') ((DEARNING(ia,ix),ix=1,nx),ia=1,nda)
    write(3, '(<nx>F15.6)') ((DEMP(ia,ix),ix=1,nx),ia=1,nda)
    write(4, '(<nx>F15.6)') ((DKINCOME(ia,ix),ix=1,nx),ia=1,nda)
    write(5, '(<nx>F15.6)') ((DASST(ia,ix),ix=1,nx),ia=1,nda)

   
    

	open(6, file='Output/mu.txt', status='unknown')
	write(6, '(<nx>F12.8)') ((mu(ia,ix),ix=1,nx),ia=1,nda)





	close(1)
    close(2)
    close(3)
    close(4)
    close(5)
    close(6)



end subroutine



subroutine SaveEquilibrium3()

	implicit none

   

	open(1, file='Output/VFE0.txt', status='unknown')
	open(2, file='Output/VFN0.txt', status='unknown')    
	open(3, file='Output/ASE0.txt', status='unknown')
	open(4, file='Output/ASN0.txt', status='unknown')            
    open(5, file='Output/VF0.txt', status='unknown')            
    open(6, file='Output/mu0.txt', status='unknown')     
    
    write(1, '(<nx>D15.6)') ((VFE(ia,ix),ix=1,nx),ia=1,na)
    write(2, '(<nx>D15.6)') ((VFN(ia,ix),ix=1,nx),ia=1,na)
    write(3, '(<nx>D15.6)') ((ASE(ia,ix),ix=1,nx),ia=1,na)    
    write(4, '(<nx>F15.6)') ((ASN(ia,ix),ix=1,nx),ia=1,na)    
    write(5, '(<nx>F15.6)') ((DVF(ia,ix),ix=1,nx),ia=1,nda)    
	write(6, '(<nx>F15.10)') ((mu(ia,ix),ix=1,nx),ia=1,nda)
    
    close(1)
    close(2)
    close(3)
    close(4)
    close(5)
    close(6)



end subroutine



end module
