!	----------------------------------------------------------------------
!	Module name : ValueModule.f90
!	----------------------------------------------------------------------	*/


module ValueModule

	use Globals
	use LinInterpModule
	use OptimizationMod

	implicit none

	real(8), parameter:: tol_cnvrg = 1.0D-4, huge = 1.0D20
	real(8), dimension(na,nx):: NewVF, NewVFE, NewVFN, NewAS, NewASE, NewASN
    real(8) :: err, errV, errA, lbd, ubd, xmin, cscoef(na,4), constraint, inc, ap_hour
	real(8), external:: csval


contains


subroutine SolveValueFunction()


	! start iteration

	do iter = 1, MAXITER


		! evaluate expected value function
	
        PF = matmul(VF, transpose(trX))

		!	maximization procedure
        
		do ix = 1, nx

			call csint(na, agrid, PF(:,ix), cscoef)

     
                             
            do ia = 1, na
                
                ! Working
                 
                work = 1.0D0
                constraint = (1.0D0+irate)*agrid(ia)
                
				lbd = amin
				ubd = constraint + wage*gh(1.0D0)*exgrid(ix)

				call fmin(NegValueF, lbd, ubd, xmin)                                          
                                
                NewASE(ia,ix) = xmin
				NewVFE(ia,ix) = ValueF(NewASE(ia,ix))
                HRE(ia,ix) = hour
                
               
                
                                

				! Not-working
               
				work = 0.0D0
                constraint = (1.0D0+irate)*agrid(ia)          
                
    

				lbd = amin
				ubd = constraint

				call fmin(NegValueF, lbd, ubd, xmin)    
         
                NewASN(ia,ix) = xmin                
				NewVFN(ia,ix) = ValueF(NewASN(ia,ix))
                HRN(ia,ix) = 0.0D0                                        

				!	Compare values 
  
				if (NewVFE(ia,ix) >= NewVFN(ia,ix)) then
					HR(ia,ix) = HRE(ia,ix)
					NewAS(ia,ix) = NewASE(ia,ix)
					NewVF(ia,ix) = NewVFE(ia,ix)
                                    
                else
					HR(ia,ix) = HRN(ia,ix)
					NewAS(ia,ix) = NewASN(ia,ix)
					NewVF(ia,ix) = NewVFN(ia,ix)
                   
				end if

            end do

		end do


		!	calculate errors

		errV = maxval(dabs(NewVF - VF))
		errA = maxval(dabs(NewAS - AS))
        err = max(errV,errA)


		! update value function and decision rules

		VFE = NewVFE
		VFN = NewVFN
		VF  = NewVF
		
        ASE = NewASE
		ASN = NewASN    
		AS  = NewAS
        
        
  

		! convergence check

		if (err < tol_cnvrg) then
			write(*, '(A,I5,/)') "Individual Optimization is done at iteration ", iter
			exit 
		else if (mod(iter,50) == 0) then
			write(*, '(A,I5)') "SolveValueFunction iteration ", iter
			write(*, '(2(A,F12.5),/)') "errV = ", errV, "   errA = ", errA
		end if

	end do


end subroutine



real(8) function SolveHour(xhour)

	implicit none

	real(8), parameter:: tiny = 1.0D-20
	real(8) cons, xhour

	
    cons = constraint + wage*gh(xhour)*exgrid(ix) - ap_hour
    
    if (cons <= 0.0D0) then
        SolveHour=  -huge 
    else
	    SolveHour =  dlog(cons) - B*xhour**(1.0D0+1.0D0/gama)/(1.0D0+1.0D0/gama)
    end if

end function



real(8) function ValueFh(xhour)

	implicit none

	real(8) xhour

	ValueFh = SolveHour(xhour) + bta*csval(na, ap_hour, agrid, cscoef)

end function




real(8) function NegValueFh(xhour)

	implicit none

	real(8) xhour

	NegValueFh = -ValueFh(xhour)

end function


real(8) function Utility(ap)

	implicit none

	real(8), parameter:: tiny = 1.0D-20, tol_hour = 1.0D-5
	real(8) ap, xhour_min, cm
	
	if (work == 1.0D0) then
	ap_hour = ap

	call fmin(NegValueFh, 1.0D-2, 1.0D0, xhour_min)   

    hour = xhour_min
    cm = constraint + wage*gh(hour)*exgrid(ix)  - ap
    
    else
        
    hour = 0.0D0
    cm = constraint  - ap
    
    end if
    

    if (cm <= 0.0D0) then 
        Utility = -huge
    else
	    Utility = dlog(cm) - B*hour**(1.0D0+1.0D0/gama)/(1.0D0+1.0D0/gama)
    end if



end function



real(8) function ValueF(ap)

	implicit none

	real(8) ap

	ValueF = Utility(ap) + bta*csval(na, ap, agrid, cscoef)

end function


real(8) function NegValueF(ap)

	implicit none

	real(8) ap

	NegValueF = -ValueF(ap)

end function




real(8) function gh(h)

	implicit none

	real(8) h

	gh = max(h-hbar, 0.0D0)

end function





        
end module