
module lorenz


	use Globals
   

		implicit none

contains

subroutine lorenz_income()


real(8):: QI1, QI2, QI3, QI4, QI5

integer:: rowi1, rowi2, rowi3, rowi4

real(8):: lamdai1, lamdai2, lamdai3, lamdai4

real(8):: agg_income(nx), incomes(nx), ishare(nx), icshare(nx), popcshare(nx), pop(nx)

real(8), dimension(dna,nx) :: Income_mat, mu, dcs

real(8) isum

real(8), dimension(1,5):: QI


open(18, file='Output/DINCOME.txt', status='old', action='read')
open(21, file='Output/mu.txt', status='old', action='read')
read(18,*)((DINCOME(ia,ix),ix=1,nx),ia=1,dna)
read(21,*) ((mu(ia,ix),ix=1,nx),ia=1,dna)


pop=sum(mu,dim=1)*0.01

income_mat=DINCOME*mu



agg_income =sum(income_mat,dim=1)

isum=sum(agg_income)

incomes=agg_income/pop;


ishare=agg_income/isum


icshare(1) = ishare(1)
popcshare(1)=pop(1)

        do ix = 2, nx
          icshare(ix) = icshare(ix-1)+ishare(ix)
          popcshare(ix)=popcshare(ix-1)+pop(ix)
        end do

rowi1=MAXLOC(popcshare,dim=1, MASK = popcshare .LT. 0.2)
lamdai1=0.2-popcshare(rowi1)
qi1=(sum(agg_income(1:rowi1))+incomes(rowi1+1)*lamdai1)*100.0D0/isum

rowi2 = MAXLOC(popcshare,dim=1, MASK = popcshare .LT. 0.4)
lamdai2=0.4-popcshare(rowi2);
qi2=(incomes(rowi1+1)*(pop(rowi1+1)-lamdai1)+sum(agg_income(rowi1+2:rowi2))+incomes(rowi2+1)*lamdai2)*100.0D0/isum

rowi3 = MAXLOC(popcshare,dim=1, MASK = popcshare .LT. 0.6)
lamdai3=0.6-popcshare(rowi3);
qi3=(incomes(rowi2+1)*(pop(rowi2+1)-lamdai2)+sum(agg_income(rowi2+2:rowi3))+incomes(rowi3+1)*lamdai3)*100.0D0/isum

rowi4 = MAXLOC(popcshare,dim=1, MASK = popcshare .LT. 0.8)
lamdai4=0.8-popcshare(rowi4);
qi4=(incomes(rowi3+1)*(pop(rowi3+1)-lamdai3)+sum(agg_income(rowi3+2:rowi4))+incomes(rowi4+1)*lamdai4)*100.0D0/isum


qi5=(incomes(rowi4+1)*(pop(rowi4+1)-lamdai4)+sum(agg_income(rowi4+2:size(incomes,1))))*100.0D0/isum;

qi(1,1)=qi1
qi(1,2)=qi2
qi(1,3)=qi3
qi(1,4)=qi4
qi(1,5)=qi5


    open(23, file='Output/QI.txt', status='unknown')
	write(23, '(<nx>F12.2)') (QI(1,ix),ix=1,5)

    close(21)

end subroutine lorenz_income

subroutine lorenz_wealth()

real(8):: QW1, QW2, QW3, QW4, QW5, QE1, QE2, QE3, QE4, QE5

integer:: roww1, roww2, roww3, roww4

!real(8):: lamdaw1, lamdaw2, lamdaw3, lamdaw4

real(8):: agg_wealth(dna), wealth(dna), wshare(dna), wcshare(dna), wpopcshare(dna), wpop(dna)

real(8) wsum

real(8), dimension(1,5):: QW, QE


real(8):: agg_earning(nx)

real(8), dimension(dna,nx) :: earning_mat

real(8) esum


open(4, file='Output/AsstDensity.txt', status='old', action='read') 
read(4,*) AsstDensity



agg_wealth=AsstDensity*dagrid

wsum=sum(agg_wealth)
    do ia=1,dna
    wealth(ia)=dagrid(ia)
    wpop(ia)=AsstDensity(ia)
    wshare(ia)=agg_wealth(ia)/wsum
    end do


wcshare(1) = wshare(1)
wpopcshare(1)=wpop(1)

        do ia = 2, dna
          wcshare(ia) = wcshare(ia-1)+wshare(ia)
          wpopcshare(ia)=wpopcshare(ia-1)+wpop(ia)
        end do


roww1=MAXLOC(wpopcshare,dim=1, MASK = wpopcshare .LT. 0.2)
qw1=wcshare(roww1+1)*100.0D0

roww2 = MAXLOC(wpopcshare,dim=1, MASK = wpopcshare .LT. 0.4)
qw2=(wcshare(roww2+1)-wcshare(roww1+1))*100.0D0

roww3 = MAXLOC(wpopcshare,dim=1, MASK = wpopcshare .LT. 0.6)
qw3=(wcshare(roww3+1)-wcshare(roww2+1))*100.0D0

roww4 = MAXLOC(wpopcshare,dim=1, MASK = wpopcshare .LT. 0.8)
qw4=(wcshare(roww4+1)-wcshare(roww3+1))*100.0D0

qw5=(1.0-wcshare(roww4+1))*100.0D0

qw(1,1)=qw1
qw(1,2)=qw2
qw(1,3)=qw3
qw(1,4)=qw4
qw(1,5)=qw5


open(20, file='Output/DEARNING.txt', status='old', action='read')
open(21, file='Output/mu.txt', status='old', action='read')
read(20,*)((DEARNING(ia,ix),ix=1,nx),ia=1,dna)
read(21,*) ((mu(ia,ix),ix=1,nx),ia=1,dna)


earning_mat=DEARNING*mu*0.01

agg_earning =sum(earning_mat,dim=1)
esum=sum(agg_earning)

QE1=sum(sum(earning_mat(1:roww1,1:nx),dim=1))*100.0D0/esum
QE2=sum(sum(earning_mat(roww1+1:roww2,1:nx),dim=1))*100.0D0/esum
QE3=sum(sum(earning_mat(roww2+1:roww3,1:nx),dim=1))*100.0D0/esum
QE4=sum(sum(earning_mat(roww3+1:roww4,1:nx),dim=1))*100.0D0/esum
QE5=sum(sum(earning_mat(roww4+1:dna,1:nx),dim=1))*100.0D0/esum


qe(1,1)=qe1
qe(1,2)=qe2
qe(1,3)=qe3
qe(1,4)=qe4
qe(1,5)=qe5
   
    open(24, file='Output/QW.txt', status='unknown')
	write(24, '(<nx>F12.2)') (QW(1,ix),ix=1,5)

    open(25, file='Output/QE.txt', status='unknown')
	write(25, '(<nx>F12.2)') (QE(1,ix),ix=1,5)


end subroutine lorenz_wealth

end module 
