module LeastSquareModule

implicit none

contains

	SUBROUTINE lsfit(xdata,y,a,covar,tstat,r_sq,adjr_sq,chisq)
	USE nrtype; USE nrutil, ONLY : assert_eq,diagmult,nrerror
	IMPLICIT NONE
!	INTEGER(I4B),DIMENSION(:), INTENT(IN) :: x
	REAL(DP), DIMENSION(:), INTENT(IN) :: y
	REAL(DP), DIMENSION(:), INTENT(INOUT) :: a,tstat
	REAL(DP), DIMENSION(:,:), INTENT(INOUT) :: covar
	REAL(DP), INTENT(OUT) :: chisq,r_sq,adjr_sq
	REAL(DP), DIMENSION(:,:), INTENT(IN) :: xdata

	INTEGER(I4B) :: i,j,k,l,ma,mfit,n
	REAL(DP) :: sig2i,wt,ym
	LOGICAL(LGT), DIMENSION(size(a)) :: maska
	REAL(DP), DIMENSION(size(a),1) :: beta
	REAL(DP), DIMENSION(size(y)) :: sig

	sig = 1.0_dp
	maska = .true.
	n=assert_eq(size(y),size(xdata,1),'lsfit: n')
	ma=assert_eq(size(a),size(xdata,2),size(covar,1),size(covar,2),'lsfit: ma')
	mfit=count(maska)
	if (mfit == 0) call nrerror('lsfit: no parameters to be fitted')
	covar(1:mfit,1:mfit)=0.0_dp
	beta(1:mfit,1)=0.0_dp
	do i=1,n
		ym=y(i)
		if (mfit < ma) ym=ym-sum(a(1:ma)*xdata(i,1:ma), mask=.not. maska)
		sig2i=1.0_dp/sig(i)**2
		j=0
		do l=1,ma
			if (maska(l)) then
				j=j+1
				wt=xdata(i,l)*sig2i
				k=count(maska(1:l))
				covar(j,1:k)=covar(j,1:k)+wt*pack(xdata(i,1:l),maska(1:l))
				beta(j,1)=beta(j,1)+ym*wt
			end if
		end do
	end do
	call diagmult(covar(1:mfit,1:mfit),0.5_dp)
	covar(1:mfit,1:mfit)= &
		covar(1:mfit,1:mfit)+transpose(covar(1:mfit,1:mfit))
	call gaussj(covar(1:mfit,1:mfit),beta(1:mfit,1:1))
	a(1:ma)=unpack(beta(1:ma,1),maska,a(1:ma))
	chisq=0.0_dp
	do i=1,n
		chisq=chisq+((y(i)-dot_product(a(1:ma),xdata(i,1:ma)))/sig(i))**2
	end do
	call covsrt(covar,maska)
	covar=chisq/(n-ma+1)*covar
	do i=1,ma
		tstat(i)=a(i)/sqrt(covar(i,i))
	end do
	r_sq = 1.0_dp - chisq/dot_product(y-sum(y)/n,y-sum(y)/n)
	adjr_sq = 1.0_dp - (n-1)/(n-ma+1)*(1.0_dp-r_sq)
	END SUBROUTINE lsfit


	SUBROUTINE covsrt(covar,maska)
	USE nrtype; USE nrutil, ONLY : assert_eq,swap
	IMPLICIT NONE
	REAL(DP), DIMENSION(:,:), INTENT(INOUT) :: covar
	LOGICAL(LGT), DIMENSION(:), INTENT(IN) :: maska
	INTEGER(I4B) :: ma,mfit,j,k
	ma=assert_eq(size(covar,1),size(covar,2),size(maska),'covsrt')
	mfit=count(maska)
	covar(mfit+1:ma,1:ma)=0.0_dp
	covar(1:ma,mfit+1:ma)=0.0_dp
	k=mfit
	do j=ma,1,-1
		if (maska(j)) then
			call swap(covar(1:ma,k),covar(1:ma,j))
			call swap(covar(k,1:ma),covar(j,1:ma))
			k=k-1
		end if
	end do
	END SUBROUTINE covsrt


	SUBROUTINE gaussj(a,b)
	USE nrtype; USE nrutil, ONLY : assert_eq,nrerror,outerand,outerprod,swap
	IMPLICIT NONE
	REAL(DP), DIMENSION(:,:), INTENT(INOUT) :: a,b
	INTEGER(I4B), DIMENSION(size(a,1)) :: ipiv,indxr,indxc
	LOGICAL(LGT), DIMENSION(size(a,1)) :: lpiv
	REAL(DP) :: pivinv
	REAL(DP), DIMENSION(size(a,1)) :: dumc
	INTEGER(I4B), TARGET :: irc(2)
	INTEGER(I4B) :: i,l,n
	INTEGER(I4B), POINTER :: irow,icol
	n=assert_eq(size(a,1),size(a,2),size(b,1),'gaussj')
	irow => irc(1)
	icol => irc(2)
	ipiv=0
	do i=1,n
		lpiv = (ipiv == 0)
		irc=maxloc(abs(a),outerand(lpiv,lpiv))
		ipiv(icol)=ipiv(icol)+1
		if (ipiv(icol) > 1) call nrerror('gaussj: singular matrix (1)')
		if (irow /= icol) then
			call swap(a(irow,:),a(icol,:))
			call swap(b(irow,:),b(icol,:))
		end if
		indxr(i)=irow
		indxc(i)=icol
		if (a(icol,icol) == 0.0_dp) &
			call nrerror('gaussj: singular matrix (2)')
		pivinv=1.0_dp/a(icol,icol)
		a(icol,icol)=1.0_dp
		a(icol,:)=a(icol,:)*pivinv
		b(icol,:)=b(icol,:)*pivinv
		dumc=a(:,icol)
		a(:,icol)=0.0_dp
		a(icol,icol)=pivinv
		a(1:icol-1,:)=a(1:icol-1,:)-outerprod(dumc(1:icol-1),a(icol,:))
		b(1:icol-1,:)=b(1:icol-1,:)-outerprod(dumc(1:icol-1),b(icol,:))
		a(icol+1:,:)=a(icol+1:,:)-outerprod(dumc(icol+1:),a(icol,:))
		b(icol+1:,:)=b(icol+1:,:)-outerprod(dumc(icol+1:),b(icol,:))
	end do
	do l=n,1,-1
		call swap(a(:,indxr(l)),a(:,indxc(l)))
	end do
	END SUBROUTINE gaussj


	SUBROUTINE lsfit_svd(xdata,y,a,v,w,covar,tstat,r_sq,adjr_sq,chisq)
	USE nrtype; USE nrutil, ONLY : assert_eq,vabs
	IMPLICIT NONE
	REAL(DP), DIMENSION(:), INTENT(IN) :: y
	REAL(DP), DIMENSION(:), INTENT(OUT) :: a,w,tstat
	REAL(DP), DIMENSION(:,:), INTENT(OUT) :: v
	REAL(DP), INTENT(OUT) :: chisq,r_sq,adjr_sq
	REAL(DP), DIMENSION(:,:), INTENT(INOUT) :: covar
	REAL(DP), DIMENSION(:,:), INTENT(IN) :: xdata

	REAL(DP), PARAMETER :: TOL=1.0e-5_dp
	INTEGER(I4B) :: i,ma,n
	REAL(DP), DIMENSION(size(y)) :: b,sigi
	REAL(DP), DIMENSION(size(y),size(a)) :: u,usav
	REAL(DP), DIMENSION(size(y)) :: sig

	sig = 1.0_dp
	n=assert_eq(size(y),size(xdata,1),'lsfit_svd: n')
	ma=assert_eq(size(a),size(xdata,2),size(v,1),size(v,2),size(w),'lsfit_svd: ma')
	sigi=1.0_dp/sig
	b=y*sigi
	do i=1,n
		usav(i,:)=xdata(i,1:ma)
	end do
	u=usav*spread(sigi,dim=2,ncopies=ma)
	usav=u
	call svdcmp(u,w,v)
	where (w < TOL*maxval(w)) w=0.0_dp
	call svbksb(u,w,v,b,a)
	chisq=vabs(matmul(usav,a)-b)**2
	call svdvar(v,w,covar)
	covar=chisq/(n-ma+1)*covar
	do i=1,ma
		tstat(i)=a(i)/sqrt(covar(i,i))
	end do
	r_sq = 1.0_dp - chisq/dot_product(y-sum(y)/n,y-sum(y)/n)
	adjr_sq = 1.0_dp - (n-1)/(n-ma+1)*(1.0_dp-r_sq)
	END SUBROUTINE lsfit_svd



	SUBROUTINE svdvar(v,w,cvm)
	USE nrtype; USE nrutil, ONLY : assert_eq
	IMPLICIT NONE
	REAL(DP), DIMENSION(:,:), INTENT(IN) :: v
	REAL(DP), DIMENSION(:), INTENT(IN) :: w
	REAL(DP), DIMENSION(:,:), INTENT(OUT) :: cvm
	INTEGER(I4B) :: ma
	REAL(DP), DIMENSION(size(w)) :: wti
	ma=assert_eq((/size(v,1),size(v,2),size(w),size(cvm,1),size(cvm,2)/),&
		'svdvar')
	where (w /= 0.0_dp)
		wti=1.0_dp/(w*w)
	elsewhere
		wti=0.0_dp
	end where
	cvm=v*spread(wti,dim=1,ncopies=ma)
	cvm=matmul(cvm,transpose(v))
	END SUBROUTINE svdvar



	SUBROUTINE svdcmp(a,w,v)
	USE nrtype; USE nrutil, ONLY : assert_eq,nrerror,outerprod
	IMPLICIT NONE
	REAL(DP), DIMENSION(:,:), INTENT(INOUT) :: a
	REAL(DP), DIMENSION(:), INTENT(OUT) :: w
	REAL(DP), DIMENSION(:,:), INTENT(OUT) :: v
	INTEGER(I4B) :: i,its,j,k,l,m,n,nm
	REAL(DP) :: anorm,c,f,g,h,s,scale,x,y,z
	REAL(DP), DIMENSION(size(a,1)) :: tempm
	REAL(DP), DIMENSION(size(a,2)) :: rv1,tempn
	m=size(a,1)
	n=assert_eq(size(a,2),size(v,1),size(v,2),size(w),'svdcmp_dp')
	g=0.0_dp
	scale=0.0_dp
	do i=1,n
		l=i+1
		rv1(i)=scale*g
		g=0.0_dp
		scale=0.0_dp
		if (i <= m) then
			scale=sum(abs(a(i:m,i)))
			if (scale /= 0.0_dp) then
				a(i:m,i)=a(i:m,i)/scale
				s=dot_product(a(i:m,i),a(i:m,i))
				f=a(i,i)
				g=-sign(sqrt(s),f)
				h=f*g-s
				a(i,i)=f-g
				tempn(l:n)=matmul(a(i:m,i),a(i:m,l:n))/h
				a(i:m,l:n)=a(i:m,l:n)+outerprod(a(i:m,i),tempn(l:n))
				a(i:m,i)=scale*a(i:m,i)
			end if
		end if
		w(i)=scale*g
		g=0.0_dp
		scale=0.0_dp
		if ((i <= m) .and. (i /= n)) then
			scale=sum(abs(a(i,l:n)))
			if (scale /= 0.0_dp) then
				a(i,l:n)=a(i,l:n)/scale
				s=dot_product(a(i,l:n),a(i,l:n))
				f=a(i,l)
				g=-sign(sqrt(s),f)
				h=f*g-s
				a(i,l)=f-g
				rv1(l:n)=a(i,l:n)/h
				tempm(l:m)=matmul(a(l:m,l:n),a(i,l:n))
				a(l:m,l:n)=a(l:m,l:n)+outerprod(tempm(l:m),rv1(l:n))
				a(i,l:n)=scale*a(i,l:n)
			end if
		end if
	end do
	anorm=maxval(abs(w)+abs(rv1))
	do i=n,1,-1
		if (i < n) then
			if (g /= 0.0_dp) then
				v(l:n,i)=(a(i,l:n)/a(i,l))/g
				tempn(l:n)=matmul(a(i,l:n),v(l:n,l:n))
				v(l:n,l:n)=v(l:n,l:n)+outerprod(v(l:n,i),tempn(l:n))
			end if
			v(i,l:n)=0.0_dp
			v(l:n,i)=0.0_dp
		end if
		v(i,i)=1.0_dp
		g=rv1(i)
		l=i
	end do
	do i=min(m,n),1,-1
		l=i+1
		g=w(i)
		a(i,l:n)=0.0_dp
		if (g /= 0.0_dp) then
			g=1.0_dp/g
			tempn(l:n)=(matmul(a(l:m,i),a(l:m,l:n))/a(i,i))*g
			a(i:m,l:n)=a(i:m,l:n)+outerprod(a(i:m,i),tempn(l:n))
			a(i:m,i)=a(i:m,i)*g
		else
			a(i:m,i)=0.0_dp
		end if
		a(i,i)=a(i,i)+1.0_dp
	end do
	do k=n,1,-1
		do its=1,30
			do l=k,1,-1
				nm=l-1
				if ((abs(rv1(l))+anorm) == anorm) exit
				if ((abs(w(nm))+anorm) == anorm) then
					c=0.0_dp
					s=1.0_dp
					do i=l,k
						f=s*rv1(i)
						rv1(i)=c*rv1(i)
						if ((abs(f)+anorm) == anorm) exit
						g=w(i)
						h=pythag(f,g)
						w(i)=h
						h=1.0_dp/h
						c= (g*h)
						s=-(f*h)
						tempm(1:m)=a(1:m,nm)
						a(1:m,nm)=a(1:m,nm)*c+a(1:m,i)*s
						a(1:m,i)=-tempm(1:m)*s+a(1:m,i)*c
					end do
					exit
				end if
			end do
			z=w(k)
			if (l == k) then
				if (z < 0.0_dp) then
					w(k)=-z
					v(1:n,k)=-v(1:n,k)
				end if
				exit
			end if
			if (its == 30) call nrerror('svdcmp_dp: no convergence in svdcmp')
			x=w(l)
			nm=k-1
			y=w(nm)
			g=rv1(nm)
			h=rv1(k)
			f=((y-z)*(y+z)+(g-h)*(g+h))/(2.0_dp*h*y)
			g=pythag(f,1.0_dp)
			f=((x-z)*(x+z)+h*((y/(f+sign(g,f)))-h))/x
			c=1.0_dp
			s=1.0_dp
			do j=l,nm
				i=j+1
				g=rv1(i)
				y=w(i)
				h=s*g
				g=c*g
				z=pythag(f,h)
				rv1(j)=z
				c=f/z
				s=h/z
				f= (x*c)+(g*s)
				g=-(x*s)+(g*c)
				h=y*s
				y=y*c
				tempn(1:n)=v(1:n,j)
				v(1:n,j)=v(1:n,j)*c+v(1:n,i)*s
				v(1:n,i)=-tempn(1:n)*s+v(1:n,i)*c
				z=pythag(f,h)
				w(j)=z
				if (z /= 0.0_dp) then
					z=1.0_dp/z
					c=f*z
					s=h*z
				end if
				f= (c*g)+(s*y)
				x=-(s*g)+(c*y)
				tempm(1:m)=a(1:m,j)
				a(1:m,j)=a(1:m,j)*c+a(1:m,i)*s
				a(1:m,i)=-tempm(1:m)*s+a(1:m,i)*c
			end do
			rv1(l)=0.0_dp
			rv1(k)=f
			w(k)=x
		end do
	end do
	END SUBROUTINE svdcmp



	SUBROUTINE svbksb(u,w,v,b,x)
	USE nrtype; USE nrutil, ONLY : assert_eq
	REAL(DP), DIMENSION(:,:), INTENT(IN) :: u,v
	REAL(DP), DIMENSION(:), INTENT(IN) :: w,b
	REAL(DP), DIMENSION(:), INTENT(OUT) :: x
	INTEGER(I4B) :: mdum,ndum
	REAL(DP), DIMENSION(size(x)) :: tmp
	mdum=assert_eq(size(u,1),size(b),'svbksb_dp: mdum')
	ndum=assert_eq((/size(u,2),size(v,1),size(v,2),size(w),size(x)/),&
		'svbksb_dp: ndum')
	where (w /= 0.0_dp)
		tmp=matmul(b,u)/w
	elsewhere
		tmp=0.0_dp
	end where
	x=matmul(v,tmp)
	END SUBROUTINE svbksb



	FUNCTION pythag(a,b)
	USE nrtype
	IMPLICIT NONE
	REAL(DP), INTENT(IN) :: a,b
	REAL(DP) :: pythag
	REAL(DP) :: absa,absb
	absa=abs(a)
	absb=abs(b)
	if (absa > absb) then
		pythag=absa*sqrt(1.0_dp+(absb/absa)**2)
	else
		if (absb == 0.0_dp) then
			pythag=0.0_dp
		else
			pythag=absb*sqrt(1.0_dp+(absa/absb)**2)
		end if
	end if
	END FUNCTION pythag


end module
