!	----------------------------------------------------------------------
!	file name: opimization.f90
!
!	translation of Matlab function fmin('F', x1, x2)
!	algorithm is very similar to "fminbr" from NETLIB
!	----------------------------------------------------------------------	*/


module optimizationMod

contains



real(8) function bisect(func,x1,x2,xacc)

	implicit none

	integer, parameter:: JMAX = 100
	real(8) rtbis, x1, x2, xacc, func, dx, f, fmid, xmid
	external func
	integer j


	fmid=func(x2)
	f=func(x1)
	

	if(f*fmid >= 0.0D0) then
		print*, "root must be bracketed in rtbis"
		stop
	end if


	if(f < 0.0D0)then
		rtbis=x1
		dx=x2-x1
	else
		rtbis=x2
		dx=x1-x2
	endif


	do j = 1, JMAX

		dx=dx*0.5D0
		xmid=rtbis+dx
		fmid=func(xmid)
		if(fmid <= 0.0D0) rtbis = xmid
!		if(dabs(dx) < xacc .or. fmid == 0.0D0) then
		if(dabs(dx) < xacc .or. dabs(fmid) < xacc) then
			bisect = rtbis
			return
		end if

	end do
    
	print*, "too many bisections in rtbis"


end function





subroutine fmin(fcn, ax, bx, xmin)

	implicit none

	real(8) fcn, ax, bx, xmin
	external fcn

	real(8), parameter:: tol = 1.0D-8, eps = 2.220446049250313D-016
	integer, parameter:: maxiter = 500
	integer num
	real(8) seps, c, a,	b, v, w, xf, d,	e, x, fx, fv, fw, xm, tol1, tol2, p, q, r, fu
	logical	gs


	if (ax == bx) then
		bx = ax + 1.0D-20
	end if


	!	initialization

	num = 1
	seps = dsqrt(eps)
	c = 0.5D0*(3.0D0 - dsqrt(5.0D0))
	a = ax
	b = bx
	v = a + c*(b-a)
	w = v
	xf = v
	d = 0.0D0
	e = 0.0D0
	x = xf
	fx = fcn(x)
	fv = fx
	fw = fx
	xm = 0.5D0*(a + b)
	tol1 = seps*dabs(xf) + tol/3.0D0
	tol2 = 2.0D0*tol1
	gs = .false.


	!	main loop

	do while ( dabs(xf - xm) > (tol2 - 0.5D0*(b-a)) )

		num = num + 1
		gs = .true.

		!	is a parabolic fit possible

		if (dabs(e) > tol1) then

			!	yes, so fit parabola

			gs = .false.
			r = (xf - w)*(fx - fv)
			q = (xf - v)*(fx - fw)
			p = (xf - v)*q - (xf - w)*r
			q = 2.0D0*(q - r)
			if (q > 0) then
				p = -p
			end if
			q = dabs(q)
			r = e
			e = d

			!	is parabola acceptable

			if ((dabs(p) < dabs(0.5D0*q*r)) .and. (p > q*(a-xf)) .and.		&
				(p < q*(b-xf))) then
				
				!	yes, parabolic interpolation step

				d = p/q
				x = xf + d

				!	f must not be evaluated too close to ax or bx

				if ( ((x-a) < tol2) .or. ((b-x) < tol2) ) then
					if (xm >= xf) then 
						d = tol1
					else 
						d = -tol1
					end if
				end if

			else

				!	no, not acceptable, must do a golden section step
			
				gs = .true.

			end if

		end if

		if (gs) then

			!	a golden section step is required

			if (xf >= xm) then
				e = a - xf
			else
				e = b - xf
			end if
		
			d = c*e

		end if

		!	the function must not be evaluated to close to xf
		
		if (d >= 0) then
			x = xf + max(dabs(d), tol1)
		else 
			x = xf - max(dabs(d), tol1)
		end if

		fu = fcn(x)


		!	update a, b, v, w, x, xm, tol1, tol2

		if (fu <= fx) then

			if (x >= xf) then
				a = xf
			else
				b = xf
			end if
		
			v = w
			fv = fw
			w = xf
			fw = fx
			xf = x
			fx = fu

		else

			if (x < xf) then
				a = x
			else
				b = x
			end if

			if ( fu <= fw .or. w == xf ) then
				v = w
				fv = fw
				w = x
				fw = fu
			else if ( fu <= fw .or. v == xf .or. v == w ) then
				v = x;
				fv = fu;
			end if

		end if

		xm = 0.5D0*(a + b)
		tol1 = seps*dabs(xf) + tol/3.0D0
		tol2 = 2.0D0*tol1

		if (num > maxiter) then
			print*, "Warning: Maximum number of function evaluation has been exceeded"
			stop
		end if

	end do
	
	xmin = x

end subroutine
	
	

!	================================================================================
!	brent method for one dimensional minimization
!	taken from Numerical Recipes by Press et al.
!	================================================================================

FUNCTION brent(ax,bx,cx,func,tol,xmin)
	USE nrtype; USE nrutil, ONLY : nrerror
	IMPLICIT NONE
	REAL(SP), INTENT(IN) :: ax,bx,cx,tol
	REAL(SP), INTENT(OUT) :: xmin
	REAL(SP) :: brent
	INTERFACE
		FUNCTION func(x)
		USE nrtype
		IMPLICIT NONE
		REAL(SP), INTENT(IN) :: x
		REAL(SP) :: func
		END FUNCTION func
	END INTERFACE
	INTEGER(I4B), PARAMETER :: ITMAX=100
	REAL(SP), PARAMETER :: CGOLD=0.3819660_sp,ZEPS=1.0e-3_sp*epsilon(ax)
	INTEGER(I4B) :: iter
	REAL(SP) :: a,b,d,e,etemp,fu,fv,fw,fx,p,q,r,tol1,tol2,u,v,w,x,xm
	a=min(ax,cx)
	b=max(ax,cx)
	v=bx
	w=v
	x=v
	e=0.0
	fx=func(x)
	fv=fx
	fw=fx
	do iter=1,ITMAX
		xm=0.5_sp*(a+b)
		tol1=tol*abs(x)+ZEPS
		tol2=2.0_sp*tol1
		if (abs(x-xm) <= (tol2-0.5_sp*(b-a))) then
			xmin=x
			brent=fx
			RETURN
		end if
		if (abs(e) > tol1) then
			r=(x-w)*(fx-fv)
			q=(x-v)*(fx-fw)
			p=(x-v)*q-(x-w)*r
			q=2.0_sp*(q-r)
			if (q > 0.0) p=-p
			q=abs(q)
			etemp=e
			e=d
			if (abs(p) >= abs(0.5_sp*q*etemp) .or. &
				p <= q*(a-x) .or. p >= q*(b-x)) then
				e=merge(a-x,b-x, x >= xm )
				d=CGOLD*e
			else
				d=p/q
				u=x+d
				if (u-a < tol2 .or. b-u < tol2) d=sign(tol1,xm-x)
			end if
		else
			e=merge(a-x,b-x, x >= xm )
			d=CGOLD*e
		end if
		u=merge(x+d,x+sign(tol1,d), abs(d) >= tol1 )
		fu=func(u)
		if (fu <= fx) then
			if (u >= x) then
				a=x
			else
				b=x
			end if
			call shft(v,w,x,u)
			call shft(fv,fw,fx,fu)
		else
			if (u < x) then
				a=u
			else
				b=u
			end if
			if (fu <= fw .or. w == x) then
				v=w
				fv=fw
				w=u
				fw=fu
			else if (fu <= fv .or. v == x .or. v == w) then
				v=u
				fv=fu
			end if
		end if
	end do
	call nrerror('brent: exceed maximum iterations')
	CONTAINS
!BL
	SUBROUTINE shft(a,b,c,d)
	REAL(SP), INTENT(OUT) :: a
	REAL(SP), INTENT(INOUT) :: b,c
	REAL(SP), INTENT(IN) :: d
	a=b
	b=c
	c=d
	END SUBROUTINE shft
END FUNCTION brent




!	================================================================================
!	brent method for one nonlinear equation solver
!	================================================================================

SUBROUTINE DZBREN(F,ERRABS,ERRREL,A,B,MAXFN)

	IMPLICIT DOUBLE PRECISION (A-H,O-Z)
	
	EXTERNAL F
	
	CALL ZBRENT(F,A,B,ZERO,ERRABS,ERRREL,MAXFN,ITER1)
	B=ZERO
	MAXFN=ITER1

END SUBROUTINE



SUBROUTINE ZBRENT(FUNC,X1,X2,ZERO,TOL,EPS,ITMAX,ITER1)

	IMPLICIT DOUBLE PRECISION(A-H,O-Z)
	
	EXTERNAL FUNC
	
	A=X1
	B=X2
	FA=FUNC(A)
	FB=FUNC(B)
	IF((FA.GT.0D0.AND.FB.GT.0D0).OR.(FA.LT.0D0.AND.FB.LT.0D0)) THEN
		PRINT *, 'ROOT MUST BE BRACKETED FOR ZBRENT'
		STOP
	END IF

	C=B
	FC=FB
	DO ITER = 1, ITMAX
		
		IF((FB.GT.0D0.AND.FC.GT.0D0).OR.(FB.LT.0D0.AND.FC.LT.0D0))THEN
			C=A
			FC=FA
			D=B-A
			E=D
		ENDIF
		
		IF(DABS(FC).LT.DABS(FB)) THEN
			A=B
			B=C
			C=A
			FA=FB
			FB=FC
			FC=FA
		ENDIF
		
		TOL1 = 2D0*EPS*DABS(B)+0.5D0*TOL
		XM=.5D0*(C-B)
		
		IF(DABS(XM).LE.TOL1 .OR. FB.EQ.0D0)THEN
			ZERO=B
			ITER1=ITER
			RETURN
		ENDIF
		
		IF(DABS(E).GE.TOL1 .AND. DABS(FA).GT.DABS(FB)) THEN
			S=FB/FA
			IF(A.EQ.C) THEN
				P=2.*XM*S
				Q=1.-S
			ELSE
				Q=FA/FC
				R=FB/FC
				P=S*(2D0*XM*Q*(Q-R)-(B-A)*(R-1D0))
				Q=(Q-1D0)*(R-1D0)*(S-1D0)
			ENDIF
			
			IF(P.GT.0D0) Q=-Q
			
			P=DABS(P)
			IF(2D0*P .LT. DMIN1(3D0*XM*Q-DABS(TOL1*Q),DABS(E*Q))) THEN
				E=D
				D=P/Q
			ELSE
				D=XM
				E=D
			ENDIF
		ELSE
			D=XM
			E=D
		ENDIF
		
		A=B
		FA=FB
		
		IF(DABS(D) .GT. TOL1) THEN
			B=B+D
		ELSE
			B=B+DSIGN(TOL1,XM)
		ENDIF
		
		FB=FUNC(B)

	END DO

	PRINT *, 'ZBRENT EXCEEDING MAXIMUM ITERATIONS'
	PAUSE
	ZERO=B
	ITER1=ITER	
	RETURN
      
END SUBROUTINE


end module
