C
C Uniform (0,1) and Standard Normal Random Number Generator extracted 
C from rn5_sp.f
C
C**********************************************************************CSUN  590
C**********************************************************************CSUN  600
C                                                                      CSUN  610
C                                                                      CSUN  620
C       0 , 1   - U N I F O R M  DISTRIBUTION                          CSUN  630
C                                                                      CSUN  640
C                                                                      CSUN  650
C**********************************************************************CSUN  660
C**********************************************************************CSUN  670
C                                                                      CSUN  680
C     FOR DETAILS SEE:                                                 CSUN  690
C                                                                      CSUN  700
C               AHRENS, J.H., DIETER, U. AND GRUBE, A.                 CSUN  710
C               PSEUDO-RANDOM NUMBERS:  A NEW PROPOSAL                 CSUN  720
C                     FOR THE CHOICE OF MULTIPLICATORS                 CSUN  730
C               COMPUTING, 6 (1970), 121 - 138                         CSUN  740
C                                                                      CSUN  750
C**********************************************************************CSUN  760
C                                                                       SUN  770
      REAL FUNCTION SUNIF(IR)                                           SUN  780
      DOUBLE PRECISION R,FACTOR,TWO28
      SAVE R
C
C     FACTOR - INTEGER OF THE FORM 8*K+5 AS CLOSE AS POSSIBLE
C              TO  2**26 * (SQRT(5)-1)/2     (GOLDEN SECTION)
C     TWO28  = 2**28  (I.E. 28 SIGNIFICANT BITS FOR DEVIATES)
C
      DATA FACTOR /41475557.0D0/, TWO28 /268435456.0D0/
C
C     RETURNS SAMPLE U FROM THE  0,1 -UNIFORM DISTRIBUTION
C     BY A MULTIPLICATIVE CONGRUENTIAL GENERATOR OF THE FORM
C        R := R * FACTOR (MOD 1) .
C     IN THE FIRST CALL R IS INITIALIZED TO
C        R := IR / 2**28 ,
C     WHERE IR MUST BE OF THE FORM  IR = 4*K+1.
C     THEN R ASSUMES ALL VALUES  0 < (4*K+1)/2**28 < 1 DURING
C     A FULL PERIOD 2**26 OF SUNIF.
C     THE PARAMETER IR IS USED ONLY IN THE FIRST CALL FOR
C     INITIALIZATION OF SUNIF. THEREAFTER (WHEN NEGATIVE)
C     IR BECOMES A DUMMY VARIABLE.
C
      IF (IR .GE. 0) GO TO 1
C
C     STANDARD CASE:  SAMPLING
C
      R=DMOD(R*FACTOR,1.0D0)
      SUNIF=SNGL(R)
      RETURN
C
C     FIRST CALL: INITIALIZATION
C
1     R=DBLE(FLOAT(IR))/TWO28
      R=DMOD(R*FACTOR,1.0D0)
      SUNIF=SNGL(R)
      IR=-1
      RETURN
      END
C                                                                       SNO   10
C**********************************************************************CSNO   20
C**********************************************************************CSNO   30
C                                                                      CSNO   40
C                                                                      CSNO   50
C     (STANDARD-)  N O R M A L  DISTRIBUTION                           CSNO   60
C                                                                      CSNO   70
C                                                                      CSNO   80
C**********************************************************************CSNO   90
C**********************************************************************CSNO  100
C                                                                      CSNO  110
C     FOR DETAILS SEE:                                                 CSNO  120
C                                                                      CSNO  130
C               AHRENS, J.H. AND DIETER, U.                            CSNO  140
C               EXTENSIONS OF FORSYTHE'S METHOD FOR RANDOM             CSNO  150
C               SAMPLING FROM THE NORMAL DISTRIBUTION.                 CSNO  160
C               MATH. COMPUT., 27,124 (OCT. 1973), 927 - 937.          CSNO  170
C                                                                      CSNO  180
C     ALL STATEMENT NUMBERS CORRESPOND TO THE STEPS OF ALGORITHM 'FL'  CSNO  190
C     (M=5) IN THE ABOVE PAPER     (SLIGHTLY MODIFIED IMPLEMENTATION)  CSNO  200
C                                                                      CSNO  210
C**********************************************************************CSNO  220
C                                                                       SNO  230
      REAL FUNCTION SNORM(IR)                                           SNO  240
      DIMENSION A(32),D(31),T(31),H(31)
C
C     THE DEFINITIONS OF THE CONSTANTS A(K), D(K), T(K) AND
C     H(K) ARE ACCORDING TO THE ABOVEMENTIONED ARTICLE
C
      DATA A/0.0,.3917609E-1,.7841241E-1,.1177699,.1573107,
     ,.1970991,.2372021,.2776904,.3186394,.3601299,.4022501,
     ,.4450965,.4887764,.5334097,.5791322,.6260990,.6744898,
     ,.7245144,.7764218,.8305109,.8871466,.9467818,1.009990,
     ,1.077516,1.150349,1.229859,1.318011,1.417797,1.534121,
     ,1.675940,1.862732,2.153875/
      DATA D/5*0.0,.2636843,.2425085,.2255674,.2116342,.1999243,
     ,.1899108,.1812252,.1736014,.1668419,.1607967,.1553497,
     ,.1504094,.1459026,.1417700,.1379632,.1344418,.1311722,
     ,.1281260,.1252791,.1226109,.1201036,.1177417,.1155119,
     ,.1134023,.1114027,.1095039/
      DATA T/.7673828E-3,.2306870E-2,.3860618E-2,.5438454E-2,
     ,.7050699E-2,.8708396E-2,.1042357E-1,.1220953E-1,.1408125E-1,
     ,.1605579E-1,.1815290E-1,.2039573E-1,.2281177E-1,.2543407E-1,
     ,.2830296E-1,.3146822E-1,.3499233E-1,.3895483E-1,.4345878E-1,
     ,.4864035E-1,.5468334E-1,.6184222E-1,.7047983E-1,.8113195E-1,
     ,.9462444E-1,.1123001,.1364980,.1716886,.2276241,.3304980,
     ,.5847031/
      DATA H/.3920617E-1,.3932705E-1,.3950999E-1,.3975703E-1,
     ,.4007093E-1,.4045533E-1,.4091481E-1,.4145507E-1,.4208311E-1,
     ,.4280748E-1,.4363863E-1,.4458932E-1,.4567523E-1,.4691571E-1,
     ,.4833487E-1,.4996298E-1,.5183859E-1,.5401138E-1,.5654656E-1,
     ,.5953130E-1,.6308489E-1,.6737503E-1,.7264544E-1,.7926471E-1,
     ,.8781922E-1,.9930398E-1,.1155599,.1404344,.1836142,.2790016,
     ,.7010474/
C
   1  U=SUNIF(IR)
      S=0.0
      IF (U.GE.0.5) S=1.0
      U=U+U-S
   2  U=32.0*U
      I=INT(U)
      IF (I.EQ.0) GO TO 9
C
C                                START CENTER
C
   3  USTAR=U-FLOAT(I)
      AA=A(I)
   4  IF (USTAR.LE.T(I)) GO TO 5
      W=(USTAR-T(I))*H(I)
C
C                                EXIT   (BOTH CASES)
C
  17  Y=AA+W
      SNORM=Y
      IF (S.EQ.1.0) SNORM=-Y
      RETURN
C
C                                CENTER CONTINUED
C
   5  U=SUNIF(IR)
      W=U*(A(I+1)-AA)
      TT=(0.5*W+AA)*W
      GO TO 6
   8  TT=U
      USTAR=SUNIF(IR)
   6  IF (USTAR.GT.TT) GO TO 17
   7  U=SUNIF(IR)
      IF (USTAR.GE.U) GO TO 8
      USTAR=SUNIF(IR)
      GO TO 4
C
C                                START TAIL
C
   9  I=6
      AA=A(32)
      GO TO 10
  11  AA=AA+D(I)
      I=I+1
  10  U=U+U
      IF (U.LT.1.0) GO TO 11
  12  U=U-1.0
  13  W=U*D(I)
      TT=(0.5*W+AA)*W
      GO TO 14
  16  TT=U
  14  USTAR=SUNIF(IR)
      IF (USTAR.GT.TT) GO TO 17
  15  U=SUNIF(IR)
      IF (USTAR.GE.U) GO TO 16
      U=SUNIF(IR)
      GO TO 13
      END
