module distribution
    
    
    use sorting
    use sorting2
  
    implicit none


    contains
    



subroutine dist(in_dist, in_pdf, n1, n2, nq, qntle, ginic)

! in_dist: distribution input
! in_pdf: pdf input
! n1 and n2 : size of in_dist
! nq = number of groups


! qntle: ouput distribution
! ginic: gini coefficients


implicit none

    integer, intent(in) :: n1, n2, nq
    real(8), intent(in) :: in_dist(n1,n2), in_pdf(n1,n2)  
    real(8), allocatable, dimension(:) ::INEQDIST,INDIST, PDF, CDF, &
                                INEQPDF, INEQCDF, INEQSHARE        
    real(8), intent(out) :: qntle(nq), ginic
    real(8) :: mean
    integer :: row1, row2
    integer :: iq, jq
    
    allocate(INEQDIST(n1*n2),INDIST(n1*n2), PDF(n1*n2), CDF(n1*n2),INEQPDF(n1*n2), INEQCDF(n1*n2), INEQSHARE(n1*n2))
  
    

    INEQDIST= reshape(in_dist, (/n1*n2/))
    PDF = reshape(in_pdf, (/n1*n2/)) 
    
   call dsorting2(n1*n2,INEQDIST,PDF)
    
    mean = sum(INEQDIST*PDF)
    
    do iq = 2, n1*n2

       INEQPDF(1) = INEQDIST(1)*PDF(1)
       INEQSHARE(1) = INEQPDF(1)/mean

       INEQPDF(iq) = INEQDIST(iq)*PDF(iq)
       INEQSHARE(iq) = INEQPDF(iq)/mean

       INEQCDF(1) = INEQSHARE(1)
       INEQCDF(iq) = INEQCDF(iq-1)+INEQSHARE(iq)
      

       CDF(1) = PDF(1)
       CDF(iq) = CDF(iq-1) + PDF(iq)
    end do
    
    
    do iq = 1, nq
        
        if (iq==1) then
            
        row1=MAXLOC(CDF,dim=1, MASK = CDF .LT. 1.0D0/nq)
        qntle(1) = INEQCDF(row1+1)
            
        else if (iq < nq) then
            
        row1 = MAXLOC(CDF,dim=1, MASK = CDF .LT. (iq-1)*(1.0D0/nq))
        row2 = MAXLOC(CDF,dim=1, MASK = CDF .LT. iq*(1.0D0/nq))
        qntle(iq) = (INEQCDF(row2+1)-INEQCDF(row1+1))
        
        else if (iq == nq) then
        qntle(nq) = (1.0D0 -INEQCDF(row2+1))
        end if
        
    end do
    
        
    call gini(PDF,INEQCDF,n1, n2, ginic)
    
    qntle = qntle*100
    
     deallocate(INEQDIST,INDIST, PDF, CDF,INEQPDF, INEQCDF, INEQSHARE)


end subroutine dist





subroutine dist_zero(in_dist, in_pdf, n1, n2, nq, qntle, ginic)

! in_dist: distribution input
! in_pdf: pdf input
! n1 and n2 : size of in_dist
! nq = number of groups


! qntle: ouput distribution
! ginic: gini coefficients


implicit none

    integer, intent(in) :: n1, n2, nq
    real(8), intent(in) :: in_dist(n1,n2), in_pdf(n1,n2)  
    real(8), allocatable, dimension(:) ::INEQDIST,INDIST, PDF, CDF, &
                                INEQPDF, INEQCDF, INEQSHARE, INEQDIST2, PDF2     
    real(8), intent(out) :: qntle(nq), ginic
    real(8) :: mean
    integer :: row1, row2, new_nu
    integer :: iq, jq
    
    allocate(INEQDIST(n1*n2), PDF(n1*n2))
  
    

    INEQDIST= reshape(in_dist, (/n1*n2/))
    PDF = reshape(in_pdf, (/n1*n2/)) 
    
   call dsorting2(n1*n2,INEQDIST,PDF)
   iq = MINLOC(INEQDIST, dim=1, MASK = INEQDIST > 0.0D0)
   new_nu = n1*n2 - iq +1
   
   !print *, iq, INEQDIST(iq-1), INEQDIST(iq),INEQDIST(iq+1)
   !pause
   
    
    allocate(INEQDIST2(new_nu), PDF2(new_nu))
    INEQDIST2= INEQDIST(iq:n1*n2)
    PDF2 = PDF(iq:n1*n2)
    
    deallocate(INEQDIST, PDF)
    allocate(INEQDIST(new_nu),INDIST(new_nu), PDF(new_nu), CDF(new_nu),INEQPDF(new_nu), INEQCDF(new_nu), INEQSHARE(new_nu))
    
    PDF = PDF2/sum(PDF2)    
    INEQDIST = INEQDIST2
    
    
    call dsorting2(new_nu,INEQDIST,PDF)
    mean = sum(INEQDIST*PDF)
    
    
    do iq = 2, new_nu

       INEQPDF(1) = INEQDIST(1)*PDF(1)
       INEQSHARE(1) = INEQPDF(1)/mean

       INEQPDF(iq) = INEQDIST(iq)*PDF(iq)
       INEQSHARE(iq) = INEQPDF(iq)/mean

       INEQCDF(1) = INEQSHARE(1)
       INEQCDF(iq) = INEQCDF(iq-1)+INEQSHARE(iq)
      

       CDF(1) = PDF(1)
       CDF(iq) = CDF(iq-1) + PDF(iq)
    end do
         
    
    do iq = 1, nq
        
        if (iq==1) then
            
        row1=MAXLOC(CDF,dim=1, MASK = CDF .LT. 1.0D0/nq)
        qntle(1) = INEQCDF(row1)
            
        else if (iq < nq) then
            
        row1 = MAXLOC(CDF,dim=1, MASK = CDF .LT. (iq-1)*(1.0D0/nq))
        row2 = MAXLOC(CDF,dim=1, MASK = CDF .LT. iq*(1.0D0/nq))
        qntle(iq) = (INEQCDF(row2)-INEQCDF(row1))
        
        else if (iq == nq) then
        qntle(nq) = (1.0D0 -INEQCDF(row2))
        end if
        
    end do
    
    
     open(1, file='Output\HR_popz.txt', status='unknown')
     open(2, file='Output\HR_sharez.txt', status='unknown')
     write(1, '(F8.4)') CDF
     write(2, '(F8.4)') INEQCDF
     close(1)
     close(2)
    
    
        
    call gini(PDF,INEQCDF, 1, new_nu, ginic)
    
    qntle = qntle*100
    
     deallocate(INEQDIST,INDIST, PDF, INEQDIST2, PDF2, CDF,INEQPDF, INEQCDF, INEQSHARE)


end subroutine dist_zero





subroutine dist3(in_dist, in_pdf, n1, n2, nq, qntle, ginic)

! in_dist: distribution input
! in_pdf: pdf input
! n1 and n2 : size of in_dist
! nq = number of groups


! qntle: ouput distribution
! ginic: gini coefficients


implicit none

    integer, intent(in) :: n1, n2, nq
    real(8), intent(in) :: in_dist(n1,n2), in_pdf(n1,n2)  
    real(8), allocatable, dimension(:) ::INEQDIST,INDIST, PDF, CDF, &
                                INEQPDF, INEQCDF, INEQSHARE        
    real(8), intent(out) :: qntle(nq), ginic
    real(8) :: mean
    integer :: row1, row2
    integer :: iq, jq
    
    allocate(INEQDIST(n1*n2),INDIST(n1*n2), PDF(n1*n2), CDF(n1*n2),INEQPDF(n1*n2), INEQCDF(n1*n2), INEQSHARE(n1*n2))
  
    

    INEQDIST= reshape(in_dist, (/n1*n2/))
    PDF = reshape(in_pdf, (/n1*n2/)) 
    
   call dsorting2(n1*n2,INEQDIST,PDF)
    
    mean = sum(INEQDIST*PDF)
    
    do iq = 2, n1*n2

       INEQPDF(1) = INEQDIST(1)*PDF(1)
       INEQSHARE(1) = INEQPDF(1)/mean

       INEQPDF(iq) = INEQDIST(iq)*PDF(iq)
       INEQSHARE(iq) = INEQPDF(iq)/mean

       INEQCDF(1) = INEQSHARE(1)
       INEQCDF(iq) = INEQCDF(iq-1)+INEQSHARE(iq)
      

       CDF(1) = PDF(1)
       CDF(iq) = CDF(iq-1) + PDF(iq)
    end do
         
    
    do iq = 1, nq
        
        if (iq==1) then
            
        row1=MAXLOC(CDF,dim=1, MASK = CDF .LT. 1.0D0/nq)
        qntle(1) = row1
            
        else if (iq < nq) then
            
        row1 = MAXLOC(CDF,dim=1, MASK = CDF .LT. (iq-1)*(1.0D0/nq))
        row2 = MAXLOC(CDF,dim=1, MASK = CDF .LT. iq*(1.0D0/nq))
        qntle(iq) = row2
        
        else if (iq == nq) then
        qntle(nq) = row2
        end if
        
    end do
    
        
    call gini(PDF,INEQCDF,n1, n2, ginic)
    
    qntle = qntle*100
    
     deallocate(INEQDIST,INDIST, PDF, CDF,INEQPDF, INEQCDF, INEQSHARE)


end subroutine dist3




subroutine dist2(in_dist1, in_dist2, in_pdf, n1, n2, nq, qntle)

! in_dist: distribution input
! in_pdf: pdf input
! n1 and n2 : size of in_dist
! nq = number of groups


! qntle: ouput distribution
! ginic: gini coefficients


implicit none

    integer, intent(in) :: n1, n2, nq
    real(8), intent(in) :: in_dist1(n1,n2), in_dist2(n1,n2), in_pdf(n1,n2)  
    real(8), allocatable, dimension(:) ::INEQDIST, INDIST, INDIST2, PDF, CDF, &
                                         INEQPDF, INEQCDF, INEQSHARE        
    real(8), intent(out) :: qntle(nq)
    real(8) :: mean
    integer :: row1, row2
    integer :: iq, jq
    
    allocate(INEQDIST(n1*n2),INDIST(n1*n2), INDIST2(n1*n2), PDF(n1*n2), CDF(n1*n2),INEQPDF(n1*n2), INEQCDF(n1*n2), INEQSHARE(n1*n2))
  
    

    INDIST = reshape(in_dist1, (/n1*n2/))
    INEQDIST= reshape(in_dist2, (/n1*n2/))
    PDF = reshape(in_pdf, (/n1*n2/))
        
    
   INDIST2=INDIST
   call dsorting2(n1*n2,INDIST,PDF)
   call dsorting2(n1*n2,INDIST2,INEQDIST)

    
    mean = sum(INEQDIST*PDF)
    
    do iq = 2, n1*n2

       INEQPDF(1) = INEQDIST(1)*PDF(1)
       INEQSHARE(1) = INEQPDF(1)/mean

       INEQPDF(iq) = INEQDIST(iq)*PDF(iq)
       INEQSHARE(iq) = INEQPDF(iq)/mean

       INEQCDF(1) = INEQSHARE(1)
       INEQCDF(iq) = INEQCDF(iq-1)+INEQSHARE(iq)

       CDF(1) = PDF(1)
       CDF(iq) = CDF(iq-1) + PDF(iq)
    end do
    
    do iq = 1, nq
        
        if (iq==1) then
            
        row1=MAXLOC(CDF,dim=1, MASK = CDF .LT. 1.0D0/nq)
        qntle(1) = INEQCDF(row1+1)
            
        else if (iq < nq) then
            
        row1 = MAXLOC(CDF,dim=1, MASK = CDF .LT. (iq-1)*(1.0D0/nq))
        row2 = MAXLOC(CDF,dim=1, MASK = CDF .LT. iq*(1.0D0/nq))
        qntle(iq) = (INEQCDF(row2+1)-INEQCDF(row1+1))
        
        else if (iq == nq) then
        qntle(nq) = (1.0D0-INEQCDF(row2+1))
        end if
        
    end do
    
       
    qntle = qntle*100
    
     deallocate(INEQDIST,INDIST, INDIST2, PDF, CDF,INEQPDF, INEQCDF, INEQSHARE)


end subroutine dist2





subroutine model_dist(in_dist, in_pdf, n1, n2, cdf,INEQCDF)

! in_dist: distribution input
! in_pdf: pdf input
! n1 and n2 : size of in_dist


! cdf1: pop_cdf
! cdf2: in_cdf


implicit none

    integer, intent(in) :: n1, n2
    real(8), intent(in) :: in_dist(n1,n2), in_pdf(n1,n2)  
    real(8), allocatable, dimension(:) ::INEQDIST,INDIST, PDF,  &
                                INEQPDF,  INEQSHARE        
    real(8), intent(out) :: cdf(n1*n2), INEQCDF(n1*n2)
    real(8) :: mean
    integer :: iq, jq
    
    allocate(INEQDIST(n1*n2),INDIST(n1*n2), PDF(n1*n2), INEQPDF(n1*n2), INEQSHARE(n1*n2))
  
    

    do iq = 1, n2
        INEQDIST((iq-1)*n1+1:iq*n1) = in_dist(:,iq)
        PDF((iq-1)*n1+1:iq*n1) = in_pdf(:,iq)
    end do    
    
   call dsorting2(n1*n2,INEQDIST,PDF)
    
    mean = sum(INEQDIST*PDF)
    
    do iq = 2, n1*n2

       INEQPDF(1) = INEQDIST(1)*PDF(1)
       INEQSHARE(1) = INEQPDF(1)/mean

       INEQPDF(iq) = INEQDIST(iq)*PDF(iq)
       INEQSHARE(iq) = INEQPDF(iq)/mean

       INEQCDF(1) = INEQSHARE(1)
       INEQCDF(iq) = INEQCDF(iq-1)+INEQSHARE(iq)

       CDF(1) = PDF(1)
       CDF(iq) = CDF(iq-1) + PDF(iq)
    end do
    
  
   
    
     deallocate(INEQDIST,INDIST, PDF, INEQPDF,  INEQSHARE)


end subroutine model_dist


subroutine gini(pop,cdf,n1,n2,gg)

	implicit none

	integer::first, ig
    integer, intent(in) ::n1, n2
 	real(8), intent(in) :: pop(n1*n2), cdf(n1*n2)
	real(8), intent(out) ::gg
    real(8), allocatable :: s(:)
    
    allocate (s(n1*n2))
    
    first = MINLOC(cdf,dim=1, MASK = cdf .GE. 0.0D0)    

    
    do ig = 1, first
        s(ig) = 0.0D0
    end do
        
    s(first) = pop(first)*cdf(first)*0.5
    
    do ig = first+1, n1*n2
        s(ig) = pop(ig)*(cdf(ig) + cdf(ig-1))*0.5
    end do
               
	gg = (0.5 - sum(s))/0.5
    
    deallocate (s)

end subroutine gini
    
end module
    