      DOUBLE PRECISION FUNCTION NORMCDF(Y)
      IMPLICIT REAL*8(A-H,O-Z)
      REAL*8 P(6), Q(5), A(9), B(8), C(5), D(4)
      DATA P(1)/-6.58749161529837803157D-04/,
     1     P(2)/-1.60837851487422766278D-02/,
     2     P(3)/-1.25781726111229246204D-01/,
     3     P(4)/-3.60344899949804439429D-01/,
     4     P(5)/-3.05326634961232344035D-01/,
     5     P(6)/-1.63153871373020978498D-02/
      DATA Q(1)/2.33520497626869185443D-03/,
     1     Q(2)/6.05183413124413191178D-02/,
     2     Q(3)/5.27905102951428412248D-01/,
     3     Q(4)/1.87295284992346047209D00/,
     4     Q(5)/2.56852019228982242072D00/
      DATA A(1)/1.23033935479799725272D03/,
     1     A(2)/2.05107837782607146532D03/,
     2     A(3)/1.71204761263407058314D03/,
     3     A(4)/8.81952221241769090411D02/,
     4     A(5)/2.98635138197400131132D02/,
     5     A(6)/6.61191906371416294775D01/,
     6     A(7)/8.88314979438837594118D00/,
     7     A(8)/5.64188496988670089180D-01/,
     8     A(9)/2.15311535474403846343D-08/
      DATA B(1)/1.23033935480374942043D03/,
     1     B(2)/3.43936767414372163696D03/,
     2     B(3)/4.36261909014324715820D03/,
     3     B(4)/3.29079923573345962678D03/,
     4     B(5)/1.62138957456669018874D03/,
     5     B(6)/5.37181101862009857509D02/,
     6     B(7)/1.17693950891312499305D02/,
     7     B(8)/1.57449261107098347253D01/
      DATA C(1)/3.209377589138469472562D03/,
     1     C(2)/3.774852376853020208137D02/,
     2     C(3)/1.138641541510501556495D02/,
     3     C(4)/3.161123743870565596947D00/,
     4     C(5)/1.857777061846031526730D-01/
      DATA D(1)/2.844236833439170622273D03/,
     1     D(2)/1.282616526077372275645D03/,
     2     D(3)/2.440246379344441733056D02/,
     3     D(4)/2.360129095234412093499D01/
      DATA ORPI/.5641895835477562869483D0/,
     1   ROOT2/.70710678118654752440083D0/
C  THIS SUBROUTINE USES CODY'S METHOD TO EVALUATE THE CUMULATIVE
C NORMAL DISTRIBUTION. IT IS PROBABLY ACCURATE TO 19 OR 20
C SIGNIFICANT DIGITS. IT WAS WRITTEN BY JAMES MACKINNON LATE IN
C 1977, BASED ON THE CODY ARTICLE REFERRED TO IN THE DOCUMENTATION
C FOR IMSL SUBROUTINE MDNOR.
      ISW = 1
      IF (Y.LT.-16.D0) Y = -16.D0
      IF (Y.GT.16.D0) Y = 16.D0
      X = -Y*ROOT2
      IF(X.GT.0.D0) GO TO 1
      IF(X.LT.0.D0) GO TO 2
      NORMCDF = .5D0
      RETURN
    2 CONTINUE
      X = - X
      ISW = -1
    1 CONTINUE
      IF(X.LT..477D0) GO TO 10
      IF(X.LE.4.D0) GO TO 20
C  EVALUATE ERFC FOR X.GT.4.0
      X2 = X*X
      XM2 = 1.D0/X2
      XM4 = XM2*XM2
      XM6 = XM4*XM2
      XM8 = XM4*XM4
      XM10 = XM6*XM4
      TOP = P(1) + P(2)*XM2 + P(3)*XM4 + P(4)*XM6 + P(5)*XM8 + P(6)*XM10
      BOT = Q(1) + Q(2)*XM2 + Q(3)*XM4 + Q(4)*XM6 + Q(5)*XM8 + XM10
      CRAP = ORPI + TOP/(BOT*X2)
      ERFC = DEXP(-X2)*CRAP/X
C
      IF(ISW.EQ.-1) ERFC = 2.D0 - ERFC
      NORMCDF = ERFC*.5D0
      RETURN
   20 CONTINUE
C  EVALUATE ERFC FOR .477.LT.X.LE.4.0
      X2 = X*X
      X3 = X2*X
      X4 = X2*X2
      X5 = X3*X2
      X6 = X3*X3
      X7 = X3*X4
      X8 = X4*X4
      TOP = A(1) + A(2)*X + A(3)*X2 + A(4)*X3 + A(5)*X4 + A(6)*X5 +
     1 A(7)*X6 + A(8)*X7 + A(9)*X8
      BOT = B(1) + B(2)*X + B(3)*X2 + B(4)*X3 + B(5)*X4 + B(6)*X5 +
     1 B(7)*X6 + B(8)*X7 + X8
      ERFC = DEXP(-X2)*TOP/BOT
C
      IF(ISW.EQ.-1) ERFC = 2.D0 - ERFC
      NORMCDF = ERFC*.5D0
      RETURN
   10 CONTINUE
C  EVALUATE ERF FOR X.LT..477
      X2 = X*X
      X4 = X2*X2
      X6 = X4*X2
      X8 = X4*X4
      TOP = C(1) + C(2)*X2 + C(3)*X4 + C(4)*X6 + C(5)*X8
      BOT = D(1) + D(2)*X2 + D(3)*X4 + D(4)*X6 + X8
      ERF = X*TOP/BOT
C
      ERF = ERF*ISW
      ERFC = 1.D0 - ERF
      NORMCDF = ERFC*.5D0
      RETURN
      END

