% Set up working directory
cd ..\Fluctuation\Output;


clc;
clear;

%--------------------------------------------------------------------------
%
% DESCRIPTION:
%
% This is sample file for computing impulse response functions with the
% associated confidence intervals for a Vector Autoregressive model.  
% 
%
% NOTICE:
%
% The structural identification of shocks is based on the standard Choleski
% decomposition. At present, no alternative identification schemes are
% included in the package. However, the code can be amended easily to allow
% for the available alternatives.
%
%--------------------------------------------------------------------------
%
% Author:  Paolo Z., September 2011
% Edited by Eunseong Ma, January, 2016
%--------------------------------------------------------------------------


clear all
close all
clc


% Aggregate Data
load Ydata.txt; load Pdata.txt; load Cdata.txt; load Idata.txt;
load Hdata.txt; load Wdata.txt; load Gdata.txt; load Mdata.txt;
load Rdata.txt; load Rfdata.txt;

% Gini Data
load G_C.txt; load G_I.txt; load G_K.txt; load G_L.txt;  load G_W.txt; 

% Income share Data
load CONS.txt; load INCS.txt; load KINCS.txt;  load LINCS.txt;  load WLTHS.txt;  

% Variable over Income Distribution
load CON_I.txt; load INC_I.txt;  load HOURS_I.txt; load WLTH_I.txt; load LINC_I.txt; load KINC_I.txt;  load VF_I.txt; 

% Variable over Wealth Distribution
load CON_W.txt; load INC_W.txt;  load HOURS_W.txt; load WLTH_W.txt; load LINC_W.txt; load KINC_W.txt;  load VF_W.txt; 

dist  = 0;
gini  = 1;
Gdata = Gdata(1:end-1);
N1 = length(Ydata);
N2 = 501;


if (dist == 1)         
    data = [Gdata exp(CON_I)];
elseif (gini == 1)
    data = [Gdata G_I G_L G_W G_C];    
else   
    data = [Gdata Ydata Cdata Idata Hdata Pdata Mdata Wdata exp(Rdata) exp(Rfdata-1)]; 
end 

data = data(N2:end,:); 
Y = log(data);

%% Set up working directory
cd ..;
cd ..\Var;
%%

vlag    = 1;
iscon   = 1;
istr    = 1;
IRhoriz = 20;
sizesho = 1;
IRtype  = 'c';
shock = 1; % the shocks of interest

nsubp = 5; 
nrow = 2;


Nvar = size(Y,2);

for ii=2:Nvar    
Ye = [Y(:,1) Y(:,ii)];
[Bcomp, cvec, dvec, Bpl_ev, VC_eps] = estim(Ye,vlag,iscon,istr);
IR = 0.25*irf(Bcomp,VC_eps,IRhoriz,IRtype,sizesho,0);
IR_tot(:,ii) = -IR(:,2,1);
end
IR_tot(:,1) = -IR(:,1,1);


H = IRhoriz;
h=linspace(0,H+1,H+1);
zero=zeros(1,H+1);

if (dist == 1) 
    
    figure('Units','normalized','Position',[0.2,0.2,.6,.15]) 
        
        jj= shock;    
  
        for ii=2:6        
        f(ii-1) = subplot(1,5,ii-1);        
        hold on
        plot(h , IR_tot(:,ii,jj)', '-', 'Color', [0 0.45 0.74], 'Linewidth',1.3);
        hold on
        plot(h, zero,'-k', 'Linewidth',0.1);
        xlim([-0.2 20])
        grid on
        NumTicks = 5;        
        set(gca,'XTick',linspace(0,H,NumTicks))
        box off
        hold off
        grid on
        end
               
       
       title(f(1),'1st Quintile','FontName','Times New Roman','FontSize', 10);
       title(f(2),'2nd Quintile','FontName','Times New Roman','FontSize', 10);
       title(f(3),'3rd Quintile','FontName','Times New Roman','FontSize', 10);
       title(f(4),'4th Quintile','FontName','Times New Roman','FontSize', 10); 
       title(f(5),'5th Quintile','FontName','Times New Roman','FontSize', 10);
       
       set(gcf,'PaperPositionMode','auto')
       print -depsc2 vf.eps
       
elseif (gini == 1) 
       figure('Units','normalized','Position',[0.2,0.2,.3,.4]) 
     jj= shock;    
  
        for ii=2:5         
        f(ii-1) = subplot(2,2,ii-1);        
        hold on
        plot(h , IR_tot(:,ii,jj)', '-', 'Color', [0 0.45 0.74], 'Linewidth',1.5);
        hold on
        plot(h, zero,'-k', 'Linewidth',0.1);
        xlim([-0.2 20])
        grid on
        NumTicks = 5;        
        set(gca,'XTick',linspace(0,H,NumTicks))
        box off
        hold off
        grid on
        end
 
       title(f(1),'Income','FontName','Times New Roman','FontSize', 10);
       title(f(2),'Earnings','FontName','Times New Roman','FontSize', 10);
       title(f(3),'Wealth','FontName','Times New Roman','FontSize', 10);       
       title(f(4),'Consumption','FontName','Times New Roman','FontSize', 10);
       
       
       set(gcf,'PaperPositionMode','auto')
       print -depsc2 gini.eps
else
    
   figure('Units','normalized','Position',[0.2,0.2,.6,.5]) 
        
        jj= shock;    
  
        for ii=1:10          
        f(ii) = subplot(nrow ,nsubp,ii);        
        hold on
        plot(h , IR_tot(:,ii,jj)', '-', 'Color', [0 0.45 0.74], 'Linewidth',1.5);
        hold on
        plot(h, zero,'-k', 'Linewidth',0.1);
        xlim([-0.2 20])
        NumTicks = 5;        
        set(gca,'XTick',linspace(0,H,NumTicks))
        box off
        hold off
        grid on
        end
   
        
       title(f(1),'MP Shock','FontName','Times New Roman','FontSize', 11);
       title(f(2),'Output','FontName','Times New Roman','FontSize', 11);       
       title(f(3),'Consumption','FontName','Times New Roman','FontSize', 11); 
       title(f(4),'Investment','FontName','Times New Roman','FontSize', 11);
       title(f(5),'Hours','FontName','Times New Roman','FontSize', 11);              
       title(f(6),'Inflation','FontName','Times New Roman','FontSize', 11);       
       title(f(7),'Real Marginal Cost','FontName','Times New Roman','FontSize', 11);       
       title(f(8),'Real Wage','FontName','Times New Roman','FontSize', 11);       
       title(f(9),'Real Return','FontName','Times New Roman','FontSize', 11);       
       title(f(10),'FFR','FontName','Times New Roman','FontSize', 11);       
       set(gcf,'PaperPositionMode','auto')
       print -depsc2 agg.eps
end

IR_tot
 