% Set up working directory
cd ..\Fluctuation\Output;


clc;
clear;

%--------------------------------------------------------------------------
%
% DESCRIPTION:
%
% This is sample file for computing impulse response functions with the
% associated confidence intervals for a Vector Autoregressive model.  
% 
%
% NOTICE:
%
% The structural identification of shocks is based on the standard Choleski
% decomposition. At present, no alternative identification schemes are
% included in the package. However, the code can be amended easily to allow
% for the available alternatives.
%
%--------------------------------------------------------------------------
%
% Author:  Paolo Z., September 2011
% Edited by Eunseong Ma, January, 2016
%--------------------------------------------------------------------------


clear all
close all
clc


% Aggregate Data
load Ydata.txt; load Pdata.txt; load Cdata.txt; load Idata.txt; 
load Hdata.txt; load Wdata.txt; load Gdata.txt; load Mdata.txt;
load Rdata.txt; load Rfdata.txt; load Kdata.txt; load Ldata.txt;
load Edata.txt;

% Gini Data
load G_C.txt; load G_I.txt; load G_K.txt; load G_L.txt;  load G_W.txt; 

% Income share Data
load CONS.txt; load INCS.txt; load KINCS.txt;  load LINCS.txt;  load WLTHS.txt;  

% Variable over Income Distribution
%load CON_I.txt; load INC_I.txt;  load HOURS_I.txt; load WLTH_I.txt; load LINC_I.txt; load KINC_I.txt;  load EMP_I.txt; 

% Variable over Wealth Distribution
%load CON_W.txt; load INC_W.txt;  load HOURS_W.txt; load WLTH_W.txt; load LINC_W.txt; load KINC_W.txt;  %load VF_W.txt; 

dist  = 0;
gini  = 0;
Gdata = Gdata(1:end-1);
N1 = length(Ydata);
N2 = 501;

if (dist == 1)         
    data = [HOURS_W];
elseif (gini == 1)
    data = [G_I G_L G_W G_C];    
else   
    data = [Ydata Cdata Idata Ldata./Hdata Pdata Mdata Wdata 1+Rdata Rfdata./Pdata]; 
end 

data = log(data(N2:end,:)); 


%% Set up working directory
cd ..;
cd ..\Var;


%%


X = [ones(N1-N2,1) log(Kdata(N2+1:end-1)) log(Gdata(N2+1:end))];
Y = log(Kdata(N2+2:end));
coff_k = inv(X'*X)*X'*Y;
%coff_k = (X'*X)\(X'*Y);


H = 50;
h=linspace(0,H,H);
zero=zeros(1,H);

M(1) = -0.005;
K(1) = mean(Kdata);
for i = 2:H
M(i) = 0.7*M(i-1);
K(i) = exp(coff_k(1) + coff_k(2)*log(K(i-1)) +  coff_k(3)*M(i));
end




Nvar = size(data,2);

IR=zeros(H,Nvar);
YY=zeros(H,1);
for ii=1:Nvar    
Y = data(1:end-1,ii);
B = inv(X'*X)*X'*Y;
%B = (X'*X)\(X'*Y);

    for i = 1:H
    YY(i,1) = exp(B(1) + B(2)*log(K(i)) +  B(3)*M(i));
    end
    
    YY = 100*(YY-YY(end))/YY(end-3);
IR(:,ii) = YY;
end


if (dist == 1) 
    
    figure('Units','normalized','Position',[0.2,0.2,.6,.15]) 
        
        for ii=1:5        
        f(ii) = subplot(1,5,ii);        
        hold on
        plot(h , IR(:,ii)', '-', 'Color', [0 0.45 0.74], 'Linewidth',1.3);
        hold on
        plot(h, zero,'-k', 'Linewidth',0.1);                 
        xlim([-0.2 20])
        grid on
        NumTicks = 5;        
        set(gca,'XTick',linspace(0,20,NumTicks))
        box off
        hold off
        grid on
        end
               
       
       title(f(1),'1st Quintile','FontName','Times New Roman','FontSize', 10);
       title(f(2),'2nd Quintile','FontName','Times New Roman','FontSize', 10);
       title(f(3),'3rd Quintile','FontName','Times New Roman','FontSize', 10);
       title(f(4),'4th Quintile','FontName','Times New Roman','FontSize', 10); 
       title(f(5),'5th Quintile','FontName','Times New Roman','FontSize', 10);
       
       set(gcf,'PaperPositionMode','auto')
       print -depsc2 vf.eps
       
elseif (gini == 1) 
       figure('Units','normalized','Position',[0.2,0.2,.6,.2])    
  
        for ii=1:4   
            
        if (ii == 3 )
             IR(:,ii) = IR(:,ii)-IR(1,ii);
        end 
        f(ii) = subplot(1,4,ii);        
        hold on
        plot(h , IR(:,ii)', '-', 'Color', [0 0.45 0.74], 'Linewidth',2);
        hold on
        plot(h, zero,'-k', 'Linewidth',0.1);
        xlim([-0.2 20])
       if (ii <= 2 )
        ylim([-1 0.3])
       end 
       
       if (ii >= 3 )
        ylim([-0.15 0.05])
       end
        grid on
        NumTicks = 5;        
        set(gca,'XTick',linspace(0,20,NumTicks))
        box off
        hold off
        grid on
        end
 
       title(f(1),'Income','FontName','Times New Roman','FontSize', 11);
       title(f(2),'Earnings','FontName','Times New Roman','FontSize', 11);
       title(f(3),'Wealth','FontName','Times New Roman','FontSize', 11);       
       title(f(4),'Consumption','FontName','Times New Roman','FontSize', 11);
       
       
       set(gcf,'PaperPositionMode','auto')
       print -depsc2 gini.eps
       
       
       figure('Units','normalized','Position',[0.2,0.2,.25,.35])    
  
        
                           
        plot(h , IR(:,1)', 'k-', 'Linewidth',2.5);
        hold on
        plot(h , IR(:,2)', 'b--',  'Linewidth',2.5);
        hold on
        plot(h , IR(:,3)', 'r:', 'Linewidth',2.5);
        hold on
        plot(h , IR(:,4)', 'g-.', 'Linewidth',2.5);
        hold on
        plot(h , IR(:,1)', 'k-', 'Linewidth',2.5);
        hold on
        plot(h, zero,'-k', 'Linewidth',0.1);
        xlim([-0.2 20])          
        ylim([-0.8 0.2])    
        grid on
        NumTicks = 5;        
        set(gca,'XTick',linspace(0,20,NumTicks))
        box off
        hold off
        grid on
        
       
       legend('Income', 'Earnings',  'Wealth', 'Consumption', 'Location', 'Southeast')
       set(gcf,'PaperPositionMode','auto')
       print -depsc2 gini2.eps
else
    
   

    nsubp = 5; 
    nrow = 2;
   figure('Units','normalized','Position',[0.2,0.2,.6,.5]) 
        
         
        IR = [100*M' IR];
        for ii=1:10      
            
         if (ii == 6 || ii == 9 || ii == 10)
             IR(:,ii) = 4*IR(:,ii);
         elseif (ii == 1)
             IR(:,ii) = 2*IR(:,ii);
         end 
             
        f(ii) = subplot(nrow ,nsubp,ii);        
        hold on
        plot(h , IR(:,ii)', '-', 'Color', [0 0.45 0.74], 'Linewidth',2.0);
        hold on
        plot(h, zero,'-k', 'Linewidth',0.1);
        xlim([-0.2 20])               
        NumTicks = 5;        
        set(gca,'XTick',linspace(0,20,NumTicks))
        box off
        hold off
        grid on
        end
   
        
       title(f(1),'Monetary Shock','FontName','Times New Roman','FontSize', 11);
       title(f(2),'Output','FontName','Times New Roman','FontSize', 11);       
       title(f(3),'Consumption','FontName','Times New Roman','FontSize', 11); 
       title(f(4),'Investment','FontName','Times New Roman','FontSize', 11);
       title(f(5),'Hours','FontName','Times New Roman','FontSize', 11);              
       title(f(6),'Inflation','FontName','Times New Roman','FontSize', 11);       
       title(f(7),'Real Marginal Cost','FontName','Times New Roman','FontSize', 11);       
       title(f(8),'Real Wage','FontName','Times New Roman','FontSize', 11);       
       title(f(9),'Real Capital Return','FontName','Times New Roman','FontSize', 11);       
       title(f(10),'Real Interest Rate','FontName','Times New Roman','FontSize', 11);       
       set(gcf,'PaperPositionMode','auto')
       print -depsc2 agg.eps
end

IR


 