% Set up working directory
cd ..\Fluctuation\Output;

clear all
close all
clc


% Aggregate Data
load Cdata.txt; load Hdata.txt; load Wdata.txt; 
load CON_I.txt; load HOURS_I.txt; load LINC_I.txt;
load CON_W.txt; load HOURS_W.txt; load LINC_W.txt;


N1 = length(Cdata);
N2 = 501;


x = [ones(N1-N2+1,1) log(Wdata(N2:end)) log(Cdata(N2:end))];
y = log(Hdata(N2:end));
b = inv(x'*x)*x'*y;
b(2)



B = zeros(3,5);
tStat = zeros(3,5);
Pval = zeros(3,5);
R2 = zeros(1,5);

for i=1:5
%x = [log(Wdata(N2:end)) log(CON_I(N2:end,i))];
x = [log(LINC_I(N2:end,i)./HOURS_I(N2:end,i)) log(CON_I(N2:end,i))];
y = log(HOURS_I(N2:end,i));
lm = fitlm(x,y,'linear');
B(:,i) = lm.Coefficients.Estimate;
tStat(:,i) = lm.Coefficients.tStat;
Pval(:,i) =lm.Coefficients.pValue;
R2(i) = lm.Rsquared.Ordinary;
end
[B(2,:); tStat(2,:); Pval(2,:); R2]



for i=1:5
%x = [log(Wdata(N2:end)) log(CON_W(N2:end,i))];
x = [log(LINC_I(N2:end,i)./HOURS_I(N2:end,i)) log(CON_I(N2:end,i))];
y = log(HOURS_W(N2:end,i));
lm = fitlm(x,y,'linear');
B(:,i) = lm.Coefficients.Estimate;
tStat(:,i) = lm.Coefficients.tStat;
Pval(:,i) =lm.Coefficients.pValue;
R2(i) = lm.Rsquared.Ordinary;
end
[B(2,:); tStat(2,:); Pval(2,:)]
