function [residual, g1, g2, g3] = FiscalRE_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 15, 1);

%
% Model equations
%

T99 = params(8)*params(9)*params(12)*(1-params(16))/params(10)^params(2);
T121 = params(13)*params(15)/params(10);
T127 = params(17)*params(16)*(params(8)*params(9)-params(8))/params(10);
residual(1) = y(7)-(params(1)-(params(2)-1)/params(2)*params(3))*y(3)-y(2);
lhs =y(7);
rhs =y(1)-y(3);
residual(2)= lhs-rhs;
lhs =y(14);
rhs =y(13)-y(1);
residual(3)= lhs-rhs;
lhs =y(15);
rhs =y(12)-y(1);
residual(4)= lhs-rhs;
lhs =y(6);
rhs =y(1)+x(1)-y(4)-y(10);
residual(5)= lhs-rhs;
lhs =y(1);
rhs =y(2)*params(4)+params(5)*y(5)+y(13)*params(6);
residual(6)= lhs-rhs;
lhs =y(1);
rhs =y(4)*params(7)+y(3)*(1-params(7))-x(1)*params(7)+y(10)*params(7);
residual(7)= lhs-rhs;
residual(8) = y(10)*(-params(8))*params(9)/params(10)-y(4)+y(5)*params(11)-x(1)*(1-params(8))/params(10)+y(4)*(1-params(8))/params(10);
residual(9) = y(10)+(-y(6))/(params(9)-1);
lhs =y(8);
rhs =y(1)-y(3);
residual(10)= lhs-rhs;
lhs =y(2)*(-params(2))-y(3)*params(3)*(1-params(2));
rhs =y(2)*(-params(2))-y(3)*params(3)*(1-params(2))+y(6)*T99;
residual(11)= lhs-rhs;
lhs =y(9);
rhs =y(6)*(1-params(16))*params(8)*params(9)/params(13);
residual(12)= lhs-rhs;
residual(13) = params(14)*y(11)-y(12)*params(15)-y(4)*params(17);
residual(14) = y(13)*params(6)+T121*(y(12)+y(9))-y(4)*T127-y(6)*params(8)*params(9)*params(17)*params(16)/params(10)-(1-params(7))*params(18)*(y(7)+y(3))+x(1)*(T127-T121)-y(12)*params(15)-y(2)*params(4)*params(19);
residual(15) = y(1)*(params(6)+params(20)-params(15)*params(21)/params(10))+params(15)*params(21)/params(10)*(y(12)-x(1))+x(2)-y(13)*params(6);
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(15, 15);

  %
  % Jacobian matrix
  %

  g1(1,2)=(-1);
  g1(1,3)=(-(params(1)-(params(2)-1)/params(2)*params(3)));
  g1(1,7)=1;
  g1(2,1)=(-1);
  g1(2,3)=1;
  g1(2,7)=1;
  g1(3,1)=1;
  g1(3,13)=(-1);
  g1(3,14)=1;
  g1(4,1)=1;
  g1(4,12)=(-1);
  g1(4,15)=1;
  g1(5,1)=(-1);
  g1(5,4)=1;
  g1(5,6)=1;
  g1(5,10)=1;
  g1(6,1)=1;
  g1(6,2)=(-params(4));
  g1(6,5)=(-params(5));
  g1(6,13)=(-params(6));
  g1(7,1)=1;
  g1(7,3)=(-(1-params(7)));
  g1(7,4)=(-params(7));
  g1(7,10)=(-params(7));
  g1(8,4)=(-1)+(1-params(8))/params(10);
  g1(8,5)=params(11);
  g1(8,10)=(-params(8))*params(9)/params(10);
  g1(9,6)=(-1)/(params(9)-1);
  g1(9,10)=1;
  g1(10,1)=(-1);
  g1(10,3)=1;
  g1(10,8)=1;
  g1(11,6)=(-T99);
  g1(12,6)=(-((1-params(16))*params(8)*params(9)/params(13)));
  g1(12,9)=1;
  g1(13,4)=(-params(17));
  g1(13,11)=params(14);
  g1(13,12)=(-params(15));
  g1(14,2)=(-(params(4)*params(19)));
  g1(14,3)=(-((1-params(7))*params(18)));
  g1(14,4)=(-T127);
  g1(14,6)=(-(params(8)*params(9)*params(17)*params(16)/params(10)));
  g1(14,7)=(-((1-params(7))*params(18)));
  g1(14,9)=T121;
  g1(14,12)=T121-params(15);
  g1(14,13)=params(6);
  g1(15,1)=params(6)+params(20)-params(15)*params(21)/params(10);
  g1(15,12)=params(15)*params(21)/params(10);
  g1(15,13)=(-params(6));
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],15,225);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],15,3375);
end
end
end
end
