function   [y, spec,lambda] = BandVar(a, pmin, pmax, datafreq, npoints)


if nargin == 4
    npoints = 30;
elseif nargin == 3
    npoints = 30;
    datafreq = 4;
end

lmin = 2*pi/(pmax*datafreq);

lmax = 2*pi/(pmin*datafreq);

passo = (lmax -lmin)/npoints;

q = size(a, 1);

lambda = (lmin + passo/2 : passo : lmax - passo/2);

Factor = exp(-sqrt(-1)*(0:q-1)'*lambda);

spec = (abs(a'*Factor).^2)/pi;
%figure;plot(lambda,spec)
y = sum(spec,2)*passo;

