
function [NewsImp] = Gambetti(IRF,M,nhor)
              
CC = zeros(M,M,nhor+1);
for ii = 1:nhor+1; CC(:,:,ii) = reshape(IRF(:,ii),M,M); end;                
SurpriseImp = CC(:,1,:);
options = optimset('MaxFunEval',2000000,'MaxIter',1000000,'TolX',1e-15);
[thetap, ~, flag] = fminsearch(@LongRunEffect,sign(CC(1,2:end,end))'.*ones(M-1,1),options,squeeze(CC(1,:,end)));
zetap=[0;thetap/norm(thetap)];
[NewsImp] = ComputeIrfOneShock(CC,zetap); %news shock