function [y,BETA,SIGMA] = VARsim1()

% BETA IS:
%                  y1(t)         y2(t)         y3(t)
%     c            0.24          0.11          0.24
%   y1(t-1)        1.44          0.04          0.37
%   y2(t-1)       -0.23          1.62         -0.96
%   y3(t-1)        0.03          0.01          0.99
%   y1(t-2)       -0.45         -0.03         -0.24
%   y2(t-2)        0.20         -0.65          0.93
%   y3(t-2)       -0.03          0.00         -0.08

BETA = [0.24;0.11;0.24;1.44;-0.23;0.03;0.04;1.62;0.01;0.37;-0.96;0.99;-0.45;0.20;-0.03;-0.03;-0.65;0.00;-0.24;0.93;-0.08]';
SIGMA = [0.10          0.01          0.05;
         0.01          0.06         -0.09;
         0.05         -0.09          0.80;];

SIGMA = chol(SIGMA);

if nargin==0
    T = 190;
    M = 3;
    p = 2;
    K = size(BETA,2);
    
    y = zeros(T+p+50,M);
    y(1:p,:) = rand(p,M);
    
    for t = p+1:T+50        
        if t<=50
            %BETA(1,:) = BETA(1,:) + randn(1,K)*(0.01*eye(K));
            bb1 = BETA(1,1:M);
            bb2 = BETA(1,M+1:end)';
            splace = 0; bb3 = 0;
            for ii = 1:p                                          
                for iii = 1:M           
                    bb3(iii,(ii-1)*M+1:ii*M) = bb2(splace+1:splace+M,1)';
                    splace = splace + M;
                end
            end            
            y(t,:) = bb1 + [y(t-1,:) y(t-2,:)]*bb3' + randn(1,M)*squeeze(SIGMA)';
        elseif t>50
            %BETA(t-50,:) = BETA(t-50,:) + randn(1,K)*(0.01*eye(K));
            bb1 = BETA(1,1:M);
            bb2 = BETA(1,M+1:end)';
            splace = 0; bb3 = 0;
            for ii = 1:p                                          
                for iii = 1:M           
                    bb3(iii,(ii-1)*M+1:ii*M) = bb2(splace+1:splace+M,1)';
                    splace = splace + M;
                end
            end
            y(t,:) = bb1 + [y(t-1,:) y(t-2,:)]*bb3' + randn(1,M)*squeeze(SIGMA);
        end
    end
    y = y(50+1:end,:);
end