function [y,BETA,SIGMA] = VARsim2()

if nargin==0
    T = 200;
    M = 3;
    p = 1;
    K = M*M*p;
    
    y = zeros(T+p+50,M);
    y(1:p,:) = rand(p,M);
    
    BETA = zeros(T+p+50,K);
    SIGMA = zeros(T+p+50,M,M);
    
    BETA(1,:) = [0.5 -0.25 0 0 0.7 0 0.20 -0.05 0.8];
    SIGMA(1,:,:) = 0.5*eye(M);%diag(rand(M,1));
    for t = p+1:T+50+p           
        BETA(t,:) = BETA(t-1,:) + randn(1,K)*(0.01*eye(K));
        vol = diag(squeeze(SIGMA(t-1,:,:)));
        log_vol = 0.97*log(vol + 1e-10) + 0.5*rand*randn(M,1);
        SIGMA(t,:,:) = diag(exp(log_vol));
        y(t,:) = y(t-1,:)*reshape(BETA(t,:),M,M) + randn(1,M)*chol(squeeze(SIGMA(t,:,:)))';
    end
    y = y(50+1:end,:);
    BETA = BETA(50+p+1:end,:);
    SIGMA = SIGMA(50+p+1:end,:,:);
end