% usage: y=crosscov(x,z,n)
% is similar to xcov but truncates cross-covariances
% at lag n and lead n. The 'unbiased' version of
% xcov is used
function y=crosscov(x,z,n)
T=length(x);
if nargin==2,
n=z;
b=xcov(x,'unbiased')*T/(T-1);
else
b=xcov(x,z,'unbiased')*T/(T-1);
end;
c=length(b(:,1));
t=(c+1)/2;
tt=(t+n):-1:(t-n);
y=b(tt,:);
